%define oname python-utmp

%def_with python3

Name: python-module-utmp
Version: 0.8
Release: alt1.1.1

Summary: Python module for working with utmp

License: GPL
Group: Development/Python
Url: http://melkor.dnp.fmph.uniba.sk/~garabik/python-utmp/

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: http://melkor.dnp.fmph.uniba.sk/~garabik/python-utmp/python-utmp_%version.tar.bz2
Patch: %name.patch
Patch1: utmp-0.8-alt-python3.patch

# Automatically added by buildreq on Wed Jan 16 2008
BuildRequires: python-devel

%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel
%endif

%description
This package provides 3 python modules to access utmp and wtmp
records.  utmpaccess is lowlevel module wrapping glibc functions,
UTMPCONST provides useful constants, and utmp is module build on top
of utmpaccess module, providing object oriented interface.

%package -n python3-module-utmp
Summary: Python module for working with utmp
Group: Development/Python3

%description -n python3-module-utmp
This package provides 3 python modules to access utmp and wtmp
records.  utmpaccess is lowlevel module wrapping glibc functions,
UTMPCONST provides useful constants, and utmp is module build on top
of utmpaccess module, providing object oriented interface.

%prep
%setup -n %oname-%version

%if_with python3
cp -fR . ../python3
pushd ../python3
%patch
%patch1 -p2
popd
%endif

%patch

%build
%make_build -f Makefile.glibc \
	PYTHONVER="%_python_version" \
	PYTHONDIR="%python_sitelibdir"

%if_with python3
pushd ../python3
%make_build -f Makefile.glibc \
	PYTHONVER="%_python3_version%_python3_abiflags" \
	PYTHONDIR="%python3_sitelibdir"
popd
%endif

%install
%makeinstall -f Makefile.glibc \
	PYTHONVER="%_python_version" \
	PYTHONDIR="%buildroot%python_sitelibdir"

%if_with python3
pushd ../python3
%makeinstall -f Makefile.glibc \
	PYTHONVER="%_python3_version%_python3_abiflags" \
	PYTHONDIR="%buildroot%python3_sitelibdir"
popd
%endif

%files
%doc README TODO examples/*
%python_sitelibdir/*

%if_with python3
%files -n python3-module-utmp
%doc README TODO examples/*
%python3_sitelibdir/*
%endif

%changelog
