%define oname xlwt
%def_with python3
Name: python-module-xlwt
Version: 1.3.0
Release: alt1

Summary: Library to generate spreadsheet files compatible with Microsoft Excel versions 95 to 2003.

License: BSD-style
Group: Development/Python
Url: http://www.python-excel.org/
BuildArch: noarch

Packager: Andrey Cherepanov <cas@altlinux.org>
Source: %oname-%version.tar
#VCS: https://github.com/python-excel/xlwt

BuildRequires: python-devel
BuildRequires: python-module-setuptools

%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools
%endif


Requires: python >= 2.4

%description
Provide a library for developers to use to generate spreadsheet
files compatible with Microsoft Excel versions 95 to 2003.

The package itself is pure Python with no dependencies on modules or
packages outside the standard Python distribution.

%if_with python3
%package -n python3-module-%oname
Summary: Library to generate spreadsheet files compatible with Microsoft Excel versions 95 to 2003.
Group: Development/Python3

%description -n python3-module-%oname
Provide a library for developers to use to generate spreadsheet
files compatible with Microsoft Excel versions 95 to 2003.

The package itself is pure Python with no dependencies on modules or
packages outside the standard Python distribution.
%endif

%prep
%setup -q -n %oname-%version

%if_with python3
rm -rf ../python3
cp -a . ../python3
#pushd ../python3
#find ./ -type f -name '*.py' -exec 2to3 -w -n '{}' + ||:
%endif


%build
%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%if_with python3
pushd ../python3
%python3_install
popd
%endif

python setup.py install --root=$RPM_BUILD_ROOT --optimize=2 --record=INSTALLED_FILES

mkdir -p %buildroot%_defaultdocdir/%name/
cp -av README.rst docs examples %buildroot%_defaultdocdir/%name/

%files -f INSTALLED_FILES
%doc %_defaultdocdir/%name/

%if_with python3
%files -n python3-module-%oname
%python3_sitelibdir/%{oname}*
%endif

%changelog
