%define _unpackaged_files_terminate_build 1

%define oname zdaemon

%def_with python3

# Because there is race in tests. TODO: try to disable it in next release
%def_without check

Name: python-module-%oname
Version: 4.3
Release: alt2
Summary: Daemon process control library and tools for Unix-based systems
License: ZPL
Group: Development/Python
BuildArch: noarch
Url: http://pypi.python.org/pypi/zdaemon/

# https://github.com/zopefoundation/zdaemon.git
Source: %name-%version.tar

BuildRequires: python-module-setuptools
BuildRequires: python-module-zconfig
BuildRequires: python-module-zope.testrunner
BuildRequires: python-module-zc.customdoctests python-module-mock
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-zconfig
BuildRequires: python3-module-zope.testrunner
BuildRequires: python3-module-zc.customdoctests python3-module-mock
%endif

%description
zdaemon is a Python package which provides APIs for managing
applications run as daemons. Its principal use to date has been to
manage the application server and storage server daemons for Zope / ZEO,
although it is not limited to running Python-based applications (for
instance, it has been used to manage the 'spread' daemon).

%if_with python3
%package -n python3-module-%oname
Summary: Daemon process control library and tools for Unix-based systems (Python 3)
Group: Development/Python3

%description -n python3-module-%oname
zdaemon is a Python package which provides APIs for managing
applications run as daemons. Its principal use to date has been to
manage the application server and storage server daemons for Zope / ZEO,
although it is not limited to running Python-based applications (for
instance, it has been used to manage the 'spread' daemon).

%package -n python3-module-%oname-tests
Summary: Tests for zdaemon (Python 3)
Group: Development/Python3
Requires: python3-module-%oname = %EVR
%py3_requires zope.testing zope.testrunner zc.customdoctests

%description -n python3-module-%oname-tests
zdaemon is a Python package which provides APIs for managing
applications run as daemons. Its principal use to date has been to
manage the application server and storage server daemons for Zope / ZEO,
although it is not limited to running Python-based applications (for
instance, it has been used to manage the 'spread' daemon).

This package contains tests for zdaemon.
%endif

%package tests
Summary: Tests for zdaemon
Group: Development/Python
Requires: %name = %EVR
%py_requires zope.testing zope.testrunner zc.customdoctests

%description tests
zdaemon is a Python package which provides APIs for managing
applications run as daemons. Its principal use to date has been to
manage the application server and storage server daemons for Zope / ZEO,
although it is not limited to running Python-based applications (for
instance, it has been used to manage the 'spread' daemon).

This package contains tests for zdaemon.

%prep
%setup

%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%if_with python3
pushd ../python3
%python3_install
popd
pushd %buildroot%_bindir
for i in * ; do
	mv $i ${i}.py3
done
popd
%endif

%python_install

%check
python setup.py test

%if_with python3
pushd ../python3
python3 setup.py test
popd
%endif

%files
%doc CHANGES.rst COPYRIGHT.txt LICENSE.txt README.rst
%_bindir/zdaemon
%python_sitelibdir/*
%exclude %python_sitelibdir/%oname/tests

%files tests
%python_sitelibdir/%oname/tests

%if_with python3
%files -n python3-module-%oname
%doc CHANGES.rst COPYRIGHT.txt LICENSE.txt README.rst
%_bindir/zdaemon.py3
%python3_sitelibdir/*
%exclude %python3_sitelibdir/%oname/tests

%files -n python3-module-%oname-tests
%python3_sitelibdir/%oname/tests
%endif

%changelog
