%define _unpackaged_files_terminate_build 1
%define oname zope.component

%def_without check

Name: python-module-%oname
Version: 4.5
Release: alt3

Summary: Zope Component Architecture
License: ZPLv2.1
Group: Development/Python
# Source-git https://github.com/zopefoundation/zope.component.git
Url: http://pypi.python.org/pypi/zope.component

Source: %name-%version.tar

BuildRequires(pre): rpm-build-ubt
BuildRequires(pre): rpm-build-python
BuildRequires(pre): rpm-build-python3

BuildRequires: python-module-setuptools
BuildRequires: python3-module-setuptools

%if_with check
BuildRequires: python-module-zope.testing
BuildRequires: python-module-zope.testrunner
BuildRequires: python-module-zope.configuration
BuildRequires: python-module-zope.interface
BuildRequires: python-module-zope.event
BuildRequires: python-module-zope.location
BuildRequires: python-module-zope.proxy
BuildRequires: python-module-zope.security
BuildRequires: python-module-zope.deferredimport
BuildRequires: python-module-zope.hookable
BuildRequires: python-module-zope.deprecation
BuildRequires: python3-module-zope.testing
BuildRequires: python3-module-zope.testrunner
BuildRequires: python3-module-zope.configuration
BuildRequires: python3-module-zope.interface
BuildRequires: python3-module-zope.event
BuildRequires: python3-module-zope.location
BuildRequires: python3-module-zope.proxy
BuildRequires: python3-module-zope.security
BuildRequires: python3-module-zope.deferredimport
BuildRequires: python3-module-zope.hookable
BuildRequires: python3-module-zope.deprecation
%endif

%py_requires zope.interface zope.event zope.configuration
%py_requires zope.deferredimport zope.deprecation
%py_requires zope.hookable zope.i18nmessageid
%py_requires zope.proxy zope.schema zope.security


%description
This package is intended to be independently reusable in any Python
project. It is maintained by the Zope Toolkit project.

This package represents the core of the Zope Component Architecture.
Together with the 'zope.interface' package, it provides facilities for
defining, registering and looking up components.

%package -n python3-module-%oname
Summary: Zope Component Architecture (Python 3)
Group: Development/Python3
%py3_requires zope

%description -n python3-module-%oname
This package is intended to be independently reusable in any Python
project. It is maintained by the Zope Toolkit project.

This package represents the core of the Zope Component Architecture.
Together with the 'zope.interface' package, it provides facilities for
defining, registering and looking up components.

%package -n python3-module-%oname-tests
Summary: Tests for zope.component (Python 3)
Group: Development/Python3
Requires: python3-module-%oname = %EVR
%py3_requires zope.testing zope.testrunner

%description -n python3-module-%oname-tests
This package contains tests for %oname

%package tests
Summary: Tests for zope.component
Group: Development/Python
Requires: %name = %EVR
%py_requires zope.testing zope.testrunner zope.configuration

%description tests
This package contains tests for %oname

%prep
%setup -n %name
rm -rf ../python3
cp -a . ../python3

%build
%python_build
pushd ../python3
%python3_build
popd

%install
%python_install
%if "%python_sitelibdir_noarch" != "%python_sitelibdir"
install -d %buildroot%python_sitelibdir
mv %buildroot%python_sitelibdir_noarch/* \
	%buildroot%python_sitelibdir/
%endif

pushd ../python3
%python3_install
popd
%if "%python3_sitelibdir_noarch" != "%python3_sitelibdir"
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
	%buildroot%python3_sitelibdir/
%endif

%if_with check
%check
export PYTHONPATH=src
zope-testrunner --test-path=src -vv

pushd ../python3
zope-testrunner3 --test-path=src -vv
popd
%endif

%files
%doc *.txt
%python_sitelibdir/*
%exclude %python_sitelibdir/*.pth
%exclude %python_sitelibdir/*/*/test*

%files tests
%python_sitelibdir/*/*/test*

%files -n python3-module-%oname
%doc *.txt
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/*/*/test*
%exclude %python3_sitelibdir/*/*/*/test*

%files -n python3-module-%oname-tests
%python3_sitelibdir/*/*/test*
%python3_sitelibdir/*/*/*/test*

%changelog
