%define oname zope.container

%def_with python3
%def_disable check

Name: python-module-%oname
Version: 4.2.1
Release: alt1.1
Summary: Zope Container
License: ZPL
Group: Development/Python
Url: http://pypi.python.org/pypi/zope.container/

# https://github.com/zopefoundation/zope.container.git
Source: %name-%version.tar

BuildRequires(pre): rpm-macros-sphinx
BuildRequires: python-devel python-module-setuptools
BuildRequires: python-module-pbr python-module-mimeparse python-module-repoze.sphinx.autointerface
BuildRequires: python-module-alabaster python-module-html5lib
%if_enabled check
BuildRequires: python-module-zope.size python-module-zope.testing python-module-zope.location
BuildRequires: python-module-zope.lifecycleevent python-module-zope.security python-module-zope.traversing-tests
BuildRequires: python-module-zope.publisher python-module-zope.publisher python-module-zope.component-tests
BuildRequires: python-module-BTrees
%endif
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools
BuildRequires: python3-module-pbr python3-module-mimeparse python3-module-pytz
BuildRequires: python3-module-html5lib
%if_enabled check
BuildRequires: python3-module-zope.size python3-module-zope.testing python3-module-zope.location
BuildRequires: python3-module-zope.lifecycleevent python3-module-zope.security python3-module-zope.traversing-tests
BuildRequires: python3-module-zope.publisher python3-module-zope.publisher python3-module-zope.component-tests
BuildRequires: python3-module-BTrees
%endif
%endif

Requires: python-module-zope.i18nmessageid
%py_requires zope.interface zope.dottedname zope.schema zope.traversing
%py_requires zope.component zope.event zope.location zope.security
%py_requires zope.lifecycleevent zope.size zope.filerepresentation

%description
This package define interfaces of container components, and provides
container implementations such as a BTreeContainer and OrderedContainer,
as well as the base class used by zope.site.folder for the Folder
implementation.

%if_with python3
%package -n python3-module-%oname
Summary: Zope Container
Group: Development/Python3
Requires: python3-module-zope.i18nmessageid
%py3_requires zope.interface zope.dottedname zope.schema 
%py3_requires zope.component zope.event zope.location zope.security
%py3_requires zope.lifecycleevent

%description -n python3-module-%oname
This package define interfaces of container components, and provides
container implementations such as a BTreeContainer and OrderedContainer,
as well as the base class used by zope.site.folder for the Folder
implementation.

%package -n python3-module-%oname-tests
Summary: Tests for Zope Container
Group: Development/Python3
Requires: python3-module-%oname = %version-%release
%py3_requires zope.testing

%description -n python3-module-%oname-tests
This package define interfaces of container components, and provides
container implementations such as a BTreeContainer and OrderedContainer,
as well as the base class used by zope.site.folder for the Folder
implementation.

This package contains tests for Zope Container.
%endif

%package pickles
Summary: Pickles for Zope Container
Group: Development/Python

%description pickles
This package define interfaces of container components, and provides
container implementations such as a BTreeContainer and OrderedContainer,
as well as the base class used by zope.site.folder for the Folder
implementation.

This package contains pickles for Zope Container.

%package tests
Summary: Tests for Zope Container
Group: Development/Python
Requires: %name = %version-%release
%py_requires zope.testing

%description tests
This package define interfaces of container components, and provides
container implementations such as a BTreeContainer and OrderedContainer,
as well as the base class used by zope.site.folder for the Folder
implementation.

This package contains tests for Zope Container.

%prep
%setup

rm -fR src/*.egg-info

%if_with python3
cp -fR . ../python3
%endif

%prepare_sphinx .
ln -s ../objects.inv docs/

%build
%add_optflags -fno-strict-aliasing
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%make -C docs pickle
%make -C docs html
install -d %buildroot%python_sitelibdir/%oname
cp -fR docs/_build/pickle %buildroot%python_sitelibdir/%oname/

%check
rm -fR build
py.test -vv
%if_with python3
pushd ../python3
rm -fR build
py.test3 -vv
popd
%endif

%files
%doc *.txt *.rst docs/_build/html
%python_sitelibdir/*
%exclude %python_sitelibdir/*.pth
%exclude %python_sitelibdir/*/*/test*
%exclude %python_sitelibdir/*/pickle

%files pickles
%python_sitelibdir/*/pickle

%files tests
%python_sitelibdir/*/*/tests
%python_sitelibdir/*/*/test*

%if_with python3
%files -n python3-module-%oname
%doc *.txt *.rst docs/_build/html
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/*/*/test*
%exclude %python3_sitelibdir/*/*/*/test*

%files -n python3-module-%oname-tests
%python3_sitelibdir/*/*/test*
%python3_sitelibdir/*/*/*/test*
%endif

%changelog
