%define _unpackaged_files_terminate_build 1
%define oname zope.publisher

# skip for now due to cyclic deps
%def_disable check
%def_with check

Name: python-module-%oname
Epoch: 1
Version: 4.3.2
Release: alt3

Summary: The Zope publisher publishes Python objects on the web
License: ZPLv2.1
Group: Development/Python
# Source-git https://github.com/zopefoundation/zope.publisher.git
Url: http://pypi.python.org/pypi/zope.publisher

Source: %name-%version.tar
Patch: %name-%version-alt.patch
Patch1: %oname-fix-tests.patch

BuildRequires(pre): rpm-build-ubt
BuildRequires(pre): rpm-build-python
BuildRequires(pre): rpm-build-python3

BuildRequires: python-module-setuptools
BuildRequires: python3-module-setuptools

%if_with check
BuildRequires: python-module-zope.browser
BuildRequires: python-module-zope.component
BuildRequires: python-module-zope.component-tests
BuildRequires: python-module-zope.contenttype
BuildRequires: python-module-zope.i18n
BuildRequires: python-module-zope.interface-tests
BuildRequires: python-module-zope.testing
BuildRequires: python-module-zope.testrunner
BuildRequires: python-module-zope.security
BuildRequires: python-module-zope.security-tests
BuildRequires: python-module-zope.deferredimport
BuildRequires: python-module-zope.hookable
BuildRequires: python-module-zope.deprecation
BuildRequires: python-module-zope.event
BuildRequires: python3-module-zope.browser
BuildRequires: python3-module-zope.component
BuildRequires: python3-module-zope.component-tests
BuildRequires: python3-module-zope.contenttype
BuildRequires: python3-module-zope.i18n
BuildRequires: python3-module-zope.interface-tests
BuildRequires: python3-module-zope.testing
BuildRequires: python3-module-zope.testrunner
BuildRequires: python3-module-zope.security
BuildRequires: python3-module-zope.security-tests
BuildRequires: python3-module-zope.deferredimport
BuildRequires: python3-module-zope.hookable
BuildRequires: python3-module-zope.deprecation
BuildRequires: python3-module-zope.event
%endif

%py_requires zope.browser
%py_requires zope.component
%py_requires zope.configuration
%py_requires zope.contenttype
%py_requires zope.event
%py_requires zope.exceptions
%py_requires zope.i18n
%py_requires zope.interface
%py_requires zope.location
%py_requires zope.proxy
%py_requires zope.security
%py_requires zope.deferredimport
%py_requires zope.hookable
%py_requires zope.deprecation


%description
zope.publisher allows you to publish Python objects on the web. It has
support for plain HTTP/WebDAV clients, web browsers as well as XML-RPC
and FTP clients. Input and output streams are represented by request and
response objects which allow for easy client interaction from Python.
The behaviour of the publisher is geared towards WSGI compatibility.

%package -n python3-module-%oname
Summary: The Zope publisher publishes Python objects on the web
Group: Development/Python3
%py3_requires zope.browser
%py3_requires zope.component
%py3_requires zope.configuration
%py3_requires zope.contenttype
%py3_requires zope.event
%py3_requires zope.exceptions
%py3_requires zope.i18n
%py3_requires zope.interface
%py3_requires zope.location
%py3_requires zope.proxy
%py3_requires zope.security
%py3_requires zope.deferredimport
%py3_requires zope.hookable
%py3_requires zope.deprecation

%description -n python3-module-%oname
zope.publisher allows you to publish Python objects on the web. It has
support for plain HTTP/WebDAV clients, web browsers as well as XML-RPC
and FTP clients. Input and output streams are represented by request and
response objects which allow for easy client interaction from Python.
The behaviour of the publisher is geared towards WSGI compatibility.

%package -n python3-module-%oname-tests
Summary: Tests for zope.publisher
Group: Development/Python3
Requires: python3-module-%oname = %EVR
%py3_requires zope.testrunner
%py3_requires zope.testing
Requires: python3-module-zope.security-tests
Requires: python3-module-zope.component-tests
Requires: python3-module-zope.interface-tests

%description -n python3-module-%oname-tests
This package contains tests for %oname.

%package tests
Summary: Tests for zope.publisher
Group: Development/Python
Requires: %name = %EVR
%py_requires zope.testrunner
%py_requires zope.testing
Requires: python-module-zope.security-tests
Requires: python-module-zope.component-tests
Requires: python-module-zope.interface-tests

%description tests
This package contains tests for %oname.

%prep
%setup
%patch0 -p1
%patch1 -p2

rm -rf ../python3
cp -a . ../python3

%build
%python_build

pushd ../python3
%python3_build
popd

%install
%python_install
%if "%python_sitelibdir_noarch" != "%python_sitelibdir"
install -d %buildroot%python_sitelibdir
mv %buildroot%python_sitelibdir_noarch/* \
	%buildroot%python_sitelibdir/
%endif

pushd ../python3
%python3_install
popd
%if "%python3_sitelibdir_noarch" != "%python3_sitelibdir"
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
	%buildroot%python3_sitelibdir/
%endif

%check
export PYTHONPATH=src
zope-testrunner --test-path=src -vv

pushd ../python3
zope-testrunner3 --test-path=src -vv
popd

%files
%doc *.txt *.rst
%python_sitelibdir/*
%exclude %python_sitelibdir/*.pth
%exclude %python_sitelibdir/*/*/test*

%files tests
%python_sitelibdir/*/*/test*

%files -n python3-module-%oname
%doc *.txt *.rst
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/*/*/test*
%exclude %python3_sitelibdir/*/*/*/test*

%files -n python3-module-%oname-tests
%python3_sitelibdir/*/*/test*
%python3_sitelibdir/*/*/*/test*

%changelog
