%define oname zope.schema
%def_without check

Name: python-module-%oname
Version: 4.9.3
Release: alt1

Summary: zope.interface extension for defining data schemas
License: ZPLv2.1
Group: Development/Python
Url: http://pypi.python.org/pypi/zope.schema/
# https://github.com/zopefoundation/zope.schema.git

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-macros-sphinx

BuildRequires: python-module-setuptools
BuildRequires: python-module-alabaster
BuildRequires: python-module-coverage
BuildRequires: python-module-docutils
BuildRequires: python-module-html5lib
BuildRequires: python-module-nosexcover
BuildRequires: python-module-objects.inv
BuildRequires: python-module-repoze.sphinx.autointerface
BuildRequires: python-module-zope.event
BuildRequires: python-module-zope.testing
BuildRequires: python-module-zope.i18nmessageid
BuildRequires: time

BuildPreReq: python3-module-setuptools
BuildPreReq: python3-module-coverage
BuildPreReq: python3-module-nosexcover
BuildPreReq: python3-module-zope.event
BuildPreReq: python3-module-zope.testing
BuildPreReq: python3-module-zope.i18nmessageid

%py_requires zope.interface zope.event


%description
This package is intended to be independently reusable in any Python
project. It is maintained by the Zope Toolkit project.

Schemas extend the notion of interfaces to detailed descriptions of
Attributes (but not methods). Every schema is an interface and specifies
the public fields of an object. A field roughly corresponds to an
attribute of a python object. But a Field provides space for at least a
title and a description. It can also constrain its value and provide a
validation method. Besides you can optionally specify characteristics
such as its value being read-only or not required.

%package -n python3-module-%oname
Summary: zope.interface extension for defining data schemas (Python 3)
Group: Development/Python3
%py3_requires zope.interface zope.event

%description -n python3-module-%oname
This package is intended to be independently reusable in any Python
project. It is maintained by the Zope Toolkit project.

Schemas extend the notion of interfaces to detailed descriptions of
Attributes (but not methods). Every schema is an interface and specifies
the public fields of an object. A field roughly corresponds to an
attribute of a python object. But a Field provides space for at least a
title and a description. It can also constrain its value and provide a
validation method. Besides you can optionally specify characteristics
such as its value being read-only or not required.

%package -n python3-module-%oname-tests
Summary: Tests for zope.schema (Python 3)
Group: Development/Python3
Requires: python3-module-%oname = %version-%release
%py3_requires zope.testing

%description -n python3-module-%oname-tests
This package is intended to be independently reusable in any Python
project. It is maintained by the Zope Toolkit project.

Schemas extend the notion of interfaces to detailed descriptions of
Attributes (but not methods). Every schema is an interface and specifies
the public fields of an object. A field roughly corresponds to an
attribute of a python object. But a Field provides space for at least a
title and a description. It can also constrain its value and provide a
validation method. Besides you can optionally specify characteristics
such as its value being read-only or not required.

This package contains tests for zope.schema

%package pickles
Summary: Pickles for zope.schema
Group: Development/Python

%description pickles
This package is intended to be independently reusable in any Python
project. It is maintained by the Zope Toolkit project.

Schemas extend the notion of interfaces to detailed descriptions of
Attributes (but not methods). Every schema is an interface and specifies
the public fields of an object. A field roughly corresponds to an
attribute of a python object. But a Field provides space for at least a
title and a description. It can also constrain its value and provide a
validation method. Besides you can optionally specify characteristics
such as its value being read-only or not required.

This package contains pickles for zope.schema

%package tests
Summary: Tests for zope.schema
Group: Development/Python
Requires: %name = %version-%release
%py_requires zope.testing

%description tests
This package is intended to be independently reusable in any Python
project. It is maintained by the Zope Toolkit project.

Schemas extend the notion of interfaces to detailed descriptions of
Attributes (but not methods). Every schema is an interface and specifies
the public fields of an object. A field roughly corresponds to an
attribute of a python object. But a Field provides space for at least a
title and a description. It can also constrain its value and provide a
validation method. Besides you can optionally specify characteristics
such as its value being read-only or not required.

This package contains tests for zope.schema

%prep
%setup

rm -rf ../python3
cp -a . ../python3

%prepare_sphinx .
ln -s ../objects.inv docs/

%build
%python_build

pushd ../python3
%python3_build
popd

%install
%python_install
%if "%python_sitelibdir_noarch" != "%python_sitelibdir"
install -d %buildroot%python_sitelibdir
mv %buildroot%python_sitelibdir_noarch/* \
	%buildroot%python_sitelibdir/
%endif

pushd ../python3
%python3_install
popd
%if "%python3_sitelibdir_noarch" != "%python3_sitelibdir"
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
	%buildroot%python3_sitelibdir/
%endif

%make -C docs pickle
%make -C docs html
install -d %buildroot%python_sitelibdir/%oname
cp -fR docs/_build/pickle %buildroot%python_sitelibdir/%oname/

%if_with check
%check
python setup.py test -v
nosetests -vv --with-xunit --with-xcoverage

pushd ../python3
python3 setup.py test -v
#nosetests3 -vv --with-xunit --with-xcoverage
popd
%endif

%files
%doc *.txt *.rst docs/_build/html
%python_sitelibdir/*
%exclude %python_sitelibdir/*.pth
%exclude %python_sitelibdir/*/*/tests
%exclude %python_sitelibdir/*/pickle

%files pickles
%python_sitelibdir/*/pickle

%files tests
%python_sitelibdir/*/*/tests

%files -n python3-module-%oname
%doc *.txt *.rst docs/_build/html
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/*/*/tests

%files -n python3-module-%oname-tests
%python3_sitelibdir/*/*/tests


%changelog
