%def_with python3

%global module_name pep8

Name:           python-tools-%{module_name}
Version:        1.6.2
Release:        alt2
Summary:        Python style guide checker

Group:          Development/Python
# License is held in the comments of pep8.py
# setup.py claims license is Expat license, which is the same as MIT
License:        MIT
URL:            http://pypi.python.org/pypi/%{module_name}
Source0:        %{name}-%{version}.tar
Patch1:         pep8-1.6.2-Keep-compability-with-stdlib-tokenize.py-changes.patch

BuildArch:      noarch
BuildRequires:  python-devel
BuildRequires:  python-module-setuptools
BuildRequires:  python-module-sphinx
Requires:       python-module-setuptools

%description
pep8 is a tool to check your Python code against some of the style conventions
in PEP 8. It has a plugin architecture, making new checks easy, and its output
is parseable, making it easy to jump to an error location in your editor.

%if_with python3
%package -n python3-tools-pep8
Summary:    Python style guide checker
Group:      Development/Python

BuildRequires:  rpm-build-python3
BuildRequires:  python3-module-setuptools
BuildRequires:  python3-module-sphinx
 
Requires:  python3-module-setuptools

%description -n python3-tools-pep8
pep8 is a tool to check your Python code against some of the style
conventions in PEP 8. It has a plugin architecture, making new checks
easy, and its output is parseable, making it easy to jump to an error
location in your editor.

This is a version for Python 3.

%endif


%prep
%setup
%patch1 -p1
# Remove #! from pep8.py
sed --in-place "s:#!\s*/usr.*::" pep8.py

%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%python_build build_sphinx

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%if_with python3
pushd ../python3
%python3_install
mv %{buildroot}%{_bindir}/pep8 %{buildroot}%{_bindir}/python3-pep8
popd
%endif

%python_install

%check
python pep8.py --testsuite testsuite
python pep8.py --doctest

%if_with python3
pushd ../python3
PYTHONPATH="%{buildroot}%{python3_sitelibdir}:$PYTHONPATH" %{__python3} pep8.py --testsuite testsuite
popd
%endif


%files
%doc CHANGES.txt README.rst build/sphinx/html/*
%{_bindir}/pep8
%{python_sitelibdir}/%{module_name}.py*
%{python_sitelibdir}/%{module_name}-%{version}-*.egg-info

%if_with python3
%files -n python3-tools-pep8
%doc README.rst CHANGES.txt build/sphinx/html/*
%{_bindir}/python3-pep8
%{python3_sitelibdir}/%{module_name}.py*
%{python3_sitelibdir}/%{module_name}-%{version}-*.egg-info/
%{python3_sitelibdir}/__pycache__/%{module_name}*
%endif

%changelog
