%define oname aiohttp

%def_with python3
# def_with docs needed package python3-modile-sphinxcontrib-blockdiag (missing in Sisyphus)
%def_without docs
%def_without check

Name: python3-module-%oname
Version: 3.6.2
Release: alt1
Summary: http client/server for asyncio
License: ASLv2.0
Group: Development/Python3
Url: https://github.com/KeepSafe/aiohttp.git
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools python3-module-Cython
%if_with check
BuildRequires: python3-module-multidict python3-module-yarl python3-module-async-timeout python3-module-pytest-mock
BuildRequires: python3-module-pytest-runner
%endif
%if_with docs
BuildRequires(pre): python3-module-sphinx-devel
BuildRequires: python3-module-sphinxcontrib-asyncio python3-module-sphinxcontrib-newsfeed
%endif
%py3_requires chardet idna_ssl

%description
http client/server for asyncio (PEP-3156).

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: python3-module-%oname = %EVR

%description tests
http client/server for asyncio (PEP-3156).

This package contains tests for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
http client/server for asyncio (PEP-3156).

This package contains documentation for %oname.

%prep
%setup

%if_with docs
%prepare_sphinx3 .
ln -s ../objects.inv docs/
%endif

%build
%python3_build_debug

%if_with docs
%make_build -C docs html SPHINXBUILD=py3_sphinx-build
%endif

%install
%python3_install

%if_with check
%check
python3 setup.py test
%endif

%if_with docs
%files docs
%doc docs/_build/html/*
%endif

%files -n python3-module-%oname
%doc *.txt *.rst examples
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/*test*
%exclude %python3_sitelibdir/*/*/*test*

%files -n python3-module-%oname-tests
%python3_sitelibdir/*/*test*
%python3_sitelibdir/*/*/*test*

%changelog
