%define major 2.28
%define oname pygobject
%define gtk_api_ver 2.0
%def_disable introspection

Name: python3-module-pygobject
Version: %major.6
Release: alt10.1.1.1
Summary: Python 3 bindings for GObject

License: LGPL
Group: Development/Python3
Url: http://www.pygtk.org/

Source: http://ftp.gnome.org/pub/GNOME/sources/%oname/%major/%oname-%version.tar

%add_python_lib_path  %python3_sitelibdir/gtk-%gtk_api_ver
%add_findprov_lib_path %python3_sitelibdir/gtk-%gtk_api_ver/gtk
%{?_enable_introspection:%add_findprov_lib_path %python3_sitelibdir/gtk-%gtk_api_ver/gi}
%{?_enable_introspection:Requires: python-module-pygi = %version-%release}

%define glib_ver 2.28.0

BuildRequires(pre): rpm-build-python3
BuildPreReq: glib2-devel >= %glib_ver libgio-devel libffi-devel
BuildRequires: python3-devel python3-module-pycairo-devel python3-module-pycairo python-tools-2to3
%{?_enable_introspection:BuildPreReq: gobject-introspection-devel >= 0.10.2}

%requires_python3_ABI_for_files %_libdir/libpyglib-2.0-python3.so.0.0.0

%py3_provides scmexpr
# ? python-modules
%add_python_req_skip keyword scmexpr
%add_python3_req_skip _gio

%description
This package provides Python bindings for the GLib, GObject and GIO,
to be used in Python. It is a fairly complete set of bindings,
it's already rather useful, and is usable to write moderately
complex programs.  (see the examples directory for some examples
of the simpler programs you could write).

%package devel
Summary: Development files for %oname
Group: Development/Python3
Requires: %name = %version-%release
Conflicts: python-module-pygobject-devel
AutoReq: yes,nopython
%add_python_req_skip keyword scmexpr

%description devel
Development files for %oname.

%package devel-doc
Summary: Development documentation for %oname
Group: Development/Python3
BuildArch: noarch

%description devel-doc
Development documentation for %oname.

%package -n python-module-pygi
Summary: Python dynamic bindings based on GObject-Introspection
Group: Development/Python3
%{?_enable_introspection:%setup_python_module pygi}
Requires: %name = %version-%release

%description -n python-module-pygi
PyGI is a module which aims to utilize GObject Introspection to
facilitate the creation of Python bindings.

%prep
%setup -q -n %oname-%version

find -type f -name '*.py' -exec sed -i 's|%_bindir/env python|%_bindir/python3|' -- '{}' +

%build
export PYTHON=python3
%autoreconf
%configure --with-pic --disable-static \
	%{subst_enable introspection}

%make_build

%check
#%%make check

%install
%make_install install DESTDIR=%buildroot
mkdir -p %buildroot%_includedir/python%_python3_version
mv %buildroot%_includedir/pygtk-%gtk_api_ver %buildroot%_includedir/python%_python3_version/pygtk
%__subst "s|\${includedir}/pygtk-%gtk_api_ver|\${includedir}/python%_python3_version/pygtk|g" %buildroot/%_pkgconfigdir/*.pc

sed -i 's|%_bindir/env python|%_bindir/env python3|' \
	%buildroot%_datadir/pygobject/xsl/fixxref.py

find %buildroot -type f -name '*.py' -exec 2to3 -w '{}' +

%files
%_libdir/libpyglib-2.0-python3*.so.*
%python3_sitelibdir/pygtk.*
%python3_sitelibdir/__pycache__/pygtk.*
%python3_sitelibdir/gobject
%python3_sitelibdir/glib
%dir %python3_sitelibdir/gtk-%gtk_api_ver
%python3_sitelibdir/gtk-%gtk_api_ver/gio

%files devel
#_bindir/py3_pygobject-codegen-2.0
%_libdir/libpyglib-2.0-python3*.so
%_includedir/python%_python3_version/pygtk
%python3_sitelibdir/gtk-%gtk_api_ver/dsextras.*
%python3_sitelibdir/gtk-%gtk_api_ver/__pycache__/dsextras.*
%_datadir/pygobject/2.0
%_datadir/pygobject/xsl
%_pkgconfigdir/pygobject-2.0.pc
%doc README AUTHORS NEWS examples

%exclude %python3_sitelibdir/*/*.la

%files devel-doc
%_datadir/gtk-doc/html/pygobject/

%if_enabled introspection
%files -n python-module-pygi
%python3_sitelibdir/gi/
%exclude %python3_sitelibdir/gi/*.la
%endif

%changelog
