%define _unpackaged_files_terminate_build 1
%define oname pylint

%def_with check

Name: python3-module-%oname
Version: 2.3.1
Release: alt1

Summary: Python code static checker
License: GPLv2+
Group: Development/Python3
# https://github.com/PyCQA/pylint.git
Url: http://www.pylint.org/

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3

%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-pytest-runner
BuildRequires: python3-module-pytest-xdist
BuildRequires: python3-module-astroid
BuildRequires: python3-module-mccabe
BuildRequires: python3-module-isort
BuildRequires: python3-module-enchant
BuildRequires: python3-module-tox
BuildRequires: hunspell-en
%endif

BuildArch: noarch
Provides: pylint-py3 = %EVR
Obsoletes: pylint-py3 < %EVR
%py3_requires mccabe

%description
Pylint is a Python source code analyzer which looks for programming
errors, helps enforcing a coding standard and sniffs for some code
smells (as defined in Martin Fowler's Refactoring book)

Pylint can be seen as another PyChecker since nearly all tests you
can do with PyChecker can also be done with Pylint. However, Pylint
offers some more features, like checking length of lines of code,
checking if variable names are well-formed according to your coding
standard, or checking if declared interfaces are truly implemented,
and much more.

Additionally, it is possible to write plugins to add your own checks.

%prep
%setup

%build
%python3_build

%install

%python3_install
# do not pack tests
rm -r %buildroot%python3_sitelibdir/pylint/test*

pushd %buildroot%_bindir
for i in $(ls); do
       mv $i $i.py3
done

%check
grep -qs '[[:space:]]*coverage[[:space:]]*$' tox.ini || exit 1
grep -qs ' {envsitepackagesdir}/coverage run ' tox.ini || exit 1
grep -qs 'https:' tox.ini || exit 1
grep -qsP 'python -c \x22import os' tox.ini || exit 1

sed -i -e '/[[:space:]]*coverage[[:space:]]*$/d' \
-e 's/ {envsitepackagesdir}\/coverage run / /' \
-e 's/https:.*/astroid/' \
-e '/python -c \x22import os/d' tox.ini

export PIP_NO_INDEX=YES
export PIP_NO_DEPS=YES
export TOXENV=py%{python_version_nodots python3}
tox.py3 --sitepackages -p auto -o -v

%files
%doc ChangeLog README.rst doc/
%_bindir/pylint.py3
%_bindir/epylint.py3
%_bindir/pyreverse.py3
%_bindir/symilar.py3
%python3_sitelibdir/pylint/
%python3_sitelibdir/pylint-*.egg-info/

%changelog
