%define _unpackaged_files_terminate_build 1

%define oname traits

Name: python3-module-%oname
Version: 6.1.1
Release: alt1
Summary: Explicitly typed attributes for Python 3
Group: Development/Python3
# Images have different licenses. For image license breakdown check
# image_LICENSE.txt file. Except enthought/traits/ui/editors_gen.py
# which is GPLv2+ all remaining source or image files are in BSD
# 3-clause license. Confirmed from upstream.
License: BSD and EPL and LGPLv2 and GPLv2+
URL: https://docs.enthought.com/traits/

# https://github.com/enthought/traits.git
Source: %name-%version.tar

Patch1: %oname-alt-docs.patch

BuildRequires(pre): python3-module-sphinx-devel
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-distribute
BuildRequires: libnumpy-py3-devel
BuildRequires: python3-module-Pygments
BuildRequires: python3-module-sphinx-pickles
BuildRequires: python3-module-sphinx-sphinx-build-symlink

%description
The traits package developed by Enthought provides a special type
definition called a trait. Although they can be used as normal Python object 
attributes, traits also have several additional characteristics: 

* Initialization: A trait can be assigned a default value.
* Validation: A trait attribute's type can be explicitly declared.
* Delegation: The value of a trait attribute can be contained either
  in another object.
* Notification: Setting the value of a trait attribute can trigger
  notification of other parts of the program.
* Visualization: User interfaces that permit the interactive
  modification of a trait's value can be automatically constructed
  using the trait's definition.

%package tests
Summary: Tests for Traits, explicitly typed attributes for Python 3
Group: Development/Python3
Requires: %name = %EVR

%description tests
The traits package developed by Enthought provides a special type
definition called a trait. This package contains tests for it.

%package doc
Summary: Documentation for Traits, explicitly typed attributes for Python
Group: Development/Documentation
BuildArch: noarch

%description doc
The traits package developed by Enthought provides a special type
definition called a trait. This package contains development
documentation for it.

%package pickles
Summary: Pickles for Traits, explicitly typed attributes for Python
Group: Development/Python3

%description pickles
The traits package developed by Enthought provides a special type
definition called a trait. This package contains pickles for it.

%prep
%setup
%patch1 -p1

# file not utf-8
iconv -f iso8859-1 -t utf-8 < image_LICENSE_Eclipse.txt > image_LICENSE_Eclipse.txt.conv && \
	mv -f image_LICENSE_Eclipse.txt.conv image_LICENSE_Eclipse.txt

%prepare_sphinx3 docs

%build
%add_optflags -fno-strict-aliasing
%python3_build_debug

%install
%python3_install

# pickles
install -d %buildroot%python3_sitelibdir/%oname
export PYTHONPATH=%buildroot%python3_sitelibdir
make -C docs html
%generate_pickles3 docs/source docs/source %oname
cp -fR pickle %buildroot%python3_sitelibdir/%oname/

%files
%doc image_LICENSE*.txt LICENSE.txt
%doc README.rst CHANGES.rst
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version-py*.egg-info
%exclude %python3_sitelibdir/%oname/tests
%exclude %python3_sitelibdir/%oname/*/tests
%exclude %python3_sitelibdir/%oname/testing
%exclude %python3_sitelibdir/%oname/pickle

%files tests
%python3_sitelibdir/%oname/tests
%python3_sitelibdir/%oname/*/tests
%python3_sitelibdir/%oname/testing

%files doc
%doc examples
%doc docs/build/html

%files pickles
%python3_sitelibdir/%oname/pickle

%changelog
