# vim: set ft=spec
# vim600: set fdm=marker:

# {{{ macros define
%define _unpackaged_files_terminate_build 1
%def_disable edk2_cross

%def_enable user_static

%def_enable sdl
%def_enable curses
%def_enable vnc
%def_enable vnc_sasl
%def_enable vnc_jpeg
%def_enable vnc_png
%def_enable xkbcommon
%def_disable vde
%def_enable alsa
%def_enable pulseaudio
%def_enable oss
%def_disable jack
%def_enable aio
%def_enable io_uring
%def_enable blobs
%def_enable smartcard
%def_enable libusb
%def_enable usb_redir
%def_enable vhost_crypto
%def_enable vhost_net
%def_enable vhost_scsi
%def_enable vhost_vsock
%def_enable vhost_user_fs
%def_enable opengl
%def_enable guest_agent
%def_enable tools
%def_enable spice
%def_enable libiscsi
%ifarch %ix86 %arm %mips32 ppc
%def_disable rbd
%else
%def_enable rbd
%endif
%def_enable libnfs
%def_enable zstd
%def_enable seccomp
%def_enable glusterfs
%def_enable gtk
%def_disable gtk_gl
%def_enable gnutls
%def_enable nettle
%def_disable gcrypt
%def_enable virglrenderer
%def_enable tpm
%def_enable libssh
%def_enable live_block_migration
%ifnarch armh
%def_enable numa
%else
%def_disable numa
%endif
%def_disable tcmalloc
%def_disable jemalloc
%def_enable replication
%def_enable rdma
%def_enable lzo
%def_enable snappy
%def_enable bzip2
%def_disable lzfse
%def_disable xen
%def_enable mpath
%def_enable libxml2
%def_disable libpmem
%def_enable libudev
%def_enable libdaxctl
%def_disable brlapi

%define power64 ppc64 ppc64p7 ppc64le
%define mips32 mips mipsel mipsr6 mipsr6el
%define mips64 mips64 mips64el mips64r6 mips64r6el
%define mips_arch %mips32 %mips64

%ifarch %ix86
%global kvm_package system-x86
%def_enable qemu_kvm
%endif
%ifarch x86_64
%global kvm_package system-x86
%def_enable qemu_kvm
%endif
%ifarch %power64
%global kvm_package   system-ppc
%def_enable qemu_kvm
%endif
%ifarch s390x
%global kvm_package   system-s390x
%endif
%ifarch armh
%global kvm_package   system-arm
%def_enable qemu_kvm
%endif
%ifarch aarch64
%global kvm_package   system-aarch64
%def_enable qemu_kvm
%endif
%ifarch riscv64
%global kvm_package   system-riscv
%def_enable qemu_kvm
%endif
%ifarch %mips_arch
%global kvm_package   system-mips
%endif

%def_enable have_kvm

%define audio_drv_list %{?_enable_oss:oss} %{?_enable_alsa:alsa} %{?_enable_sdl:sdl} %{?_enable_pulseaudio:pa} %{?_enable_jack:jack}
%define block_drv_list curl dmg %{?_enable_glusterfs:gluster} %{?_enable_libiscsi:iscsi} %{?_enable_libnfs:nfs} %{?_enable_rbd:rbd} %{?_enable_libssh:ssh}
%define ui_list %{?_enable_gtk:gtk} %{?_enable_curses:curses} %{?_enable_sdl:sdl} %{?_enable_opengl:opengl}
%define ui_spice_list %{?_enable_spice:app core}
%define device_usb_list redirect smartcard
%define device_display_list virtio-gpu-pci %{?_enable_virglrenderer:virtio-gpu} virtio-vga
%define qemu_arches aarch64 alpha arm avr cris hppa m68k microblaze mips moxie nios2 or1k ppc riscv rx s390x sh4 sparc tricore x86 xtensa

%global _group vmusers
%global rulenum 90
%global _libexecdir /usr/libexec
%global _localstatedir /var
%global firmwarepath /usr/share/qemu:/usr/share/seabios:/usr/share/seavgabios:/usr/share/ipxe:/usr/share/ipxe.efi

# }}}

Name: qemu
Version: 5.2.0
Release: alt6

Summary: QEMU CPU Emulator
License: BSD-2-Clause AND BSD-3-Clause AND GPL-2.0-only AND GPL-2.0-or-later AND LGPL-2.1-or-later AND MIT
Group: Emulators
Url: https://www.qemu.org
# git://git.qemu.org/qemu.git
Source0: %name-%version.tar
Source100: keycodemapdb.tar
Source101: berkeley-testfloat-3.tar
Source102: berkeley-softfloat-3.tar
Source2: qemu-kvm.control.in
Source4: qemu-kvm.rules
# qemu-kvm back compat wrapper
Source5: qemu-kvm.sh
# guest agent service
Source8: qemu-guest-agent.rules
Source9: qemu-guest-agent.service
Source10: qemu-guest-agent.init
Source11: qemu-ga.sysconfig
# /etc/qemu/bridge.conf
Source12: bridge.conf

Patch: qemu-alt.patch

%set_verify_elf_method fhs=relaxed
%add_verify_elf_skiplist %_datadir/%name/*
%add_findreq_skiplist %_datadir/%name/*

Requires: %name-system = %EVR
Requires: %name-user = %EVR

BuildRequires(pre): rpm-build-python3
BuildRequires: meson >= 0.55.0
BuildRequires: glibc-devel-static zlib-devel-static glib2-devel-static libpcre-devel-static libattr-devel-static
BuildRequires: glib2-devel >= 2.48 libgio-devel
BuildRequires: makeinfo perl-devel python3-module-sphinx
BuildRequires: libcap-ng-devel
BuildRequires: libxfs-devel
BuildRequires: zlib-devel libcurl-devel libpci-devel glibc-kernheaders
BuildRequires: ipxe-roms-qemu >= 1:20161208-alt1.git26050fd seavgabios seabios >= 1.7.4-alt2 libfdt-devel >= 1.5.0.0.20.2431 qboot
BuildRequires: libpixman-devel >= 0.21.8
BuildRequires: python3-devel
%{?_enable_sdl:BuildRequires: libSDL2-devel}
%{?_enable_curses:BuildRequires: libncursesw-devel}
%{?_enable_alsa:BuildRequires: libalsa-devel}
%{?_enable_pulseaudio:BuildRequires: libpulseaudio-devel}
%{?_enable_jack:BuildRequires: libjack-devel}
%{?_enable_vnc_sasl:BuildRequires: libsasl2-devel}
%{?_enable_vnc_jpeg:BuildRequires: libjpeg-devel}
%{?_enable_vnc_png:BuildRequires: libpng-devel}
%{?_enable_xkbcommon:BuildRequires: libxkbcommon-devel}
%{?_enable_vde:BuildRequires: libvde-devel}
%{?_enable_aio:BuildRequires: libaio-devel}
%{?_enable_io_uring:BuildRequires: liburing-devel}
%{?_enable_spice:BuildRequires: libspice-server-devel >= 0.12.5 spice-protocol >= 0.12.3}
BuildRequires: libuuid-devel
%{?_enable_smartcard:BuildRequires: libcacard-devel >= 2.5.1}
%{?_enable_usb_redir:BuildRequires: libusbredir-devel >= 0.5}
%{?_enable_opengl:BuildRequires: libepoxy-devel libgbm-devel}
%{?_enable_guest_agent:BuildRequires: glib2-devel >= 2.38}
%{?_enable_rbd:BuildRequires: ceph-devel}
%{?_enable_libiscsi:BuildRequires: libiscsi-devel >= 1.9.0}
%{?_enable_libnfs:BuildRequires: libnfs-devel >= 1.9.3}
%{?_enable_zstd:BuildRequires: libzstd-devel >= 1.4.0}
%{?_enable_seccomp:BuildRequires: libseccomp-devel >= 2.3.0}
%{?_enable_glusterfs:BuildRequires: pkgconfig(glusterfs-api)}
%{?_enable_gtk:BuildRequires: libgtk+3-devel >= 3.22.0 libvte3-devel >= 0.32.0}
%{?_enable_gnutls:BuildRequires: libgnutls-devel >= 3.1.18}
%{?_enable_nettle:BuildRequires: libnettle-devel >= 2.7.1}
%{?_enable_gcrypt:BuildRequires: libgcrypt-devel >= 1.5.0}
BuildRequires: libpam-devel
BuildRequires: libtasn1-devel
BuildRequires: libslirp-devel
%{?_enable_virglrenderer:BuildRequires: pkgconfig(virglrenderer)}
%{?_enable_libssh:BuildRequires: libssh-devel}
%{?_enable_libusb:BuildRequires: libusb-devel >= 1.0.13}
%{?_enable_rdma:BuildRequires: rdma-core-devel}
%{?_enable_numa:BuildRequires: libnuma-devel}
%{?_enable_tcmalloc:BuildRequires: libgperftools-devel}
%{?_enable_jemalloc:BuildRequires: libjemalloc-devel}
%{?_enable_lzo:BuildRequires: liblzo2-devel}
%{?_enable_snappy:BuildRequires: libsnappy-devel}
%{?_enable_bzip2:BuildRequires: bzlib-devel}
%{?_enable_lzfse:BuildRequires: liblzfse-devel}
%{?_enable_xen:BuildRequires: libxen-devel}
%{?_enable_mpath:BuildRequires: libudev-devel libmultipath-devel}
%{?_enable_libxml2:BuildRequires: libxml2-devel}
%{?_enable_libpmem:BuildRequires: libpmem-devel}
%{?_enable_libudev:BuildRequires: libudev-devel}
%{?_enable_libdaxctl:BuildRequires: libdaxctl-devel}
# used by some linux user impls
BuildRequires: libdrm-devel

%global requires_all_modules         \
Requires: %name-block-curl = %EVR    \
Requires: %name-block-dmg = %EVR     \
%{?_enable_glusterfs:Requires: %name-block-gluster = %EVR}  \
%{?_enable_libiscsi:Requires: %name-block-iscsi = %EVR}     \
%{?_enable_libnfs:Requires: %name-block-nfs = %EVR}         \
%{?_enable_rbd:Requires: %name-block-rbd = %EVR}            \
%{?_enable_libssh:Requires: %name-block-ssh = %EVR}         \
%{?_enable_alsa:Requires: %name-audio-alsa = %EVR}          \
%{?_enable_oss:Requires: %name-audio-oss = %EVR}            \
%{?_enable_pulseaudio:Requires: %name-audio-pa = %EVR}      \
%{?_enable_jack:Requires: %name-audio-jack = %EVR}          \
%{?_enable_sdl:Requires: %name-audio-sdl = %EVR}            \
%{?_enable_spice:Requires: %name-audio-spice = %EVR}        \
%{?_enable_curses:Requires: %name-ui-curses = %EVR}         \
%{?_enable_spice:Requires: %name-ui-spice-app = %EVR}       \
%{?_enable_spice:Requires: %name-ui-spice-core = %EVR}      \
%{?_enable_spice:Requires: %name-device-display-qxl = %EVR} \
Requires: %name-device-display-virtio-gpu-pci = %EVR        \
Requires: %name-device-display-virtio-vga = %EVR            \
%{?_enable_virglrenderer:Requires: %name-device-display-virtio-gpu = %EVR} \
%{?_enable_brlapi:Requires: %name-char-baum = %EVR}         \
%{?_enable_spice:Requires: %name-char-spice = %EVR}         \
Requires: %name-device-usb-redirect = %EVR                  \
Requires: %name-device-usb-smartcard = %EVR

##%%{?_enable_opengl:Requires: %name-ui-opengl = %EVR}         \
##%%{?_enable_opengl:Requires: %name-ui-egl-headless = %EVR}   \
##%%{?_enable_gtk:Requires: %name-ui-gtk = %EVR}        \
##%%{?_enable_sdl:Requires: %name-ui-sdl = %EVR}

%description
QEMU is a fast processor emulator using dynamic translation to achieve
good emulation speed.  QEMU has two operating modes:

* Full system emulation.  In this mode, QEMU emulates a full system
  (for example a PC), including a processor and various peripherials.
  It can be used to launch different Operating Systems without rebooting
  the PC or to debug system code.

* User mode emulation.  In this mode, QEMU can launch Linux processes
  compiled for one CPU on another CPU.  It can be used to launch the
  Wine Windows API emulator or to ease cross-compilation and
  cross-debugging.

As QEMU requires no host kernel patches to run, it is very safe and easy
to use.

%package common
Summary: QEMU CPU Emulator - common files
Group: Emulators
BuildArch: noarch
Requires(pre): control >= 0.7.2
Requires(pre): shadow-utils sysvinit-utils
Requires: %name-img = %EVR
Requires: ipxe-roms-qemu

%description common
QEMU is a fast processor emulator using dynamic translation to achieve
good emulation speed.
This package contains common files for qemu.

%package system
Summary: QEMU CPU Emulator - full system emulation
Group: Emulators
BuildArch: noarch
Requires: %name-common = %EVR
Requires: %name-tools = %EVR
Conflicts: %name-img < %EVR
%{expand:%(for i in %qemu_arches; do echo Requires: %%name-system-$i = %%EVR; done)}

%description system
Full system emulation.  In this mode, QEMU emulates a full system
(for example a PC), including a processor and various peripherials.
It can be used to launch different Operating Systems without rebooting
the PC or to debug system code.

%if_enabled have_kvm
%package kvm
Summary: QEMU metapackage for KVM support
Group: Emulators
Requires: qemu-%kvm_package = %EVR
Requires: qemu-kvm-core = %EVR

%description kvm
This is a meta-package that provides a qemu-system-<arch> package for native
architectures where kvm can be enabled. For example, in an x86 system, this
will install qemu-system-x86

%package kvm-core
Summary: QEMU metapackage for KVM support
Group: Emulators
Requires: qemu-%kvm_package-core = %EVR

%description kvm-core
This is a meta-package that provides a qemu-system-<arch>-core package
for native architectures where kvm can be enabled. For example, in an
x86 system, this will install qemu-system-x86-core
%endif

%package user
Summary: QEMU CPU Emulator - user mode emulation
Group: Emulators
Requires: %name-common = %EVR
%{expand:%(for i in %qemu_arches; do echo Requires: %%name-user-$i = %%EVR; done)}

%description user
User mode emulation.  In this mode, QEMU can launch Linux processes
compiled for one CPU on another CPU.  It can be used to launch the
Wine Windows API emulator or to ease cross-compilation and
cross-debugging.

%package user-binfmt
Summary: QEMU user mode emulation of qemu targets
Group: Emulators
Requires: %name-user = %EVR
# qemu-user-binfmt + qemu-user-static both provide binfmt rules
Conflicts: %name-user-static-binfmt
Conflicts: %name-user < 2.10.1-alt1
%{expand:%(for i in %qemu_arches; do echo Requires: %%name-user-binfmt-$i = %%EVR; done)}

%description user-binfmt
QEMU is a generic and open source processor emulator which achieves a good
emulation speed by using dynamic translation.

This package provides the user mode emulation of qemu targets

%package user-static
Summary: QEMU user mode emulation of qemu targets static build
Group: Emulators
Requires: %name-aux = %EVR
%{expand:%(for i in %qemu_arches; do echo Requires: %%name-user-static-$i = %%EVR; done)}

%description user-static
QEMU is a generic and open source processor emulator which achieves a good
emulation speed by using dynamic translation.

This package provides the user mode emulation of qemu targets built as
static binaries

%package user-static-binfmt
Summary: QEMU user mode emulation of qemu targets static build
Group: Emulators
Requires: %name-user-static
Conflicts: %name-user-binfmt
Conflicts: %name-user < 2.10.1-alt1
Provides: %name-user-binfmt_misc = %EVR
Obsoletes: %name-user-binfmt_misc < %EVR
%{expand:%(for i in %qemu_arches; do echo Requires: %%name-user-static-binfmt-$i = %%EVR; done)}

%description user-static-binfmt
QEMU is a generic and open source processor emulator which achieves a good
emulation speed by using dynamic translation.

This package provides the user mode emulation of qemu targets

%global do_package_user() \
%%package %%{1}-%%{2} \
Summary: QEMU CPU Emulator - %%{1}-%%{2} mode emulation \
Group: Emulators \
%%{?3} %%{?4} \
%%{?5} %%{?6} \
%%description %%{1}-%%{2} \
User mode emulation.  In this mode, QEMU can launch Linux processes \
compiled for one CPU on another CPU. \
%%files %%{1}-%%{2} -f %%{1}-%%{2}.list

%{expand:%(for i in %qemu_arches; do echo %%do_package_user user $i Requires: qemu-common; done)}
%{expand:%(for i in %qemu_arches; do echo %%do_package_user user-binfmt $i Requires: qemu-user-$i Conflicts: qemu-user-static-binfmt-$i; done)}

%if_enabled user_static
%{expand:%(for i in %qemu_arches; do echo %%do_package_user user-static $i; done)}
%{expand:%(for i in %qemu_arches; do echo %%do_package_user user-static-binfmt $i Requires: qemu-user-static-$i Conflicts: qemu-user-binfmt-$i; done)}
%endif

%package img
Summary: QEMU command line tool for manipulating disk images
Group: Emulators
Provides: qemu-kvm-img
Obsoletes: qemu-kvm-img < %EVR
Requires: %name-aux = %EVR

%description img
This package provides a command line tool for manipulating disk images

%package tools
Summary: Tools for QEMU
Group: Emulators
Requires: %name-img = %EVR
Requires: %name-aux = %EVR
Conflicts: %name-system < 2.11.0-alt2

%description tools
This package contains various QEMU related tools, including a bridge helper,
a virtfs helper.

%global do_package_block() \
%%package block-%%{1} \
Summary: QEMU %%{1} block driver \
Group: Emulators \
Requires: %%name-common = %%EVR \
\
%%description block-%%{1} \
This package provides the additional %%{1} block driver for QEMU. \
\
%%files block-%%{1} \
%%_libdir/qemu/block-%%{1}*.so

%{expand:%(for i in %block_drv_list; do echo %%do_package_block $i; done)}

%global do_package_audio() \
%%package audio-%%{1} \
Summary: QEMU %%{1} audio driver \
Group: Emulators \
Requires: %%name-common = %%EVR \
\
%%description audio-%%{1} \
This package provides the additional %%{1} audio driver for QEMU. \
\
%%files audio-%%{1} \
%%_libdir/qemu/audio-%%{1}.so

%{expand:%(for i in %audio_drv_list spice; do echo %%do_package_audio $i; done)}

%global do_package_ui() \
%%package ui-%%{1} \
Summary: QEMU %%{1} UI driver \
Group: Emulators \
Requires: %%name-common = %%EVR \
%%if %%{1} == gtk \
Requires: %%name-ui-opengl = %%EVR \
%%endif \
%%if %%{1} == sdl \
Requires: %%name-ui-opengl = %%EVR \
%%endif \
\
%%description ui-%%{1} \
This package provides the additional %%{1} UI for QEMU. \
\
%%files ui-%%{1} \
%%_libdir/qemu/ui-%%{1}.so

%{expand:%(for i in %ui_list; do echo %%do_package_ui $i; done)}

%global do_package_ui_spice() \
%%package ui-spice-%%{1} \
Summary: QEMU spice-%%{1} UI driver \
Group: Emulators \
Requires: %%name-common = %%EVR \
%%if %%{1} == "core" \
Requires: %%name-ui-opengl = %%EVR \
%%endif \
%%if %%{1} == "app" \
Requires: %%name-ui-spice-core = %%EVR \
Requires: %%name-char-spice = %%EVR \
%%endif \
\
%%description ui-spice-%%{1} \
This package provides the additional %%{1} UI for QEMU. \
\
%%files ui-spice-%%{1} \
%%_libdir/qemu/ui-spice-%%{1}.so

%{expand:%(for i in %ui_spice_list; do echo %%do_package_ui_spice $i; done)}

%package  ui-egl-headless
Summary: QEMU EGL headless driver
Group: Emulators
Requires: %name-common = %EVR
Requires: %name-ui-opengl = %EVR

%description ui-egl-headless
This package provides the additional egl-headless UI for QEMU.

%package device-display-qxl
Summary: QEMU QXL display device
Group: Emulators
Requires: %name-common = %EVR
Requires: %name-ui-spice-core = %EVR

%description device-display-qxl
This package provides the QXL display device for QEMU.

%global do_package_device_display() \
%%package device-display-%%{1} \
Summary: QEMU display-%%{1} device \
Group: Emulators \
Requires: %%name-common = %%EVR \
\
%%description device-display-%%{1} \
This package provides the additional device display-%%{1} for QEMU. \
\
%%files device-display-%%{1} \
%%_libdir/qemu/hw-display-%%{1}.so

%{expand:%(for i in %device_display_list; do echo %%do_package_device_display $i; done)}

%global do_package_device_usb() \
%%package device-usb-%%{1} \
Summary: QEMU usb-%%{1} device \
Group: Emulators \
Requires: %%name-common = %%EVR \
\
%%description device-usb-%%{1} \
This package provides the additional device usb-%%{1} for QEMU. \
\
%%files device-usb-%%{1} \
%%_libdir/qemu/hw-usb-%%{1}.so

%{expand:%(for i in %device_usb_list; do echo %%do_package_device_usb $i; done)}

%package char-baum
Summary: QEMU Baum chardev driver
Group: Emulators
Requires: %name-common = %EVR

%description char-baum
This package provides the Baum chardev driver for QEMU.

%package char-spice
Summary: QEMU spice chardev driver
Group: Emulators
Requires: %name-common = %EVR
Requires: %name-ui-spice-core = %EVR

%description char-spice
This package provides the spice chardev driver for QEMU.

%package guest-agent
Summary: QEMU guest agent
Group: Emulators
Requires: %name-aux = %EVR

%description guest-agent
QEMU is a generic and open source processor emulator which achieves a good
emulation speed by using dynamic translation.

This package provides an agent to run inside guests, which communicates
with the host over a virtio-serial channel named "org.qemu.guest_agent.0"

This package does not need to be installed on the host OS.

%package doc
Summary: User documentation for %name
Group: Documentation
BuildArch: noarch
Requires: %name-aux = %EVR

%description doc
User documentation for %name

%package aux
Summary: QEMU auxiliary package
Group: Emulators
BuildArch: noarch

%description aux
QEMU is a generic and open source processor emulator which achieves
good emulation speed by using dynamic translation.

This is an auxiliary package.

%global do_package_system() \
%%package system-%%{1} \
Summary: QEMU system emulator for %%{1} \
Group: Emulators \
Requires: %%name-system-%%{1}-core = %%EVR \
%%requires_all_modules \
%%description system-%%{1} \
This package provides the system emulator for %%{1}. \
%%files system-%%{1} \
\
%%package system-%%{1}-core \
Summary: QEMU system emulator for %%{1} \
Group: Emulators \
Requires: %%name-common = %%EVR \
Conflicts: %%name-system < 2.10.1-alt1 \
\
%%if %%{1} == x86 \
Requires: seabios >= 1.7.4-alt2 seavgabios edk2-ovmf libseccomp >= 2.2.3 qboot \
%%endif \
%%if %%{1} == aarch64 \
Requires: edk2-aarch64 \
%%endif \
%%if %%{1} == ppc \
Requires: seavgabios \
%%endif \
\
%%description system-%%{1}-core \
This package provides the system emulator for %%{1}. \
%%files system-%%{1}-core \
\
%%if %%{1} == x86 \
%%_bindir/qemu-system-i386 \
%%_man1dir/qemu-system-i386.1* \
%%_datadir/%%name/bios* \
%%_datadir/%%name/sgabios.bin \
%%_datadir/%%name/linuxboot* \
%%_datadir/%%name/multiboot.bin \
%%_datadir/%%name/kvmvapic.bin \
%%_datadir/%%name/pvh.bin \
%%endif \
\
%%if %%{1} == alpha \
%%_datadir/%%name/palcode-clipper \
%%endif \
\
%%if %%{1} == arm \
%%_datadir/%%name/npcm7xx_bootrom.bin \
%%endif \
\
%%if %%{1} == hppa \
%%_datadir/%%name/hppa-firmware.img \
%%endif \
\
%%if %%{1} == microblaze \
%%_datadir/%%name/petalogix*.dtb \
%%endif \
\
%%if %%{1} == s390x \
%%_datadir/%%name/s390-*.img \
%%endif \
\
%%if %%{1} == sparc \
%%_datadir/%%name/QEMU* \
%%_datadir/%%name/openbios-sparc* \
%%endif \
\
%%if %%{1} == ppc \
%%_datadir/%%name/bamboo.dtb \
%%_datadir/%%name/canyonlands.dtb \
%%_datadir/%%name/qemu_vga.ndrv \
%%_datadir/%%name/skiboot.lid \
%%_datadir/%%name/u-boot* \
%%_datadir/%%name/openbios-ppc \
%%_datadir/%%name/slof.bin \
%%endif \
\
%%if %%{1} == riscv \
%%_datadir/%%name/opensbi* \
%%endif \
\
%%_bindir/qemu-system-%%{1}* \
%%_man1dir/qemu-system-%%{1}*

%{expand:%(for i in %qemu_arches; do echo %%do_package_system $i; done)}

%prep
%setup

tar -xf %SOURCE100 -C ui/keycodemapdb --strip-components 1
tar -xf %SOURCE101 -C tests/fp/berkeley-testfloat-3 --strip-components 1
tar -xf %SOURCE102 -C tests/fp/berkeley-softfloat-3 --strip-components 1

%patch -p1
cp -f %SOURCE2 qemu-kvm.control.in

%build
export CFLAGS="%optflags"
# --build-id option is used for giving info to the debug packages.
export extraldflags="-Wl,--build-id"
export buildldflags="VL_LDFLAGS=-Wl,--build-id"

run_configure() {
# non-GNU configure
    ../configure \
	--disable-git-update \
	--prefix=%prefix \
	--sysconfdir=%_sysconfdir \
	--libdir=%_libdir \
	--mandir=%_mandir \
	--libexecdir=%_libexecdir \
	--localstatedir=%_localstatedir \
	--with-pkgversion=%name-%version-%release \
	--disable-werror \
	--disable-debug-tcg \
	--disable-sparse \
	--disable-strip \
	--firmwarepath=%firmwarepath \
	 "$@"
}

%if_enabled user_static
mkdir build-static
pushd build-static
# non-GNU configure
run_configure \
	--static \
	--enable-user \
	--enable-linux-user \
	--enable-attr \
	--enable-tcg \
	--extra-ldflags="$extraldflags -Wl,-Ttext-segment=0x60000000" \
	--audio-drv-list="" \
	--disable-auth-pam \
	--disable-avx2 \
	--disable-avx512f \
	--disable-blobs \
	--disable-bochs \
	--disable-brlapi \
	--disable-bsd-user \
	--disable-bzip2 \
	--disable-cap-ng \
	--disable-capstone \
	--disable-cloop \
	--disable-cocoa \
	--disable-crypto-afalg \
	--disable-curl \
	--disable-curses \
	--disable-debug-info \
	--disable-debug-mutex \
	--disable-debug-tcg \
	--disable-dmg \
	--disable-docs \
	--disable-fdt \
	--disable-gcrypt \
	--disable-glusterfs \
	--disable-gnutls \
	--disable-gtk \
	--disable-guest-agent \
	--disable-guest-agent-msi \
	--disable-hax \
	--disable-hvf \
	--disable-iconv \
	--disable-jemalloc \
	--disable-keyring \
	--disable-kvm \
	--disable-libdaxctl \
	--disable-libiscsi \
	--disable-libnfs \
	--disable-libpmem \
	--disable-libssh \
	--disable-libudev \
	--disable-libusb \
	--disable-libxml2 \
	--disable-linux-aio \
	--disable-linux-io-uring \
	--disable-live-block-migration \
	--disable-lzfse \
	--disable-lzo \
	--disable-membarrier \
	--disable-modules \
	--disable-mpath \
	--disable-netmap \
	--disable-nettle \
	--disable-numa \
	--disable-opengl \
	--disable-parallels \
	--disable-pie \
	--disable-pvrdma \
	--disable-qcow1 \
	--disable-qed \
	--disable-qom-cast-debug \
	--disable-rbd \
	--disable-rdma \
	--disable-replication \
	--disable-rng-none \
	--disable-sdl \
	--disable-sdl-image \
	--disable-seccomp \
	--disable-sheepdog \
	--disable-slirp \
	--disable-smartcard \
	--disable-snappy \
	--disable-sparse \
	--disable-spice \
	--disable-system \
	--disable-tcmalloc \
	--disable-tools \
	--disable-tpm \
	--disable-usb-redir \
	--disable-vde \
	--disable-vdi \
	--disable-vhost-crypto \
	--disable-vhost-kernel \
	--disable-vhost-net \
	--disable-vhost-scsi \
	--disable-vhost-user \
	--disable-vhost-vdpa \
	--disable-vhost-vsock \
	--disable-vhost-user-fs \
	--disable-virglrenderer \
	--disable-virtfs \
	--disable-vnc \
	--disable-vnc-jpeg \
	--disable-vnc-png \
	--disable-vnc-sasl \
	--disable-vte \
	--disable-vvfat \
	--disable-whpx \
	--disable-xen \
	--disable-xen-pci-passthrough \
	--disable-xfsctl \
	--disable-xkbcommon \
	--disable-zstd \
	--without-default-devices

# Please do not touch this
sed -i "/cpu_get_model/ {
N
N
/return / s,any,cortex-a8,
}" ../linux-user/arm/target_elf.h

%make_build V=1 $buildldflags

%if_with arm
mv qemu-arm qemu-armh

sed -i '/return / s,cortex-a8,cortex-a53,' ../linux-user/arm/target_elf.h
%make_build V=1 $buildldflags
mv qemu-arm qemu-aarch64

exit 0

sed -i '/return / s,cortex-a53,any,' ../linux-user/arm/target_elf.h
%make_build V=1 $buildldflags
%endif

popd
%endif

# Build for non-static qemu-*
mkdir build-dynamic
pushd build-dynamic
# non-GNU configure
run_configure \
	--enable-system \
	--enable-kvm \
	--enable-user \
	--enable-linux-user \
	--enable-pie \
	--enable-modules \
	%{?_enable_sdl:--enable-sdl} \
	%{?_disable_curses:--disable-curses} \
	%{subst_enable vnc} \
	%{?_enable_gtk:--enable-gtk --enable-vte} \
	%{?_disable_vnc_tls:--disable-vnc-tls} \
	%{?_disable_vnc_sasl:--disable-vnc-sasl} \
	%{?_disable_vnc_jpeg:--disable-vnc-jpeg} \
	%{?_disable_vnc_png:--disable-vnc-png} \
	%{?_disable_xkbcommon:--disable-xkbcommon} \
	%{?_disable_vde:--disable-vde} \
	%{?_disable_aio:--disable-linux-aio} \
	%{?_disable_io_uring:--disable-linux-io-uring} \
	%{?_disable_blobs: --disable-blobs} \
	%{subst_enable spice} \
	--audio-drv-list="%audio_drv_list" \
	%{subst_enable brlapi} \
	--enable-curl \
	%{subst_enable virglrenderer} \
	%{subst_enable tpm} \
	%{subst_enable xen} \
	%{?_enable_vhost_crypto:--enable-vhost-crypto} \
	%{?_enable_vhost_net:--enable-vhost-net} \
	%{?_enable_vhost_scsi:--enable-vhost-scsi } \
	%{?_enable_vhost_vsock:--enable-vhost-vsock} \
	%{?_enable_vhost_user_fs:--enable-vhost-user-fs} \
	--enable-slirp=system \
	%{subst_enable smartcard} \
	%{subst_enable libusb} \
	%{?_enable_usb_redir:--enable-usb-redir} \
	%{subst_enable opengl} \
	%{subst_enable zstd} \
	%{subst_enable seccomp} \
	%{subst_enable libiscsi} \
	%{subst_enable rbd} \
	%{subst_enable libnfs} \
	%{subst_enable glusterfs} \
	%{subst_enable libxml2} \
	%{subst_enable libssh} \
	%{?_enable_live_block_migration:--enable-live-block-migration} \
	%{subst_enable rdma} \
	%{subst_enable gnutls} \
	%{subst_enable nettle} \
	%{subst_enable gcrypt} \
	%{subst_enable numa} \
	%{subst_enable tcmalloc} \
	%{subst_enable jemalloc} \
	%{subst_enable replication} \
	%{subst_enable lzo} \
	%{subst_enable snappy} \
	%{subst_enable bzip2} \
	%{subst_enable lzfse} \
	%{?_disable_guest_agent:--disable-guest-agent} \
	%{subst_enable tools} \
	%{subst_enable libpmem} \
	%{subst_enable libdaxctl} \
	--enable-xkbcommon \
	--extra-ldflags="$extraldflags" \
	--disable-xen

%make_build V=1 $buildldflags
popd

sed -i 's/@GROUP@/%_group/g' qemu-kvm.control.in

%install
%define docdir %_docdir/%name-%version

%if_enabled user_static
pushd build-static
%makeinstall_std
# Rename all QEMU user emulators to have a -static suffix
for src in %buildroot%_bindir/qemu-*
do
  mv $src $src.static
done

for f in %buildroot%_bindir/qemu-*.static; do
    [ -f "$f" ]
    symlink="${f%%.static}-static"
    ln -sfr "$f" "$symlink"
done
popd
%endif

pushd build-dynamic
%makeinstall_std
popd
mv %buildroot%_docdir/qemu %buildroot%docdir
install -D -p -m0644 -t %buildroot%docdir README.rst COPYING COPYING.LIB LICENSE
for emu in %buildroot%_bindir/qemu-system-*; do
    ln -sf qemu.1.xz %buildroot%_man1dir/$(basename $emu).1.xz
done

%if_enabled qemu_kvm
install -m 0755 %SOURCE5 %buildroot%_bindir/qemu-kvm
ln -r -s %buildroot%_bindir/qemu-kvm %buildroot%_bindir/kvm
ln -r -s %buildroot%_bindir/qemu-kvm %buildroot%_bindir/qemu
ln -sf qemu.1.xz %buildroot%_man1dir/qemu-kvm.1.xz
%endif

rm -f %buildroot%_bindir/check-*
rm -f %buildroot%_sysconfdir/udev/rules.d/*

install -D -m 0644 %SOURCE4 %buildroot%_sysconfdir/udev/rules.d/%rulenum-%name-kvm.rules
install -D -m 0755 %name-kvm.control.in %buildroot%_controldir/kvm

# Install qemu-guest-agent service and udev rules
install -D -m 0644 %SOURCE8 %buildroot%_udevrulesdir/%rulenum-%name-guest-agent.rules
install -D -m 0644 %SOURCE9 %buildroot%_unitdir/%name-guest-agent.service
install -D -m 0755 %SOURCE10 %buildroot%_initdir/%name-guest-agent
install -D -m 0644 %SOURCE11 %buildroot%_sysconfdir/sysconfig/qemu-ga
mkdir -p %buildroot%_sysconfdir/%name/fsfreeze-hook.d
install -D -m 0755 scripts/qemu-guest-agent/fsfreeze-hook %buildroot%_sysconfdir/%name/
install -D -m 0644 scripts/qemu-guest-agent/fsfreeze-hook.d/*.sample %buildroot%_sysconfdir/%name/fsfreeze-hook.d/
mkdir -p %buildroot%_logdir
touch %buildroot%_logdir/qga-fsfreeze-hook.log

# Install qemu-pr-helper service
install -m 0644 contrib/systemd/qemu-pr-helper.service %buildroot%_unitdir/qemu-pr-helper.service
install -m 0644 contrib/systemd/qemu-pr-helper.socket %buildroot%_unitdir/qemu-pr-helper.socket
# Install rules to use the bridge helper with libvirt's virbr0
install -m 0644 %SOURCE12 %buildroot%_sysconfdir/%name

%if_enabled vnc_sasl
install -D -p -m 0644 qemu.sasl %buildroot%_sysconfdir/sasl2/%name.conf
%endif

%find_lang %name

# todo: build new openbios and SLOF
# Provided by package openbios
#rm -f %buildroot%_datadir/%name/openbios*
# Provided by package SLOF
#rm -f %buildroot%_datadir/%name/slof.bin
# Provided by package ipxe
rm -f %buildroot%_datadir/%name/pxe*rom
rm -f %buildroot%_datadir/%name/efi*rom
# Provided by package seavgabios
rm -f %buildroot%_datadir/%name/vgabios*bin
# Provided by package seabios
rm -f %buildroot%_datadir/%name/bios.bin
rm -f %buildroot%_datadir/%name/bios-256k.bin
rm -f %buildroot%_datadir/%name/bios-microvm.bin
# Provided by package sgabios
#rm -f %buildroot%_datadir/%name/sgabios.bin
# Provided by package qboot
rm -f %buildroot%_datadir/%name/qboot.rom
# Provided by package edk2
rm %buildroot%_datadir/%name/edk2-*
rm %buildroot%_datadir/%name/firmware/*

rm %buildroot%_datadir/%name/qemu-nsis.bmp


# the pxe ipxe images will be symlinks to the images on
# /usr/share/ipxe, as QEMU doesn't know how to look
# for other paths, yet.

for rom in e1000 ne2k_pci pcnet rtl8139 virtio eepro100 e1000e vmxnet3 ; do
  ln -r -s %buildroot%_datadir/ipxe/pxe-${rom}.rom %buildroot%_datadir/%name/pxe-${rom}.rom
  ln -r -s %buildroot%_datadir/ipxe.efi/efi-${rom}.rom %buildroot%_datadir/%name/efi-${rom}.rom
done

for bios in vgabios vgabios-cirrus vgabios-qxl vgabios-stdvga vgabios-vmware vgabios-virtio vgabios-ramfb vgabios-bochs-display vgabios-ati ; do
  ln -r -s %buildroot%_datadir/seavgabios/${bios}.bin %buildroot%_datadir/%name/${bios}.bin
done

ln -r -s %buildroot%_datadir/seabios/{bios,bios-256k,bios-microvm}.bin %buildroot%_datadir/%name/
ln -r -s %buildroot%_datadir/qboot/bios.bin %buildroot%_datadir/%name/qboot.rom

mkdir -p %buildroot%_binfmtdir
./scripts/qemu-binfmt-conf.sh --systemd ALL --exportdir %buildroot%_binfmtdir --qemu-path %_bindir

# Drop qemu-mipsn32*.conf -- see https://bugzilla.altlinux.org/39619
rm -rf %buildroot%_binfmtdir/*mipsn32*

for f in %buildroot%_binfmtdir/*.conf; do
    [ -f "$f" ]
    dynamic="${f%%.conf}-dynamic.conf"
    mv "$f" "$dynamic"
%if_enabled user_static
    static="${f%%.conf}-static.conf"
    sed 's/:$/.static:F/' < "$dynamic" > "$static"
%endif
done

# files list
for i in %qemu_arches; do
    find %buildroot%_bindir/qemu-$i* \
        -type f \( ! -name "*static" ! -name "*-system-*" \) |
        sed -e 's#%{buildroot}##' |
        sort -u > user-$i.list

    find %buildroot%_binfmtdir/qemu-$i* \
        -type f \( -name "*dynamic.conf" \) |
        sed -e 's#%{buildroot}##' |
        sort -u > user-binfmt-$i.list

%if_enabled user_static
    find %buildroot%_bindir/qemu-$i* \
        \( -name "*static" \) |
        sed -e 's#%{buildroot}##' |
        sort -u > user-static-$i.list

    find %buildroot%_binfmtdir/qemu-$i* \
        -type f \( -name "*static.conf" \) |
        sed -e 's#%{buildroot}##' |
        sort -u > user-static-binfmt-$i.list

%endif
done

echo "%_bindir/qemu-i386" >> user-x86.list
echo "%_bindir/qemu-i386.static" >> user-static-x86.list
echo "%_bindir/qemu-i386-static" >> user-static-x86.list

%ifnarch %ix86 x86_64
echo "%_binfmtdir/qemu-i386-dynamic.conf" >> user-binfmt-x86.list
echo "%_binfmtdir/qemu-i386-static.conf" >> user-static-binfmt-x86.list
echo "%_binfmtdir/qemu-i486-dynamic.conf" >> user-binfmt-x86.list
echo "%_binfmtdir/qemu-i486-static.conf" >> user-static-binfmt-x86.list
%endif

%check
# Disabled on aarch64 where it fails with several errors.  Will
# investigate and fix when we have access to real hardware

%define archs_skip_tests aarch64
%def_enable archs_ignore_test_failures

%ifnarch %archs_skip_tests

%if_enabled archs_ignore_test_failures
%make V=1 check ||:
%else
%make V=1 check
%endif # archs_ignore_test_failures

%endif # archs_skip_tests

%pre common
%_sbindir/groupadd -r -f %_group
if [ -f %_controldir/qemu-kvm ];then
%pre_control qemu-kvm
mv -f /var/run/control/qemu-kvm /var/run/control/kvm
else
%pre_control kvm
fi

%post common
%post_control -s vmusers kvm

%files
%files common
%dir %_datadir/%name
%_desktopdir/qemu.desktop
%_iconsdir/hicolor/*/apps/*
%_datadir/%name/keymaps
%_datadir/%name/trace-events-all
%_datadir/%name/*.rom
%_datadir/%name/vgabios*.bin
%dir %_datadir/%name/firmware
%_man1dir/%name.1*
%_sysconfdir/udev/rules.d/%rulenum-%name-kvm.rules
%_controldir/*
%if_enabled vnc_sasl
%config(noreplace) %_sysconfdir/sasl2/%name.conf
%endif
%_man7dir/qemu-block-drivers.*
%_man7dir/qemu-ga-ref.*
%_man7dir/qemu-qmp-ref.*
%_man7dir/qemu-cpu-models.*

%files system -f %name.lang

%if_enabled have_kvm
%files kvm
%files kvm-core
%if_enabled qemu_kvm
%_bindir/qemu
%_bindir/qemu-kvm
%_bindir/kvm
%_man1dir/qemu-kvm.1*
%endif
%endif

%files user
%files user-binfmt

%if_enabled user_static
%files user-static
%files user-static-binfmt
%endif

%files img
%_bindir/qemu-img
%_bindir/qemu-io
%_bindir/qemu-nbd
%_man1dir/qemu-img.1*
%_man8dir/qemu-nbd.8*

%files tools
%_libexecdir/virtfs-proxy-helper
%_man1dir/virtfs-proxy-helper.*
%attr(4710,root,vmusers) %_libexecdir/qemu-bridge-helper
%if_enabled virglrenderer
%_libexecdir/vhost-user-gpu
%_datadir/%name/vhost-user/50-qemu-gpu.json
%endif
%_libexecdir/virtiofsd
%_man1dir/virtiofsd.*
%_datadir/qemu/vhost-user/50-qemu-virtiofsd.json
%_bindir/qemu-storage-daemon
%if_enabled mpath
%_bindir/qemu-pr-helper
%_unitdir/qemu-pr-helper.service
%_unitdir/qemu-pr-helper.socket
%_man8dir/qemu-pr-helper.*
%endif
%_bindir/elf2dmp
%_bindir/qemu-edid
%_bindir/qemu-keymap
%config(noreplace) %_sysconfdir/%name/bridge.conf

%if_enabled opengl
%files ui-egl-headless
%_libdir/qemu/ui-egl-headless.so
%endif

%if_enabled brlapi
%files char-baum
%_libdir/qemu/chardev-baum.so
%endif

%if_enabled spice
%files char-spice
%_libdir/qemu/chardev-spice.so

%files device-display-qxl
%_libdir/qemu/hw-display-qxl.so
%endif

%files guest-agent
%_bindir/qemu-ga
%_man8dir/qemu-ga.8*
%_udevrulesdir/%rulenum-%name-guest-agent.rules
%_unitdir/%name-guest-agent.service
%_initdir/%name-guest-agent
%config(noreplace) %_sysconfdir/sysconfig/qemu-ga
%_sysconfdir/%name/fsfreeze-hook
%dir %_sysconfdir/%name/fsfreeze-hook.d
%config(noreplace) %_sysconfdir/%name/fsfreeze-hook.d/*
%ghost %_logdir/qga-fsfreeze-hook.log

%files doc
%docdir/
%exclude %docdir/LICENSE

%files aux
%dir %_sysconfdir/%name
%dir %docdir/
%docdir/LICENSE

%changelog
