
%global qt_module qtxmlpatterns
%def_enable bootstrap

Name: qt5-xmlpatterns
Version: 5.12.12
Release: alt1

Group: System/Libraries
Summary: Qt5 - QtXmlPatterns component
Url: http://qt.io/
License: LGPLv2 / GPLv3

Source: %qt_module-everywhere-src-%version.tar

BuildRequires(pre): rpm-build-ubt rpm-macros-qt5
BuildRequires: gcc-c++ glibc-devel qt5-base-devel qt5-declarative-devel
%if_disabled bootstrap
BuildRequires: qt5-tools
%endif

%description
The Qt XML Patterns module provides support for XPath, XQuery, XSLT,
and XML Schema validation.

%package common
Summary: Common package for %name
Group: System/Configuration/Other
BuildArch: noarch
Requires: qt5-base-common
%description common
Common package for %name

%package devel
Group: Development/KDE and QT
Summary: Development files for %name
Requires: %name-common = %EVR
Requires: qt5-base-devel
%description devel
%summary.

%package devel-static
Group: Development/KDE and QT
Summary: Development files for %name
Requires: %name-common = %EVR
Requires: %name-devel
%description devel-static
%summary.

%package doc
Summary: Document for developing apps which will use Qt5 %qt_module
Group: Development/KDE and QT
Requires: %name-common = %EVR
%description doc
This package contains documentation for Qt5 %qt_module

%package -n libqt5-xmlpatterns
Summary: Qt5 library
Group: System/Libraries
Requires: %name-common = %EVR
Requires: libqt5-core = %_qt5_version
%description -n libqt5-xmlpatterns
%summary

%prep
%setup -qn %qt_module-everywhere-src-%version

%build
%qmake_qt5
%make_build
%if_disabled bootstrap
export QT_HASH_SEED=0
%make docs
%endif

%install
%install_qt5
%if_disabled bootstrap
%make INSTALL_ROOT=%buildroot install_docs ||:
%endif

%files common
%files -n libqt5-xmlpatterns
%doc LICENSE*EXCEPT*
%_qt5_libdir/libQt?XmlPatterns.so.*
%_qt5_qmldir/QtQuick/XmlListModel/

%files devel
%_qt5_bindir/xmlpatterns*
%_bindir/xmlpatterns*
%_qt5_headerdir/Qt*/
%_qt5_libdir/libQt*.so
%_qt5_libdatadir/libQt*.so
%_qt5_libdir/libQt*.prl
%_qt5_libdatadir/libQt*.prl
%_qt5_libdir/cmake/Qt*/
%_qt5_libdir/pkgconfig/Qt*.pc
%_qt5_archdatadir/mkspecs/modules/*.pri

%files doc
%if_disabled bootstrap
%_qt5_docdir/*
%endif
%_qt5_examplesdir/*

%changelog
