%define _unpackaged_files_terminate_build 1

Name: qtm
Version: 1.3.17
Release: alt2.1

Summary: Qt4 blogging client
License: GPLv2+
Group: Networking/Other

Url: http://qtm.blogistan.co.uk/

Source: %name-%version.tar.gz

BuildPreReq: cmake gcc-c++ libqt4-devel
BuildRequires: desktop-file-utils
BuildPreReq: qt4-designer libqt4-sql-interbase libqt4-sql-sqlite3
BuildPreReq: libqt4-sql-mysql libqt4-sql-odbc libqt4-sql-postgresql
BuildPreReq: libqt4-assistant-devel

%description
QTM is a blogging client which is presently capable of composing,
formatting and submitting blog entries to a weblog. QTM will work with
blogs based on most of the major blogging systems available today:
Wordpress (including wordpress.com), Movable Type, Drupal and so on.

%prep
%setup
mkdir build/
cd build
cmake ../ \
        -DCMAKE_INSTALL_PREFIX=%_prefix \
        -DLIB_SUFFIX=%_libsuff \
	-DCMAKE_STRIP:FILEPATH="/bin/echo" \
        -DCMAKE_BUILD_TYPE="Release" \
        -DCMAKE_CXX_FLAGS:STRING="%optflags" \
        -DCMAKE_SKIP_RPATH=YES

%build
cd build
%make_build VERBOSE=1

%install
cd build
%makeinstall DESTDIR=%buildroot

mkdir -p %buildroot%_pixmapsdir
mv %buildroot%_iconsdir/* %buildroot%_pixmapsdir/
desktop-file-install --dir %buildroot%_desktopdir \
	--add-category=WebDevelopment \
	%buildroot%_desktopdir/qtm.desktop

%files
%doc Changelog INSTALL README
%_bindir/*
%_desktopdir/*.desktop
%_pixmapsdir/*.png
%_man1dir/%name.*

%changelog
