%define _unpackaged_files_terminate_build 1
%define cvs 0

%define	quagga_user	quagga
%define	quagga_gid	quagga
%define quagga_log_mask	0640
%define	vty_gid		quaggavty

# https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define	_localstatedir	/var/lib

Name: quagga

%define baseversion 1.2.4
Release: alt4

%if %cvs
%define cvsdate 20060505
Version: %baseversion.%cvsdate
%define quaggadir %name-%baseversion
%else
Version: %baseversion
%define quaggadir %name-%version
%endif

Packager: Sergey Y. Afonin <asy@altlinux.ru>

Summary: Quagga is free software that manages various IPv4 and IPv6 routing protocols

License: %gpl2only
Group: Networking/Other
Url: http://www.quagga.net/

%if %cvs
Source0:	%name-%baseversion-%cvsdate.tar.gz
%else
Source0:	%name-%version.tar.gz
%endif
Source1:	%name.logrotate
Source2:	%name.pam
Source3:	%name.sysconfig

Source10:	%name-zebra.init
Source11:	%name-ripd.init
Source12:	%name-ripngd.init
Source13:	%name-ospfd.init
Source14:	%name-ospf6d.init
Source15:	%name-bgpd.init
Source16:	%name-isisd.init
Source18:	%name-pimd.init

Source19:	%name-watchquagga.init

Source20:	%name-zebra.conf
Source21:	%name-ripd.conf
Source22:	%name-ripngd.conf
Source23:	%name-ospfd.conf
Source24:	%name-ospf6d.conf
Source25:	%name-bgpd.conf
Source26:	%name-isisd.conf
Source28:	%name-pimd.conf

Patch1:		quagga-libzebra_to_libospf.patch
Patch2:		quagga-libospf_to_libospfclient.patch
Patch3:		quagga-1.2.2-man.patch
Patch4:		quagge-1.2.4-configure.ac-builconf.patch

#Errata
#Patch1001:

Conflicts:	zebra

Requires:	libquagga = %{version}-%{release}

BuildRequires: /proc
BuildRequires: rpm-build-licenses

BuildRequires: gcc-c++ libcap-devel libpam-devel libpcap-devel libreadline-devel libtinfo-devel libnet-snmp-devel libcares-devel
BuildRequires: texi2html makeinfo

%description
Quagga is a free software that manages TCP/IP based routing protocol.
It takes multi-server and multi-thread approach to resolve the current
complexity of the Internet.

Currently Quagga supports the following protocols

Unicast Routing:   BGP4, BGP4+, OSPFv2, OSPFv3, RIPv1, RIPv2 and RIPng
                   as well as very early support for IS-IS.
Multicast Routing: PIM-SSM

Quagga is intended to be used as a Route Server and a Route Reflector.
It is not a toolkit, it provides full routing power under a new
architecture. Quagga by design has a process for each protocol.

Quagga is a fork of the GNU Zebra (forked after 2002-07-07).

%package -n libquagga
Summary: Quagga shared library.
Copyright: %lgpl2only
Group: System/Libraries

%description -n libquagga
The runtime library of Quagga

%package devel
Summary: Header and object files for Quagga development
Group: Development/C
Requires: libquagga = %{version}-%{release}

%description devel
The quagga-devel package contains the header and object files neccessary for
developing OSPF-API and quagga applications.

%package ospfclient
Summary: Simple program to demonstrate how OSPF API can be used.
Copyright: %gpl2only
Group: Development/Other
Requires: libquagga = %{version}-%{release}

%description ospfclient
This application retrieves the LSDB from the OSPF daemon and thenoriginates,
updates and finally deletes an application-specificopaque LSA. You can use
this application as a template when writingyour own application.

%package doc
Summary: Quagga documentation
Copyright: %gpl2only
Group: Development/Other
BuildArch: noarch

%description doc
Quagga documentation

%prep

%setup -q -n %quaggadir

# disabled quagga-libzebra_to_libospf.patch and quagga-libospf_to_libospfclient.patch
# (/usr/bin/ld: cannot find -lzebra in hasher build)

#patch1 -p1
#patch2 -p1
%patch3 -p1
%patch4 -p0

#Errata
#patch1001 -p1

#verify-elf: WARNING: ./usr/lib/libzebra.so.0.0.0: undefined symbol: master
#verify-elf: WARNING: ./usr/lib/libospf.so.0.0.0: undefined symbol: ospfd_privs
#verify-elf: WARNING: ./usr/lib/libospf.so.0.0.0: undefined symbol: master
#
# master in sbin/zebra
# ospfd_privs in sbin/ospfclient
#
%set_verify_elf_method unresolved=relaxed
#export LDFLAGS="$LDFLAGS -Wl,--no-as-needed"

%build

#undefine __libtoolize

# fixed libraries path in RPATH (on x86_64)
%autoreconf

export LIBS="-lcap"

export IPFORWARD=ipforward_proc.o; export zebra_ipforward_path=proc; %configure \
	--enable-multipath=32 \
	--enable-tcp-zebra \
	--enable-opaque-lsa \
	--enable-ospf-te \
	--enable-vtysh \
	--enable-ospfclient=yes \
	--enable-ospfapi=yes \
	--enable-irdp=yes \
	--enable-isisd \
	--enable-pimd \
	--with-libpam \
	--enable-user=%quagga_user \
	--enable-group=%quagga_gid \
	--enable-vty-group=%vty_gid \
	--enable-logfile-mask=%quagga_log_mask \
	--enable-gcc-rdynamic \
	--sysconfdir=%_sysconfdir/%name \
	--localstatedir=%_localstatedir/%name

%make

pushd doc
texi2html -number quagga.texi
popd

%install

install -d $RPM_BUILD_ROOT/etc/{rc.d/init.d,sysconfig,logrotate.d,pam.d} \
        $RPM_BUILD_ROOT%_logdir/%name $RPM_BUILD_ROOT%_infodir \
	$RPM_BUILD_ROOT%_localstatedir/%name 

make install DESTDIR=$RPM_BUILD_ROOT

rm -f $RPM_BUILD_ROOT%_libdir/lib*.a
rm -f $RPM_BUILD_ROOT%_sysconfdir/%name/*.sample*

install -m 644 %SOURCE1 $RPM_BUILD_ROOT%_sysconfdir/logrotate.d/%name
install -m 644 %SOURCE2 $RPM_BUILD_ROOT%_sysconfdir/pam.d/%name
install -m 644 %SOURCE3 $RPM_BUILD_ROOT%_sysconfdir/sysconfig/%name

install %SOURCE20 $RPM_BUILD_ROOT%_sysconfdir/%name/zebra.conf
install %SOURCE21 $RPM_BUILD_ROOT%_sysconfdir/%name/ripd.conf
install %SOURCE22 $RPM_BUILD_ROOT%_sysconfdir/%name/ripngd.conf
install %SOURCE23 $RPM_BUILD_ROOT%_sysconfdir/%name/ospfd.conf
install %SOURCE24 $RPM_BUILD_ROOT%_sysconfdir/%name/ospf6d.conf
install %SOURCE25 $RPM_BUILD_ROOT%_sysconfdir/%name/bgpd.conf
install %SOURCE26 $RPM_BUILD_ROOT%_sysconfdir/%name/isisd.conf
install %SOURCE28 $RPM_BUILD_ROOT%_sysconfdir/%name/pimd.conf

install -m 755 %SOURCE10 $RPM_BUILD_ROOT%_initdir/zebra
install -m 755 %SOURCE11 $RPM_BUILD_ROOT%_initdir/ripd
install -m 755 %SOURCE12 $RPM_BUILD_ROOT%_initdir/ripngd
install -m 755 %SOURCE13 $RPM_BUILD_ROOT%_initdir/ospfd
install -m 755 %SOURCE14 $RPM_BUILD_ROOT%_initdir/ospf6d
install -m 755 %SOURCE15 $RPM_BUILD_ROOT%_initdir/bgpd
install -m 755 %SOURCE16 $RPM_BUILD_ROOT%_initdir/isisd
install -m 755 %SOURCE18 $RPM_BUILD_ROOT%_initdir/pimd

install -m 755 %SOURCE19 $RPM_BUILD_ROOT%_initdir/watchquagga

%pre
/usr/sbin/groupadd -rf %vty_gid
/usr/sbin/groupadd -rf %quagga_gid

/usr/sbin/useradd -r -g %quagga_gid -d /dev/null -s /dev/null -n %quagga_user &>/dev/null ||:
/usr/sbin/usermod -G %vty_gid %quagga_user &>/dev/null ||:

%post
# "&>/dev/null" used for restarting when connection lost
{
%post_service zebra
%post_service ripd
%post_service ospfd
%post_service ospf6d
%post_service ripngd
%post_service bgpd
%post_service isisd
%post_service pimd
%post_service watchquagga
} &>/dev/null

%preun
%preun_service watchquagga
%preun_service ripd
%preun_service ospfd
%preun_service ospf6d
%preun_service ripngd
%preun_service bgpd
%preun_service isisd
%preun_service pimd
%preun_service zebra

%files
%attr(3750,root,%quagga_gid) %dir %_sysconfdir/%name
%attr(3775,root,%quagga_gid) %dir %_localstatedir/%name
%attr(3770,root,%quagga_gid) %dir %_logdir/%name

%config %_initdir/*
%config(noreplace) %attr(0660, root, %quagga_gid) %_sysconfdir/%name/*
%config(noreplace) %_sysconfdir/logrotate.d/%name
%config %_sysconfdir/pam.d/%name
%config %_sysconfdir/sysconfig/%name

%_bindir/*

%exclude %_sbindir/ospfclient
%_sbindir/*

%_mandir/man?/*
%doc AUTHORS README SERVICES NEWS README-build-config

%files -n libquagga
%_libdir/lib*.so.*

%files devel
%_libdir/lib*.so
%dir %_includedir/%name
%dir %_includedir/%name/ospfd
%dir %_includedir/%name/ospfapi
%_includedir/%name/*.h
%_includedir/%name/ospfd/*.h
%_includedir/%name/ospfapi/*.h

%files ospfclient
%_sbindir/ospfclient

%files doc
%_infodir/*
%doc tools ChangeLog INSTALL TODO
%doc doc/quagga.html
%doc */*.sample*
%doc doc/mpls
%doc bgpd/BGP4-MIB.txt ospfd/OSPF-MIB.txt ospfd/OSPF-TRAP-MIB.txt
%doc ripd/RIPv2-MIB.txt zebra/GNOME-PRODUCT-ZEBRA-MIB zebra/GNOME-SMI
%doc doc/draft-zebra-00.* doc/BGP-TypeCode

%changelog
