%define ver_major 2.1

Name: rawstudio
Version: %ver_major
Release: alt0.5

Summary: Rawstudio is an open source raw-image converter written in GTK+
License: GPLv2+
Group: Graphics

URL: http://rawstudio.org/
#VCS: https://github.com/rawstudio/rawstudio
Source: %name-%version.tar
#Source: http://rawstudio.org/files/release/rawstudio-%version.tar.gz

Patch1: rawstudio-2.0-fc-lensfun.patch
Patch2: rawstudio-2.1-alt-lfs.patch
Patch3: rawstudio-2.1-exiv2-0.27.patch

BuildRequires: gcc-c++ libappstream-glib-devel libGConf-devel libdbus-devel libexiv2-devel libfftw3-devel libflickcurl-devel
BuildRequires: libgphoto2-devel libgtk+3-devel libjpeg-devel liblcms-devel liblensfun-devel libpng-devel
BuildRequires: libsqlite3-devel libssl-devel libtiff-devel libosm-gps-map-devel libxml2-devel

%description
Rawstudio can read and convert RAW-images from most digital cameras.

%prep
%setup
%patch1 -p1
%patch2
%patch3 -p1 -b .exiv2

[ ! -d m4 ] && mkdir m4

%build
glib-gettextize -c -f
%autoreconf
%configure --disable-static
%make_build

%install
%makeinstall_std

%find_lang %name

%files -f %name.lang
%_bindir/%name
%_libdir/%name/
%_datadir/%name/
%_libdir/lib%name-%ver_major.so
%_libdir/lib%name.so
%_datadir/rawspeed/
%_pixmapsdir/*
%_iconsdir/%name.png
#%_liconsdir/*
%_desktopdir/%name.desktop
%_datadir/appdata/%name.appdata.xml

%exclude %_includedir/%name-%ver_major/
#%exclude %_libdir/*.so
%exclude %_pkgconfigdir

%changelog
