# SPDX-License-Identifier: GPL-2.0-only
# Copyright (C) 2019 Vitaly Chikunov <vt@altlinux.org>
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1

Name: rpm-build-vm
Version: 1.25
Release: alt1

Summary: RPM helper to run tests in virtualised environment
License: GPL-2.0-only
Group: Development/Other

Source: %name-%version.tar

%define supported_arches %ix86 x86_64 ppc64le aarch64 armh

%ifarch %supported_arches
# We need static libs to build initramfs /init binary:
#   klibc-devel        - cannot call arbitrary syscall.
#   musl-devel         - does not cover all arches.
#   glibc-devel-static - binaries are bigger.
BuildRequires: klibc-devel
# For %%check.
BuildRequires: /dev/kvm

# Try to load un-def kernel this way to avoid "forbidden dependencies"
# from sisyphus_check.
Requires(pre): kernel >= 5.7
%endif

Requires(pre): %name-run = %EVR

%ifarch %supported_arches
%description
RPM helper to run QEMU inside hasher. This is mainly intended
for %%check section to test software under better emulated root
than fakeroot.

This is similar to multiple vm scripts, virtme, vido, and eudyptula-boot.
%else
%description
This package is a stub instead of RPM helper to run QEMU inside hasher
on supported architectures (this one (%_arch) is unsupported).
%endif

%package run
Summary: vm-run virtualized runner
Group: Development/Other

# Other arches will get a stub which will always return success
%ifarch %supported_arches
Requires: mount

# /proc is required for qemu 9p to work, otherwise you'll get
# confusing ENOENT when creating a file. This is because
# `qemu/hw/9pfs/9p-local.c:fchmodat_nofollow' is doing chmod
# over `/proc/self/fd/%%d'.
Requires: /proc
Requires: /dev/kvm

%ifarch %ix86 x86_64
Requires: qemu-system-x86-core
%endif
%ifarch ppc64le
Requires: qemu-system-ppc-core
%endif
%ifarch aarch64
Requires: qemu-system-aarch64-core
%endif
%ifarch armh
# No KVM support in the kernel for this arch.
Requires: qemu-system-arm-core
%endif

%endif

%ifarch %supported_arches
%description run
RPM helper to run QEMU inside hasher. This is mainly intended
for %%check section to test software under better emulated root
than fakeroot.

This is similar to multiple vm scripts, virtme, vido, and eudyptula-boot.

This package is vm-run scripts only (without requirement on the kernel).
%else
%description run
This package is a stub instead of RPM helper to run QEMU inside hasher
on supported architectures (this one (%_arch) is unsupported).
%endif

%package checkinstall
Summary: Checkinstall for vm-run
Group: Development/Other
BuildArch: noarch
Requires(pre): %name = %EVR

%description checkinstall
Run checkinstall tests for vm-run.

%prep
%setup

%ifarch %supported_arches
%build
%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
[ -x /usr/bin/musl-gcc ] && export CC=musl-gcc
[ -x /usr/bin/klcc     ] && export CC=klcc
CFLAGS="%optflags" make
%endif

bash -n vm-run
bash -n vm-init
bash -n filetrigger

%install
%ifnarch %supported_arches
install -D -p -m 0755 vm-run-stub %buildroot%_bindir/vm-run
%else
install -D -p -m 0755 vm-run      %buildroot%_bindir/vm-run
install -D -p -m 0755 vm-init     %buildroot%_libexecdir/vm-run/vm-init
install -D -p -m 0755 initrd-init %buildroot%_libexecdir/vm-run/initrd-init
install -D -p -m 0755 filetrigger %buildroot%_rpmlibdir/vm-run.filetrigger
%endif

%pre run
# Only allow to install inside of hasher.
[ -d /.host -a -d /.in -a -d /.out ] || {
        echo >&2 'rpm-build-vm-run is not allowed outside hasher environments'
        exit 1
}

%files

%files checkinstall

%files run
%_bindir/vm-run

%ifarch %supported_arches
%_libexecdir/vm-run
%_rpmlibdir/vm-run.filetrigger

%post
# Fix permissions to boot the installed kernel
find /boot /lib/modules -type f,d \! -perm -444 -print0 | xargs -0r chmod a+rX

%post run
# Required in case of --udevd option to vm-run
mkdir -p /run/udev
chmod a+twx /run/udev

# Just in case
mkdir -p /run/dbus
chmod a+twx /run/dbus

# u&mount should to be readable to use inside vm
control mount unprivileged

# For --overlay=
chmod a+twx /mnt

# Allow user creation (for openssh)
chmod a+r /etc/login.defs

%ifarch armh
# Workaround to KVM not working on armh: signal to scripts that we don't have
# kvm. This will work on normal build, but will be cleared on hsh-shell, that
# will not produce failure though, just more warnings from qemu.
chmod go-rwx /dev/kvm
%endif
%endif

%pre checkinstall
set -ex
# qemu in tcg mode can hang un-def-5.10 kernel on ppc64 if smp>1 on "smp:
# Bringing up secondary CPUs" message.
%ifarch %supported_arches
ls -l /dev/kvm
%endif
timeout 300 vm-run --verbose uname -a
timeout 300 vm-run --verbose --overlay=ext4 uname -a

%ifarch %ix86 x86_64 ppc64le aarch64
%check
# Verify availability of KVM in girar & beehiver.
# armh is intentionally excluded from the test.
ls -l /dev/kvm && test -w /dev/kvm
%endif

%changelog
