%define        pkgname addressable

Name:          ruby-%pkgname
Version:       2.6.0
Release:       alt1
Summary:       Addressable is a replacement for the URI implementation that is part of Ruby's standard library
Summary(ru_RU.UTF-8): "Адресуемый" есть заменою воплощения URI, который является частью стандартной библиотеки рубина
Group:         Development/Ruby
License:       Apache-2.0
URL:           http://addressable.rubyforge.org/
# VCS:         https://github.com/sporkmonger/addressable.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>
BuildArch:     noarch

Source:        %name-%version.tar
BuildRequires(pre): rpm-build-ruby

%description
Addressable is a replacement for the URI implementation that is part of
Ruby's standard library. It more closely conforms to RFC 3986, RFC 3987,
and RFC 6570 (level 4), providing support for IRIs and URI templates.

%description   -l ru_RU.UTF-8
"Адресуемый" есть замена воплощения URI, который является частью стандартной
библиотеки рубина. Бн более точно удовлетворяет стандартам RFC 3986, RFC 3987,
и RFC 6570 (уровня 4), поддержиивая IRI и URI шаблоны.


%package       doc
Summary:       Documentation for %name
Group:         Development/Documentation
BuildArch:     noarch

%description   doc
Documentation for %{name}.

%description   -l ru_RU.UTF-8 doc
Документация для %{name}.


%prep
%setup
sed "s|File.join(File.dirname(__FILE__), '../../..', 'data/unicode.data')|'%_datadir/%name/unicode.data'|" -i lib/addressable/idna/pure.rb

%build
%gem_build

%install
%gem_install
install -D data/unicode.data %buildroot%_datadir/%name/unicode.data

%check
%gem_test

%files
%doc README*
%ruby_gemlibdir
%ruby_gemspec
%_datadir/%name

%files doc
%ruby_gemdocdir

%changelog
