%define        pkgname aws-sdk

Name: 	       ruby-%pkgname
Version:       2.11.478
Release:       alt1
Summary:       The official AWS SDK for Ruby
License:       Apache-2.0
Group:         Development/Ruby
Url:           https://aws.amazon.com/ru/sdk-for-ruby/
Vcs:           https://github.com/aws/aws-sdk-ruby.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>

Source:        %name-%version.tar
BuildRequires(pre): rpm-build-ruby
BuildRequires: gem(rake)
BuildRequires: gem(rspec) >= 3.0
BuildRequires: gem(yard)
BuildRequires: gem(simplecov)
BuildRequires: gem(kramdown)
BuildRequires: gem(benchmark-ips) >= 2.0
BuildRequires: gem(rake-compiler)
BuildRequires: gem(ruby-ll) >= 2.1
BuildRequires: gem(ast)
BuildRequires: gem(ox)
BuildRequires: gem(nokogiri)
BuildRequires: gem(jmespath)
BuildRequires: ragel
BuildRequires: /usr/bin/ruby-ll

%gem_replace_version nokogiri >= 1.10
%gem_replace_version yard >= 0.9

%description
The official AWS SDK for Ruby. Provides both resource oriented
interfaces and API clients for AWS services.


%package       -n gem-%pkgname
Summary:       AWS SDK for Ruby - Core
Group:         Development/Ruby
BuildArch:     noarch

%description   -n gem-%pkgname
The official AWS SDK for Ruby. Provides both resource oriented
interfaces and API clients for AWS services.


%package       -n gem-%pkgname-core
Summary:       AWS SDK for Ruby - Core
Group:         Development/Ruby
BuildArch:     noarch

Obsoletes:     aws-sdk-core
Provides:      aws-sdk-core
Obsoletes:     ruby-aws-sdk-core
Provides:      ruby-aws-sdk-core

%description   -n gem-%pkgname-core
Provides API clients for AWS. This gem is part of the official AWS SDK
for Ruby.


%package       -n gem-%pkgname-resources
Summary:       AWS SDK for Ruby - Resources
Group:         Development/Ruby
BuildArch:     noarch

%description   -n gem-%pkgname-resources
Provides resource oriented interfaces and other higher-level
abstractions for many AWS services. This gem is part of the official AWS
SDK for Ruby.


%package       -n gem-%pkgname-doc
Summary:       Documentation files for %gemname gem
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета %gemname
Group:         Development/Documentation
BuildArch:     noarch

%description   -n gem-%pkgname-doc
Documentation files for %gemname gem.

%description   -n gem-%pkgname-doc -l ru_RU.UTF8
Файлы сведений для самоцвета %gemname.


%package       -n gem-%pkgname-core-doc
Summary:       Documentation files for %gemname gem
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета %gemname
Group:         Development/Documentation
BuildArch:     noarch

%description   -n gem-%pkgname-core-doc
Documentation files for %gemname gem.

%description   -n gem-%pkgname-core-doc -l ru_RU.UTF8
Файлы сведений для самоцвета %gemname.


%package       -n gem-%pkgname-resources-doc
Summary:       Documentation files for %gemname gem
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета %gemname
Group:         Development/Documentation
BuildArch:     noarch

%description   -n gem-%pkgname-resources-doc
Documentation files for %gemname gem.

%description   -n gem-%pkgname-resources-doc -l ru_RU.UTF8
Файлы сведений для самоцвета %gemname.


%prep
%setup

%build
%ruby_build --use=ruby-aws-sdk --prefixes= \
            --use=aws-sdk --prefixes=gem --version-replace=%version \
            --use=aws-sdk-resources --version-replace=%version \
            --use=aws-sdk-core --version-replace=%version

%install
%ruby_install

%check
%ruby_test

%files
%doc README*
%_libexecdir/%name
%_bindir/aws.rb

%files         -n gem-%pkgname
%doc README*
%ruby_gemspec
%ruby_gemlibdir

%files         -n gem-%pkgname-doc
%ruby_gemdocdir

%files         -n gem-%pkgname-core
%doc README*
%ruby_gemspecdir/%gemname-core-%version.gemspec
%ruby_gemslibdir/%gemname-core-%version

%files         -n gem-%pkgname-core-doc
%ruby_gemsdocdir/%gemname-core-%version

%files         -n gem-%pkgname-resources
%doc README*
%ruby_gemspecdir/%gemname-resources-%version.gemspec
%ruby_gemslibdir/%gemname-resources-%version

%files         -n gem-%pkgname-resources-doc
%ruby_gemsdocdir/%gemname-resources-%version


%changelog
