%define        pkgname fog-google

Name:          ruby-%pkgname
Version:       1.9.1
Release:       alt1
Epoch:         1
Summary:       Fog for Google Cloud Platform
License:       MIT
Group:         Development/Ruby
Url:           https://github.com/fog/fog-google
%vcs           https://github.com/fog/fog-google.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>
BuildArch:     noarch

Source:        %name-%version.tar
BuildRequires(pre): rpm-build-ruby

%gem_replace_version fog-core ~> 2.0
%gem_replace_version google-api-client ~> 0.24

%description
%summary.

There are two ways to access Google Cloud Storage. The old S3 API and the new
JSON API. Fog::Storage::Google will automatically direct you to the appropriate
API based on the credentials you provide it.

* The XML API is almost identical to S3. Use Google's interoperability keys
  to access it.
* The new JSON API is faster and uses auth similarly to the rest of the Google
  Cloud APIs using a service account private key.


%package       doc
Summary:       Documentation files for %gemname gem
Group:         Development/Documentation
BuildArch:     noarch

%description   doc
Documentation files for %gemname gem.

%description   doc -l ru_RU.UTF8
Файлы сведений для %gemname самоцвета


%prep
%setup

%build
%gem_build

%install
%gem_install

%check
%gem_test

%files
%ruby_gemspec
%ruby_gemlibdir

%files         doc
%ruby_gemdocdir

%changelog
