# vim: set ft=spec: -*- rpm-spec -*-

%define pkgname mime-types

Name:    ruby-%pkgname
Version: 3.2.2
Release: alt1

Summary: Manages a MIME Content-Type database that will return the Content-Type for a given filename
Group:   Development/Ruby
License: Ruby/Perl/GPLv2+
Url:     https://github.com/mime-types/ruby-mime-types

BuildArch: noarch

Source0: %pkgname-%version.tar

BuildRequires: rpm-build-ruby ruby-tool-rdoc ruby-tool-setup

%description
MIME::Types for Ruby originally based on and synchronized with
MIME::Types for Perl by Mark Overmeer, copy right 2001 - 2009. As of
version 1.15, the data format for the MIME::Type list has changed and
the synchronization will no longer happen.

%package doc
Summary: Documentation files for %name
Group: Documentation

%description doc
Documentation files for %name.

%prep
%setup -n %pkgname-%version
%update_setup_rb

%build
%ruby_config
%ruby_build

%check
%ruby_test_unit -Ilib:test tests

%install
%ruby_install
%rdoc lib/
# Remove unnecessary files
rm -f %buildroot%ruby_ri_sitedir/{Object/cdesc-Object.ri,cache.ri,created.rid}

%files
%doc *.rdoc
%ruby_sitelibdir/*
%rubygem_specdir/*

%files doc
%ruby_ri_sitedir/*

%changelog
