%def_disable check
%define pkgname tzinfo

Name: ruby-%pkgname
Version: 1.2.5
Release: alt1
Summary: Daylight-savings aware timezone support for Ruby
License: MIT
Group: Development/Ruby
Url: http://rubyforge.org/projects/tzinfo/

Source: %pkgname-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-ruby

%description
TZInfo uses the tz database (http://www.twinsun.com/tz/tz-link.htm)
to provide daylight-savings aware transformations between times in
different timezones.

This is the same database as used for zoneinfo on Unix machines.

%package doc
Summary: Documentation files for %pkgname
Group: Documentation

%description doc
Documentation files for %pkgname

%prep
%setup -q -n %pkgname-%version
%update_setup_rb

%build
%ruby_config
%ruby_build

%install
%ruby_install
%rdoc --exclude definitions --exclude indexes lib/

%add_findprov_skiplist %ruby_sitelibdir/tzinfo/definitions/*
%add_findprov_skiplist %ruby_sitelibdir/tzinfo/indexes/*

%check
%ruby_test_unit -Ilib:test test/tc_*.rb

%files
%doc CHANGES* README*
%ruby_sitelibdir/*
%rubygem_specdir/*

%files doc
%ruby_ri_sitedir/TZInfo*

%changelog
