# vim: set ft=spec: -*- rpm-spec -*-

%define pkgname xmpp4r

Name: ruby-%pkgname
Version: 0.5.6
Release: alt1

Summary: XMPP/Jabber library for Ruby
License: GPLv2/Ruby
Group: Development/Ruby

# see also https://github.com/ln/xmpp4r
Url: http://home.gna.org/xmpp4r/
Source: %pkgname-%version.tar

Obsoletes: xmpp4r
BuildArch: noarch

BuildRequires: rpm-build-ruby ruby-test-unit ruby-tool-rdoc ruby-tool-setup

%description
XMPP4R is an XMPP/Jabber library for Ruby. Its goal is to provide
a complete framework to develop Jabber-related applications or
scripts in Ruby.

 * Fully object-oriented
 * Aims at being XMPP compliant
 * Threaded, events-based
 * Well unit-tested and documented code
 * Uses well-known and well-tested software like REXML, instead
   of reinventing the wheel
 * Very easy to extend

%package doc
Summary: Documentation files for %name
Group: Documentation

%description doc
Documentation files for %name

%prep
%setup -n %pkgname-%version
%update_setup_rb

%build
%ruby_config
%ruby_build

%install
%ruby_install
%rdoc lib/

%files
%doc CHANGELOG README.rdoc
%ruby_sitelibdir/*
%rubygem_specdir/*

%files doc
%doc data/doc/xmpp4r/examples
%ruby_ri_sitedir/Jabber*

%changelog
