Name: rust
Epoch: 1
Version: 1.64.0
Release: alt0.c9.2
Summary: The Rust Programming Language

%define r_ver 1.63.0

Group: Development/Other
License: Apache-2.0 and MIT
URL: http://www.rust-lang.org/

# https://static.rust-lang.org/dist/rustc-%version-src.tar.gz
Source: %name-%version.tar

Patch1: rust-gdb.patch
Patch2: rust-disable-lint-tests.patch
Patch3: rust-private-function-on-32-bit-arch.patch
Patch4: rust-disable-outline-atomics-on-aarch64.patch

%def_without bootstrap
%def_without bundled_llvm
%def_without debuginfo
%global llvm_version 13.0

%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1

Requires: /proc

BuildRequires: /proc

# for gdb python binding
BuildRequires(pre): rpm-build-python3

BuildRequires: libstdc++-devel
BuildRequires: libstdc++-devel-static
BuildRequires: curl
BuildRequires: cmake
BuildRequires: binutils
BuildRequires: python3-base
BuildRequires: pkgconfig(libcurl)
BuildRequires: pkgconfig(liblzma)
BuildRequires: pkgconfig(openssl)
BuildRequires: pkgconfig(zlib)
#BuildRequires: pkgconfig(libgit2)
BuildRequires: pkgconfig(libssh2)
BuildRequires: pkgconfig(tinfo)
%if_without bundled_llvm
BuildRequires: pkgconfig(libffi)
BuildRequires: clang%{llvm_version}
BuildRequires: clang%{llvm_version}-devel
BuildRequires: llvm%{llvm_version}-devel
BuildRequires:  lld%{llvm_version}-devel
%else
BuildRequires: gcc-c++
BuildRequires: ninja-build
%endif
%ifarch aarch64
BuildRequires: patchelf
%endif

%if_without bootstrap
BuildRequires: rust rust-cargo
%define cargo %_bindir/cargo
%define rustc %_bindir/rustc
%else
%define rustdir %_tmppath/rust
%define cargo %rustdir/bin/cargo
%define rustc %rustdir/bin/rustc
%endif

%ifarch %ix86
%define r_arch i686
%endif
%ifarch x86_64
%define r_arch x86_64
%endif
%ifarch aarch64
%define r_arch aarch64
%endif
%ifarch armh
%define r_arch armv7
%endif
%ifarch ppc64le
%define r_arch powerpc64le
%endif

%ifarch armh
%define abisuff eabihf
%else
%define abisuff %nil
%endif

%define rust_triple %r_arch-unknown-linux-gnu%abisuff
%define rustlibdir %_libdir/rustlib
%define _libexecdir /usr/libexec

# Since 1.12.0: striping debuginfo damages *.so files
%if_without debuginfo
%add_debuginfo_skiplist %_libdir %_bindir
%endif

%description
Rust is a systems programming language that runs blazingly fast, prevents
segfaults, and guarantees thread safety.

%package gdb
Group: Development/Other
Summary: run rust compiler under gdb
Requires: %name = %epoch:%version-%release
Requires: gdb
AutoReq: nopython,nopython3
AutoProv: nopython,nopython3

%description gdb
%summary

%package doc
Summary: Documentation for Rust
Group: Development/Documentation
# NOT BuildArch: noarch
# Note, while docs are mostly noarch, some things do vary by target_arch.

%description doc
This package includes HTML documentation for the Rust programming language and
its standard library.

%package cargo
Summary: The Rust package manager
Group: Development/Tools
Requires: rust

%description cargo
Cargo is a tool that allows Rust projects to declare their various dependencies
and ensure that you'll always get a repeatable build.

%package cargo-doc
Summary: Documentation for Cargo
Group: Development/Documentation
BuildArch: noarch
# Cargo no longer builds its own documentation
# https://github.com/rust-lang/cargo/pull/4904
Requires: rust-doc = %epoch:%version-%release

%description cargo-doc
This package includes HTML documentation for Cargo.

%package -n rustfmt
Summary: Tool to find and fix Rust formatting issues
Group: Development/Tools
Requires: rust-cargo = %epoch:%version-%release

%description -n rustfmt
A tool for formatting Rust code according to style guidelines.

%package -n rls
Summary: Rust Language Server for IDE integration
Group: Development/Tools
Requires: rust-analysis
Requires: %name = %epoch:%version-%release

%description -n rls
The Rust Language Server provides a server that runs in the background,
providing IDEs, editors, and other tools with information about Rust programs.
It supports functionality such as 'goto definition', symbol search,
reformatting, and code completion, and enables renaming and refactorings.

%package -n clippy
Summary: Lints to catch common mistakes and improve your Rust code
Group: Development/Tools
License: MPL-2.0
Requires: rust-cargo
Requires: %name = %epoch:%version-%release

%description -n clippy
A collection of lints to catch common mistakes and improve your Rust code.

%package src
Summary: Sources for the Rust standard library
Group: Development/Other
AutoReq: no
AutoProv: no

%description src
This package includes source files for the Rust standard library.  It may be
useful as a reference for code completion tools in various editors.

%package analysis
Summary: Compiler analysis data for the Rust standard library
Group: Development/Tools
Requires: %name = %epoch:%version-%release

%description analysis
This package contains analysis data files produced with rustc's -Zsave-analysis
feature for the Rust standard library. The RLS (Rust Language Server) uses this
data to provide information about the Rust standard library.

%prep
%setup
%patch1 -p1
%patch2 -p1
%ifarch %ix86 armh
%patch3 -p1 -R
%endif
%ifarch aarch64
%patch4 -p1
%endif

%if_with bootstrap
tar xf .rpm/rust-%r_ver-%rust_triple.tar.gz
mkdir -p %rustdir
pushd rust-%r_ver-%rust_triple
./install.sh --prefix=%rustdir
popd

%ifarch aarch64
patchelf --set-interpreter /lib64/ld-linux-aarch64.so.1 %rustdir/bin/cargo
patchelf --set-interpreter /lib64/ld-linux-aarch64.so.1 %rustdir/bin/rustc
%endif

%else
# Fix libdir path for bootstrap
sed -i 's/Path::new("lib")/Path::new("%_lib")/' src/bootstrap/builder.rs
%endif

# This only affects the transient rust-installer, but let it use our dynamic xz-libs
sed -i -e '/LZMA_API_STATIC/d' src/bootstrap/tool.rs

%if_without bundled_llvm
rm -rf -- src/llvm-project
mkdir -p -- src/llvm-project/libunwind/
%endif

# We never enable emscripten.
rm -rf src/llvm-emscripten/

# We never enable other LLVM tools.
rm -rf src/tools/clang
rm -rf src/tools/lld
rm -rf src/tools/lldb

# Remove other unused vendored libraries
rm -rf vendor/curl-sys/curl
rm -rf vendor/jemalloc-sys/jemalloc
rm -rf vendor/libz-sys/src/zlib
rm -rf vendor/lzma-sys/xz-*
rm -rf vendor/openssl-src/openssl

# CI tooling won't be used
rm -rf src/ci

# Remove hidden files from source
find src/ -type f -name '.appveyor.yml' -delete
find src/ -type f -name '.travis.yml' -delete
find src/ -type f -name '.cirrus.yml' -delete

# The configure macro will modify some autoconf-related files, which upsets
# cargo when it tries to verify checksums in those files.  If we just truncate
# that file list, cargo won't have anything to complain about.
find vendor \
	-name .cargo-checksum.json \
	-exec sed -i -e 's/"files":{[^}]*}/"files":{ }/' '{}' '+'


%build
cat >env.sh <<EOF
export RUST_BACKTRACE=1
%ifarch aarch64
export RUSTFLAGS="-Clink-arg=-Wl,-z,relro,-z,now -Clink-args=-fPIC -Copt-level=2 -Ctarget-feature=-outline-atomics"
%else
export RUSTFLAGS="-Clink-arg=-Wl,-z,relro,-z,now -Clink-args=-fPIC -Copt-level=2"
%endif
# Don't use system libgit2 for now...
# https://github.com/rust-lang/rust/issues/63476
#export LIBGIT2_SYS_USE_PKG_CONFIG=1
export LIBSSH2_SYS_USE_PKG_CONFIG=1
export DESTDIR="%buildroot"
export ALTWRAP_LLVM_VERSION="%llvm_version"
EOF

cat > config.toml <<EOF
[build]
cargo = "%cargo"
rustc = "%rustc"
python = "python3"
submodules = false
docs = true
verbose = 2
vendor = true
extended = true
tools = ["cargo", "rls", "clippy", "rustfmt", "analysis", "src"]
build-stage = 2
test-stage = 2
doc-stage = 2

[install]
prefix = "%prefix"
libdir = "%_lib"

[rust]
channel = "stable"
codegen-tests = false
backtrace = true
jemalloc = false
rpath = false
debug = false
deny-warnings = false
%if_without debuginfo
debuginfo-level = 0
codegen-units = 2
%else
debuginfo-level = 1
codegen-units = 0
%endif

[llvm]
ninja = true
use-libcxx = false
%if_without bundled_llvm
link-shared = true

[target.%rust_triple]
cc = "clang"
cxx = "clang++"
ar = "llvm-ar"
ranlib = "llvm-ranlib"
llvm-config = "/usr/bin/llvm-config"
%endif
EOF

. ./env.sh

python3 x.py build
python3 x.py doc


%install
. ./env.sh

python3 x.py install

rm -f -- %buildroot/%_libdir/lib*.so.old

# The libdir libraries are identical to those under rustlib/.  It's easier on
# library loading if we keep them in libdir, but we do need them in rustlib/
# to support dynamic linking for compiler plugins, so we'll symlink.
find %buildroot/%rustlibdir/%rust_triple/lib \
	-name '*.so' -printf '%%f %%p\n' |
while read -r n rustlib; do
	lib="%buildroot/%_libdir/$n"

	[ -e "$lib" ] ||
		continue

	c="$(sha1sum "$rustlib" "$lib" |cut -f1 -d\  |uniq |wc -l)"

	[ "$c" = 1 ] ||
		continue

	ln -s -f -- "$(relative "$lib" "$rustlib")" "$rustlib"
done

# Remove installer artifacts (manifests, uninstall scripts, etc.)
find %buildroot/%rustlibdir -maxdepth 1 -type f -delete

# We don't actually need to ship any of those python scripts in rust-src anyway.
find %buildroot/%rustlibdir/src -type f -name '*.py' -delete

# Drop compiled python
find %buildroot/%rustlibdir/etc -type f -name '*.pyc' -delete
%add_python3_path %rustlibdir/etc

%check
%ifnarch aarch64
. ./env.sh
%if_without bundled_llvm
# ensure that rustc_driver is actually dynamically linked to libLLVM
find %buildroot/%_libdir \
	-name 'librustc_driver-*.so' -execdir objdump -p '{}' '+' |
	grep -qs 'NEEDED.*LLVM'
%endif

# https://rustc-dev-guide.rust-lang.org/tests/intro.html
failed=
for i in \
	codegen \
	codegen-units \
	incremental \
	mir-opt \
; do
	: "### rust_src_test: running $i"
	status='done'
	if ! python3 ./x.py test --no-doc --no-fail-fast "src/test/$i"; then
		status='failed'
		failed="$failed $i"
	fi
	: "### rust_src_test: $i $status"
done

if [ -n "$failed" ]; then
	: "### rust_src_test: failure summary: $failed"
	: "### aborting due to test failures"
	exit 1
fi
%endif

%clean
%if_with bootstrap
rm -rf %rustdir
%endif


%files
%exclude %_datadir/doc/rust
%doc COPYRIGHT LICENSE-APACHE LICENSE-MIT README.md
%_bindir/rustc
%_bindir/rustdoc
%_libdir/lib*.so
%_libexecdir/rust-analyzer-proc-macro-srv
%dir %rustlibdir
%dir %rustlibdir/etc
%dir %rustlibdir/%rust_triple
%rustlibdir/%rust_triple/*
%exclude %rustlibdir/%rust_triple/analysis
%exclude %rustlibdir/etc/*
%_man1dir/rustc.*
%_man1dir/rustdoc.*

%files gdb
%_bindir/rust-gdb
%_bindir/rust-gdbgui
%exclude %_bindir/rust-lldb
%rustlibdir/etc/*
%exclude %rustlibdir/etc/lldb_*

%files doc
%_datadir/doc/%name
%exclude %_datadir/doc/%name/html/cargo

%files cargo
%doc src/tools/cargo/{LICENSE-APACHE,LICENSE-MIT,LICENSE-THIRD-PARTY,README.md}
%_bindir/cargo
%_libexecdir/cargo-credential-1password
%_man1dir/cargo*.1*
%_sysconfdir/bash_completion.d/cargo
%_datadir/zsh/site-functions/_cargo

%files cargo-doc
%_datadir/doc/rust/html/cargo

%files -n rustfmt
%_bindir/rustfmt
%_bindir/cargo-fmt
%doc src/tools/rustfmt/{README.md,CHANGELOG.md,Configurations.md,LICENSE-APACHE,LICENSE-MIT}

%files -n rls
%_bindir/rls
%doc src/tools/rls/{README.md,COPYRIGHT,debugging.md,LICENSE-APACHE,LICENSE-MIT}

%files -n clippy
%_bindir/cargo-clippy
%_bindir/clippy-driver
%doc src/tools/clippy/{README.md,CHANGELOG.md,LICENSE*}

%files src
%rustlibdir/src

%files analysis
%rustlibdir/%rust_triple/analysis

%changelog
