%define oname opennx

Name: rxclient
Version: 1.0.1
Release: alt1

Summary: A client for RX@Etersoft Terminal Server

License: LGPL/GPL
Group: Networking/Remote access
Url: https://wiki.etersoft.ru/RX

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://gitlab.eterfund.ru/rx-etersoft/rxclient/-/archive/%version-%release/rxclient-%version-%release.tar.bz2
Source: %oname-%version.tar
Source1: rxclient.conf

# Automatically added by buildreq on Sat Sep 19 2009
BuildRequires: gcc-c++ imake libSM-devel libXmu-devel
BuildRequires: libopensc-devel libsmbclient-devel
BuildRequires: xorg-cf-files zip libcups-devel
BuildRequires: libXau-devel
BuildRequires: libwxGTK3.0-devel xxd

# due _ln_sr
BuildRequires: rpm-build-intro >= 1.9.18

Requires: nx-libs >= 3.5.2.31-alt1
Requires: nxssh

Provides: opennx = %version
Obsoletes: opennx

# dynamic loading
Requires: libcups libsmbclient

%description
RX Client is a NX 3.5 compatible client based on OpenNX code.

%prep
%setup

%build
%autoreconf
%configure --localedir=%_datadir/locale --with-nxproto=3.3.0
%make_build

%install
%makeinstall_std

# install workaround for eterbug #11493
install -D -m0755 bin/nxssh.sh %buildroot%_bindir/nxssh.sh

# socks support
#rm -f %buildroot%_bindir/pconnect %buildroot%_datadir/pconnect.html

rm -f %buildroot%_desktopdir/*.directory
install -D -m0644 docs/pconnect.1 %buildroot%_man1dir/pconnect.1

# we need this names due wxDynamicLibrary (see eterbug #11676)
mkdir -p %buildroot%_libdir/%name/
for lib in libsmbclient.so libcups.so ; do
    rlib=$(echo %_libdir/$lib.?)
    %_ln_sr %buildroot$rlib %buildroot%_libdir/%name/$lib
done

mkdir -p %buildroot%_sysconfdir/%name/
cp %SOURCE1 %buildroot%_sysconfdir/%name/

%find_lang %name

%files -f %name.lang
%_bindir/%name
%_bindir/%name-report
%_bindir/nxssh.sh
%_bindir/pconnect
%_bindir/watchreader
%_libdir/%name/
%_man1dir/pconnect.*
%_datadir/%name
%_desktopdir/*.desktop
%_iconsdir/hicolor/*/apps/*.png
%_iconsdir/hicolor/scalable/apps/*.svg
%_iconsdir/hicolor/*/mimetypes/rx-desktop.*
%dir %_sysconfdir/%name
%config %_sysconfdir/%name/*.conf

%changelog
