%define _libexecdir %_prefix/libexec

%define ver_major 0.38
%def_enable external_plugin
%def_enable mpris_plugin
%def_enable tracker_plugin
%def_enable lms_plugin
%def_with ui
%define media_engine gstreamer

%if %media_engine == gstreamer
%def_enable playbin_plugin
%def_enable media_export_plugin
%def_enable gst_launch_plugin
%else
%def_disable playbin_plugin
%def_disable media_export_plugin
%def_disable gst_launch_plugin
%endif

Name: rygel
Version: %ver_major.1
Release: alt1

Summary: A UPnP v2 Media Server
Group: System/Servers
License: LGPLv2+
Url: https://wiki.gnome.org/Projects/Rygel

#Source: %name-%version.tar
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

%define libxml_ver 2.7
%define vala_ver 0.36.0
%define gi_ver 1.33.4
%define gssdp_ver 1.2.0
%define gupnp_ver 1.2.0
%define gupnp_av_ver 0.12.8
%define gupnp_dlna_ver 0.9.4
%define gstreamer_ver 1.0
%define gst_api_ver 1.0
%define gst_ver 1.12
%define gst_pbu_ver 1.12
%define gst_tag_ver 1.12
%define gst_app_ver 1.12
%define gst_audio_ver 1.12
%define gio_ver 2.44
%define gee_ver 0.8.0
%define uuid_ver 1.41.3
%define libsoup_ver 2.44.0
%define gtk_ver 3.22
%define libsqlite3_ver 3.5
%define mediaart_ver 1.9
%define tracker_ver 1.99.0

Requires: gstreamer%gst_api_ver >= %gst_ver
Requires: gst-plugins-base%gst_api_ver
Requires: gst-plugins-good%gst_api_ver
Requires: gst-plugins-bad%gst_api_ver
Requires: gst-plugins-ugly%gst_api_ver
Requires: gst-libav
Requires: tracker
Requires: lsdvd

BuildRequires: autoconf-archive gtk-doc valadoc
BuildRequires: gobject-introspection-devel >= %gi_ver
BuildRequires: pkgconfig(gssdp-1.2) >= %gssdp_ver
BuildRequires: pkgconfig(gupnp-1.2) >= %gupnp_ver
BuildRequires: pkgconfig(gupnp-av-1.0) >= %gupnp_av_ver
BuildRequires: pkgconfig(gio-2.0) >= %gio_ver
BuildRequires: pkgconfig(gmodule-2.0)
BuildRequires: pkgconfig(gee-0.8) >= %gee_ver
BuildRequires: pkgconfig(uuid) >= %uuid_ver
BuildRequires: pkgconfig(libsoup-2.4) >= %libsoup_ver
BuildRequires: pkgconfig(libxml-2.0) >= %libxml_ver
BuildRequires: pkgconfig(gstreamer-1.0) >= %gstreamer_ver
BuildRequires: pkgconfig(gstreamer-base-1.0) >= %gstreamer_ver
BuildRequires: pkgconfig(libmediaart-2.0) >= %mediaart_ver
%if %media_engine == gstreamer
BuildRequires: pkgconfig(gstreamer-pbutils-1.0) >= %gst_pbu_ver
BuildRequires: pkgconfig(gstreamer-app-1.0) >= %gst_app_ver
BuildRequires: pkgconfig(gstreamer-audio-1.0) >= %gst_audio_ver
BuildRequires: pkgconfig(gupnp-dlna-2.0) >= %gupnp_dlna_ver
BuildRequires: pkgconfig(gio-2.0) >= %gio_ver
BuildRequires: gir(Gst) = 1.0
%endif
BuildRequires: tracker-devel >= %tracker_ver
%{?_enable_media_export_plugin:BuildRequires: pkgconfig(sqlite3) >= %libsqlite3_ver pkgconfig(gstreamer-tag-1.0) >= %gst_tag_ver pkgconfig(gstreamer-app-1.0) >= %gst_app_ver pkgconfig(gupnp-dlna-2.0) >= %gupnp_dlna_ver pkgconfig(gupnp-dlna-gst-2.0) >= %gupnp_dlna_ver }
BuildRequires: libvala-devel >= %vala_ver vala >= %vala_ver
BuildRequires: vapi(gupnp-1.2) vapi(gupnp-av-1.0) vapi(gio-2.0) vapi(gee-0.8) vapi(posix)
BuildRequires: gir(GUPnP) = 1.2 gir(GUPnPAV) = 1.0 gir(GObject) = 2.0 gir(Gee) = 0.8 gir(Gio) = 2.0 gir(GLib) = 2.0
%{?_with_ui:BuildRequires: pkgconfig(gtk+-3.0) >= %gtk_ver}
%{?_enable_lms_plugin:BuildRequires: liblightmediascanner-devel libsqlite3-devel}
BuildRequires: xsltproc docbook-style-xsl docbook-dtds
BuildRequires: pkgconfig(systemd)

%description
Rygel is an implementation of the UPnP MediaServer V 2.0 specification that is
specifically designed for GNOME. It is based on GUPnP and is written (mostly)
in Vala language. The project was previously known as gupnp-media-server.

%package devel
Summary: Development package for %name
Group: Development/Other
Requires: %name = %version-%release

%description devel
Files for development with %name.

%package devel-doc
Summary: Development documentation for Rygel libraries
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name-devel < %version

%description devel-doc
Rygel is an implementation of the UPnP MediaServer V 2.0 specification that is
specifically designed for GNOME. It is based on GUPnP and is written (mostly)
in Vala language. The project was previously known as gupnp-media-server.

This package contains documentation needed to develop applications using Rygel
libraries.

%package tracker
Summary: Tracker plugin for %name
Group: System/Servers
Requires: %name = %version-%release
Requires: tracker

%description tracker
A plugin for rygel to use tracker to locate media on the local machine.

%package lms
Summary: Lightweight media scanner plugin for %name
Group: System/Servers
Requires: %name = %version-%release
Requires: lightmediascanner

%description lms
A plugin for rygel to use LMS to locate media on the local machine.

%package gir
Summary: GObject introspection data for the %name
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the %name

%package gir-devel
Summary: GObject introspection devel data for the %name
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the %name

%prep
%setup
echo %version > .tarball-version

%build
# gettext 0.19.7 required
#gettextize -q -f
%autoreconf
%configure \
	%{subst_enable vala} \
	%{subst_with ui} \
	%{?_enable_tracker_plugin:--enable-tracker-plugin} \
	%{?_enable_media_export_plugin:--enable-media-export-plugin} \
	%{?_enable_external_plugin:--enable-external-plugin} \
	%{?_enable_mpris_plugin:--enable-mpris-plugin} \
	%{subst_enable playbin_plugin} \
	%{?_enable_gst_launch_plugin:--enable-gst-launch-plugin} \
	%{?_enable_lms_plugin:--enable-lms-plugin}
%make_build

%install
%makeinstall_std

%find_lang --with-gnome %name

%files -f %name.lang
%config(noreplace) %_sysconfdir/%name.conf
%_bindir/%name
%_bindir/%name-preferences
%_libexecdir/%name/
%_libdir/lib%name-*.so.*
%_libdir/%name-*/

%exclude %_libdir/%name-*/plugins/lib%name-tracker.so
%exclude %_libdir/%name-*/plugins/tracker.plugin

%if_enabled lms_plugin
%exclude %_libdir/%name-*/plugins/librygel-lms.so
%exclude %_libdir/%name-*/plugins/lms.plugin
%endif

%_datadir/%name
%_desktopdir/*
%_iconsdir/hicolor/*/apps/*
%_prefix/lib/systemd/user/%name.service
%_datadir/dbus-1/services/*.service
%_man1dir/*
%_man5dir/*
%exclude %_libdir/%name-*/*/*.la
%doc AUTHORS TODO NEWS

%files tracker
%_libdir/%name-*/plugins/librygel-tracker.so
%_libdir/%name-*/plugins/tracker.plugin

%if_enabled lms_plugin
%files lms
%_libdir/%name-*/plugins/librygel-lms.so
%_libdir/%name-*/plugins/lms.plugin
%endif

%files devel
%_libdir/lib%name-*.so
%_includedir/%name-*
%_pkgconfigdir/*.pc
%_datadir/vala/vapi/*

%files devel-doc
%_datadir/gtk-doc/html/lib%name-*/

%files gir
%_typelibdir/*.typelib

%files gir-devel
%_girdir/*.gir

%changelog
