%set_verify_elf_method unresolved=relaxed
%define hdf5_version 1.8.9
# TODO problem with package freehep-util
%def_without freehep
%def_without docs

Name:     scilab
Version:  6.0.2
Release:  alt1
Summary:  A high-level language and system for numerical computations

License:  CeCILL
Group:    Sciences/Mathematics

Packager: Andrey Cherepanov <cas@altlinux.org>

Obsoletes: %name-doc
Obsoletes: scirenderer

Source0: %name-%version.tar
# VCS:   git://git.scilab.org/scilab
Source1: scilab-desktop-ru.tar
Source2: help.tar

Patch1:  scilab-find-jhall.patch
Patch2:  scilab-find-jgoodies-looks.patch
Patch3:  scilab-find-xml-apis-ext.patch
Patch4:	 scilab-fix-make-doc-ja_JP.patch
Patch5:  scilab-6.0.0-jogl-2.3.patch
Patch8:  scilab-5.5.2-disable-doclint.patch
Patch9:  scilab-alt-cxx-flags.patch
Patch10: scilab-alt-gcc8-fix.patch

URL: http://www.scilab.org
AutoReq: yes, noshell

# See https://bugzilla.redhat.com/show_bug.cgi?id=993239
ExcludeArch:   %{arm} aarch64

BuildRequires(pre): rpm-build-java
BuildRequires(pre): rpm-build-xdg
BuildRequires: java-devel
BuildRequires: gcc-fortran
BuildRequires: gcc-c++
BuildRequires: libxml2-devel

# Numerical libraries
# see "http://wiki.scilab.org/Linalg performances"
BuildRequires: liblapack-devel
BuildRequires: libarpack-ng-devel

# GUI/Console
BuildRequires: jpackage-utils
BuildRequires: /proc
BuildRequires: ant

BuildRequires: flexdock >= 1.0
BuildRequires: gluegen2
BuildRequires: jogl2 >= 2.3
BuildRequires: libGL-devel
BuildRequires: jrosetta >= 1.0.4

BuildRequires: apache-commons-logging
BuildRequires: javahelp2
BuildRequires: jlatexmath >= 1.0.2
BuildRequires: jlatexmath-fop >= 1.0.2
BuildRequires: jgraphx
BuildRequires: lucene
BuildRequires: lucene-analysis
BuildRequires: lucene-queryparser
BuildRequires: fop
BuildRequires: jeuclid
BuildRequires: batik
BuildRequires: xmlgraphics-commons
BuildRequires: ecj
%if_with freehep
BuildRequires: freehep-graphics2d
BuildRequires: freehep-util
%endif
BuildRequires: objectweb-asm3

Requires:      java-1.8.0-openjdk
Requires:      lucene lucene-analysis lucene-queryparser

# TCL/TK features
BuildRequires: tcl-devel
BuildRequires: tk-devel

Requires:      tcl
Requires:      tk

# Modelica
BuildRequires: ocaml

# Documentation
BuildRequires: saxon
BuildRequires: docbook-style-xsl

# All optional dependencies are needed to provide a full-featured Scilab
BuildRequires: gettext-devel
BuildRequires: libfftw3-devel
BuildRequires: libmatio-devel
BuildRequires: libsuitesparse-devel
BuildRequires: libhdf5-devel
#?BuildRequires: jhdf5
BuildRequires: xml-commons-jaxp-1.3-apis
BuildRequires: checkstyle

BuildRequires: libncurses-devel
BuildRequires: libgomp-devel
BuildRequires: libatlas-devel
BuildRequires: libpcre-devel
BuildRequires: libcurl-devel
BuildRequires: eigen3

# For generated documentation
BuildRequires: fonts-ttf-liberation

# Other
BuildRequires: empty

Requires: jogl2 >= 2.3
Requires: ecj
Requires: flexdock jrosetta
Requires: saxon
Requires: apache-commons-logging
Requires: javahelp2
Requires: jlatexmath >= 1.0.2
Requires: jlatexmath-fop >= 1.0.2
Requires: jgraphx
Requires: fop
Requires: jeuclid
Requires: batik
Requires: xmlgraphics-commons
Requires: xml-commons-jaxp-1.3-apis
Requires: libfftw3
%if_with freehep
Requires: freehep-graphics2d
Requires: freehep-util
%endif
Requires: empty

#Requires: jgoodies-looks skinlf ant-commons-logging avalon-framework
#Requires: docbook-style-xsl saxon

%description
Scilab is the free software for numerical computation providing a
powerful computing environment for engineering and scientific
applications. It includes hundreds of mathematical functions. It has a
high level programming language allowing access to advanced data
structures, 2-D and 3-D graphical functions.

%prep
%setup -q
cd scilab
tar xf %SOURCE1
%patch1 -p2
%patch2 -p2
%patch3 -p2
%patch4 -p1
%patch5 -p1
%patch8 -p2
%patch9 -p2
%patch10 -p2

# Update saxon dependency
# http://bugzilla.scilab.org/show_bug.cgi?id=8479
sed -i "s/com.icl.saxon.Loader/net.sf.saxon.Version/g" m4/docbook.m4 configure

# Fix Class-Path in manifest
sed -i '/name="Class-Path"/d' build.incl.xml

# Fix file-not-utf8
iconv -f ISO_8859-1 -t UTF-8 COPYING >COPYING.utf8
mv COPYING.utf8 COPYING

%build
cd scilab
#%%define _configure_target %{_arch}-pc-linux-gnu
%undefine _configure_gettext
export LDFLAGS="$LDFLAGS -Wl,--no-as-needed"
aclocal
%configure --enable-shared \
           --enable-static=no \
           --with-tk \
           --with-gfortran \
           --with-hdf5-include=%_libdir/hdf5-seq/include/ \
           --with-tcl-library=%_libdir \
           --with-tk-library=%_libdir \
           --with-pic \
%if_without freehep
	   --without-emf \
%endif
           --without-modelica \
	   --disable-static-system-lib \
           --enable-build-help

%make
%if_with docs
%make doc SCIVERBOSE=1
%endif

%install
cd scilab
%makeinstall_std
%find_lang %name

# Remove more advanced repl, user should use CLI options instead
rm -fr %buildroot%_desktopdir/%{name}-*.desktop
# Remove la files
rm -fr %buildroot%_libdir/%name/*.la

%if_without docs
tar xf %SOURCE2 -C %buildroot%_datadir/scilab/modules/helptools/jar/
%endif

%files -f scilab/%name.lang
%doc scilab/README.md scilab/ACKNOWLEDGEMENTS scilab/CHANGES.md scilab/COPYING scilab/COPYING-BSD
%_bindir/*
%_libdir/pkgconfig/*
%_libdir/%name
%_includedir/%name
%_datadir/%name
%_desktopdir/*.desktop
%_iconsdir/*/*/*/*.png
%_datadir/appdata/scilab.appdata.xml
%_datadir/mime/packages/scilab.xml

%changelog
