Name: sdcc
Epoch: 1
Version: 3.6.0
Release: alt1
Group: Development/C
URL: http://sdcc.sourceforge.net
License: GPL
Summary: Small Device C Compiler
Source: %name-%version.tar

BuildRequires: flex gcc-c++ boost-devel gputils /usr/bin/makeinfo

Requires: %name-common = %EVR

%description
SDCC is a free open source, retargettable, optimizing ANSI C compiler
suite that targets a growing list of processors including the Intel
MCS51 based microprocessors (8031, 8032, 8051, 8052, etc.), Maxim
(formerly Dallas) DS80C390 variants, Freescale (formerly Motorola)
HC08 based (hc08, s08) and Zilog Z80 based MCUs (z80, z180, gbz80,
Rabbit 2000/3000, Rabbit 3000A). Work is in progress on supporting
the Microchip PIC16 and PIC18 targets. It can be retargeted for other
microprocessors.

%package common
License: GPL, LGPL
Group:         Development/C
Summary:       Libraries and Header Files for the SDCC C compiler
%description common
SDCC is a free open source, retargettable, optimizing ANSI C compiler
suite that targets a growing list of processors including the Intel
MCS51 based microprocessors (8031, 8032, 8051, 8052, etc.), Maxim
(formerly Dallas) DS80C390 variants, Freescale (formerly Motorola)
HC08 based (hc08, s08) and Zilog Z80 based MCUs (z80, z180, gbz80,
Rabbit 2000/3000, Rabbit 3000A). Work is in progress on supporting
the Microchip PIC16 and PIC18 targets. It can be retargeted for other
microprocessors.

%package doc
License:       GPL
Group:         Development/C
Summary:       Documentation for the SDCC C compiler
BuildArch:	noarch
%description doc
SDCC is a free open source, retargettable, optimizing ANSI C compiler
suite that targets a growing list of processors including the Intel
MCS51 based microprocessors (8031, 8032, 8051, 8052, etc.), Maxim
(formerly Dallas) DS80C390 variants, Freescale (formerly Motorola)
HC08 based (hc08, s08) and Zilog Z80 based MCUs (z80, z180, gbz80,
Rabbit 2000/3000, Rabbit 3000A). Work is in progress on supporting
the Microchip PIC16 and PIC18 targets. It can be retargeted for other
microprocessors.

%prep
%setup -q -n %name-%version

%build
%configure --docdir=%_docdir/%name-%version \
	--enable-werror=no
%make_build

%install
%make_install DESTDIR=%buildroot install
#rm -fr /usr/src/tmp/sdcc-buildroot/usr/share/sdcc/lib/src

%files 
%_bindir/*

%files common
%_datadir/%name/*

%files doc
%_docdir/%name-%version/*

# The package does not own its own docdir subdirectory.
# The line below is added by repocop to fix this bug in a straightforward way. 
# Another way is to rewrite the spec to use relative doc paths.
%dir %_docdir/%name-%version 

%changelog
