%def_disable snapshot
%define _unpackaged_files_terminate_build 1
%define _libexecdir %_prefix/libexec
%define ver_major 3.34
%define xdg_name org.gnome.seahorse

%def_disable debug
%def_enable ldap
%def_enable hkp
%def_enable gnome_keyring
%def_enable pkcs11
%def_enable ssh
%def_enable introspection
%def_enable man

%if_enabled hkp
%def_enable sharing
%endif

Name: seahorse
Version: %ver_major
Release: alt1

Summary: A password and encryption key manager
License: %gpllgpl2plus
Group: Graphical desktop/GNOME
Url: https://wiki.gnome.org/Apps/Seahorse

%if_disabled snapshot
Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

Requires: dconf
Requires: gnupg2 gcr
Requires: pinentry-x11
%{?_enable_ssh:Requires: openssh-clients}
%{?_enable_sharing:Requires: avahi-daemon}

BuildRequires(pre): meson rpm-build-gnome rpm-build-licenses
BuildRequires: yelp-tools libappstream-glib-devel
BuildRequires: gtk-doc desktop-file-utils
BuildRequires: gcc-c++ libgtk+3-devel >= 3.22.0
BuildRequires: gnupg2
BuildRequires: libgpgme-devel >= 1.0.0
BuildRequires: libgpg-error-devel
BuildRequires: vala-tools
BuildRequires: pkgconfig(pwquality)
%{?_enable_ldap:BuildRequires: libldap-devel}
%{?_enable_hkp:BuildRequires: libsoup-devel >= 2.4}
%{?_enable_gnome_keyring:BuildRequires: libsecret-devel >= 0.16}
%{?_enable_pkcs11:BuildRequires: gcr-libs-devel >= 3.11.91 gcr-libs-vala}
%{?_enable_sharing:BuildRequires: libavahi-glib-devel >= 0.6 libavahi-devel }
%{?_enable_ssh:BuildRequires: openssh openssh-clients}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel libgtk+3-gir-devel}
%{?_enable_man:BuildRequires: xsltproc docbook-dtds docbook-style-xsl}

%description
Seahorse is a password and encryption key manager for GNOME desktop.

%prep
%setup

%build
%meson \
%{?_disable_ldap:-Dldap-support=false} \
%{?_disable_pkcs11:-Dpkcs11-support=false} \
%{?_disable_hkp:-Dhkp-support=false} \
%{?_disable_sharing:-Dkey-sharing=false} \
%{?_enable_man:-Dmanpage=true}
%nil
%meson_build

%install
%meson_install
%find_lang %name --with-gnome

%files -f %name.lang
%_bindir/%name
%dir %_libexecdir/%name
%_libexecdir/%name/ssh-askpass
%_libexecdir/%name/xloadimage
%dir %_datadir/%name
%_datadir/%name/*
%_iconsdir/hicolor/*/*/*.*
%_desktopdir/*.desktop
%{?_enable_man:%_man1dir/*}
%_datadir/dbus-1/services/org.gnome.seahorse.Application.service
%_datadir/gnome-shell/search-providers/seahorse-search-provider.ini
%config %_datadir/glib-2.0/schemas/org.gnome.seahorse.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.seahorse.manager.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.seahorse.window.gschema.xml
%_datadir/metainfo/%{xdg_name}*.appdata.xml
%doc AUTHORS NEWS README* THANKS

%changelog
