Group: Games/Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           seahorse-adventures
Version:        1.1
Release:        alt1_1
Summary:        Help barbie the seahorse float on bubbles to the moon
License:        GPL+
URL:            http://www.imitationpickles.org/barbie/
Source0:        http://www.imitationpickles.org/barbie/files/barbie-%{version}.tgz
Source1:        %{name}.desktop
Source2:        %{name}.appdata.xml
Patch0:         seahorse-adventures-1.0-symlink.patch
Patch1:         seahorse-adventures-1.0-build.patch
BuildRequires:  desktop-file-utils libappstream-glib
BuildArch:      noarch
Requires:       icon-theme-hicolor python-module-pygame fonts-ttf-dejavu
Source44: import.info

%description
Help barbie the seahorse float on bubbles to the moon. This is a retro-side
scroller game. It won the teams category in pyweek 4. Includes original
soundtrack, graphics, and 15 levels!


%prep
%setup -q -n barbie-%{version}
%patch0 -p1
%patch1 -p1
sed -i 's:/usr/bin/python:/usr/bin/python2:' leveledit.py tileedit.py
sed -i 's:/usr/bin/env python:/usr/bin/python2:' run_game.py
rm data/themes/*/Vera.ttf


%build
# nothing to build, pure python code only


%install
mkdir -p $RPM_BUILD_ROOT%{_bindir}
mkdir -p $RPM_BUILD_ROOT%{_datadir}/%{name}
cp -a data lib leveledit.py run_game.py tileedit.py \
  $RPM_BUILD_ROOT%{_datadir}/%{name}
ln -s ../../../../fonts/ttf/dejavu/DejaVuSans.ttf \
  $RPM_BUILD_ROOT%{_datadir}/%{name}/data/themes/default/Vera.ttf
ln -s ../../../../fonts/ttf/dejavu/DejaVuSans.ttf \
  $RPM_BUILD_ROOT%{_datadir}/%{name}/data/themes/gray/Vera.ttf

chmod +x $RPM_BUILD_ROOT%{_datadir}/%{name}/run_game.py
ln -s ../share/%{name}/run_game.py $RPM_BUILD_ROOT%{_bindir}/%{name}

# below is the desktop file and icon stuff.
mkdir -p $RPM_BUILD_ROOT%{_datadir}/applications
desktop-file-install --dir $RPM_BUILD_ROOT%{_datadir}/applications %{SOURCE1}
mkdir -p $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/32x32/apps
mkdir -p $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/64x64/apps
mkdir -p $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/128x128/apps
install -p -m 644 icon32.png \
  $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/32x32/apps/%{name}.png
install -p -m 644 icon64.png \
  $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/64x64/apps/%{name}.png
install -p -m 644 icon128.png \
  $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/128x128/apps/%{name}.png
mkdir -p $RPM_BUILD_ROOT%{_datadir}/appdata
install -p -m 644 %{SOURCE2} $RPM_BUILD_ROOT%{_datadir}/appdata
appstream-util validate-relax --nonet \
  $RPM_BUILD_ROOT%{_datadir}/appdata/%{name}.appdata.xml


%files
%doc CHANGES.txt LEVELS.txt NOTES.txt README.txt TODO.txt
%doc --no-dereference LICENSE.txt
%{_bindir}/%{name}
%{_datadir}/%{name}
%{_datadir}/appdata/%{name}.appdata.xml
%{_datadir}/applications/%{name}.desktop
%{_datadir}/icons/hicolor/*/apps/%{name}.png


%changelog
