Name: service
Version: 0.5.31
Release: alt1

Summary: The service start/stop scripts
License: GPLv2+
Group: System/Base
Url: http://git.altlinux.org/people/ldv/packages/service.git

Source: %name-%version.tar
Source1: list.functions-compat

Requires: /bin/tput
# due to start-stop-daemon (Conflicts: SysVinit < 0:2.85-alt5)
Requires: sysvinit-utils
Conflicts: initscripts < 1:5.49.1-alt1
# due to RPM_INSTALL_ARG1 support:
Conflicts: rpm < 0:4.0.4-alt0.7
# due to %_sysconfdir/rc?.d and %_sysconfdir/rc.d/rc?.d
Conflicts: startup < 0.0.2-alt1
# due to run-parts
Conflicts: crontabs < 0:1.8-alt1
# due to start-stop-daemon.8
Conflicts: dpkg <= 0:1.6.15-alt3

%global __find_provides_filter fgrep -x -v -e "$(/usr/lib/rpm/shell.prov %buildroot%_initdir/.provides.sh.compat)"

# This is required for shell function provides autogeneration.
BuildPreReq: rpm-build >= 4.0.4-alt16

BuildRequires: help2man, libpopt-devel, libshell

%description
This package contains the basic system scripts used to
start and stop services.

%prep
%setup

%build
make -C src VERSION=%version

%install
%makeinstall_std -C src
install -p -m755 service %buildroot/sbin/
install -p -m644 service.8 %buildroot%_man8dir/
mkdir -p %buildroot{/bin,%_sbindir}
install -p -m755 run-parts %buildroot/bin/
install -p -m755 post_service preun_service %buildroot%_sbindir/
install -p -m755 rc.d/init.d/* %buildroot%_initdir/
chmod a-x %buildroot%_initdir/template

# This is a LSB compatibility symlink.  We hope that some day
# the actual files will be here instead of symlinks.
ln -s rc.d/init.d %buildroot%_sysconfdir/

# This is a LSB compatibility symlink.  We hope that some day
# the actual files will be here instead of symlinks.
for i in `seq 0 6`; do
        ln -s rc.d/rc$i.d %buildroot%_sysconfdir/rc$i.d
done

mkdir -p %buildroot%_sysconfdir/rc.d/rc{0,1,2,3,4,5,6}.d
mkdir -p %buildroot%_sysconfdir/sysconfig/limits.d
mkdir -p %buildroot/usr/libexec/service/legacy-actions

# Generate shell functions provides list.
export LC_COLLATE=C

print_function_names()
{
        sed -ne 's/^\([A-Za-z][A-Za-z_0-9]*[[:space:]]*\)()$/\1/pg' "$1"
}

for f in %buildroot%_initdir/*; do
        [ -x "$f" ] || continue
        print_function_names "$f"
done | sort -u \
>%buildroot%_initdir/.list.functions

(
        echo '# shell functions provides list'
        comm -1 -3 \
        %buildroot%_initdir/.list.functions \
        %SOURCE1
) >%buildroot%_initdir/.provides.sh.compat

(
        echo '# shell functions provides list'
        sort -u \
        %buildroot%_initdir/.list.functions \
        %SOURCE1
) >%buildroot%_initdir/.provides.sh
# In other pkgs, Requires will be generated for all functions listed here.

%triggerpostun -- initscripts < 1:5.49.1-alt1
f=%_sysconfdir/initlog.conf
if [ ! -f "$f" ]; then
        if [ -f "$f".rpmsave ]; then
                cp -pf "$f".rpmsave "$f"
        elif [ -f "$f".rpmnew ]; then
                cp -pf "$f".rpmnew "$f"
        fi
fi

%files
%exclude %_initdir/.provides.sh.compat
/sbin/*
/bin/*
%_sbindir/*
%_mandir/man?/*
%_sysconfdir/init.d
%_sysconfdir/rc?.d
%defattr(644,root,root,755)
%_sysconfdir/sysconfig/limits.d
/usr/libexec/service/
%config %_sysconfdir/rc.d
%config(noreplace) %_sysconfdir/initlog.conf
%config(noreplace) %_sysconfdir/sysconfig/limits

%changelog
