%define oname shiboken
Name: %oname-py3
Version: 1.2.2
Release: alt4.git20140422
Summary: Generates bindings for C++ libraries using CPython source code (Python 3)
License: GPLv2, LGPLv2.1
Group: Development/KDE and QT
Url: http://www.pyside.org/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: %name-%version.tar
Patch1: %name-%version-alt-gcc6.patch

# Updated build system %%__*python3* macros are in 0.1.9.2.
BuildRequires(pre): rpm-build-python3 >= 0.1.9.2
BuildPreReq: python3-devel
BuildPreReq: cmake libqt4-devel gcc-c++ libgeneratorrunner-devel
BuildPreReq: phonon-devel generatorrunner qt4-designer xml-utils
BuildPreReq: python3-module-sphinx-devel xsltproc python3-devel
BuildPreReq: libxml2-devel libxslt-devel libqt4-assistant-devel
BuildPreReq: python3-module-distribute

Requires: lib%name = %version-%release
Conflicts: %oname

%description
Shiboken is a plugin (front-end) for Generator Runner. It generates
bindings for C++ libraries using CPython source code.

%package -n lib%name
Summary: Shared libraries of Shiboken (Python 3)
Group: System/Libraries

%description -n lib%name
Shiboken is a plugin (front-end) for Generator Runner. It generates
bindings for C++ libraries using CPython source code.

This package contains shared libraries of Shiboken.

%package -n lib%name-devel
Summary: Development files of Shiboken (Python 3)
Group: Development/C++
Requires: lib%name = %version-%release
Conflicts: lib%oname-devel

%description -n lib%name-devel
Shiboken is a plugin (front-end) for Generator Runner. It generates
bindings for C++ libraries using CPython source code.

This package contains development files of Shiboken.

%package -n python3-module-%oname
Summary: Python module of Shiboken (Python 3)
Group: Development/Python3
Requires: lib%name = %version-%release

%description -n python3-module-%oname
Shiboken is a plugin (front-end) for Generator Runner. It generates
bindings for C++ libraries using CPython source code.

This package contains python module of Shiboken.

%prep
%setup
%patch1 -p1

sed -i 's|sphinx\-build|py3_sphinx-build|g' \
	ApiExtractor/doc/CMakeLists.txt doc/CMakeLists.txt

%prepare_sphinx3 .
ln -s ../objects.inv doc

%build
export PATH=$PATH:%_qt4dir/bin
FLAGS="$(pkg-config phonon --cflags)"
%add_optflags $FLAGS

mkdir BUILD
pushd BUILD

cmake \
	-DCMAKE_INSTALL_PREFIX:PATH=%prefix \
%if "%_lib" == "lib64"
	-DLIB_SUFFIX:STRING=64 \
%endif
	-DCMAKE_STRIP:FILEPATH="/bin/echo" \
	-DENABLE_GCC_OPTIMIZATION:BOOL=ON \
	-DENABLE_VERSION_SUFFIX:BOOL=OFF \
	-DCMAKE_C_FLAGS:STRING="%optflags" \
	-DCMAKE_CXX_FLAGS:STRING="%optflags" \
	-DQT_PHONON_INCLUDE_DIR:PATH="%_includedir/kde4" \
	-DUSE_PYTHON3:BOOL=ON \
	-DPYTHON3_INCLUDE_DIR=%__python3_includedir \
	-DPYTHON3_LIBRARY=%__libpython3 \
	..

%make_build VERBOSE=1

pushd doc
%make doc
popd

popd

%install
%makeinstall_std -C BUILD

%files
%doc COPYING* AUTHORS
%doc BUILD/doc/html
%_bindir/*
%_man1dir/*

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_libdir/cmake
%_pkgconfigdir/*

%files -n python3-module-%oname
%python3_sitelibdir/*

%changelog
