# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

%define _vstring %(echo %{version} |tr -d ".")

Name: shotcut
Version: 20.09.27
Release: alt1
Summary: A free, open source, cross-platform video editor
Summary(ru_RU.UTF-8): Свободный кросс-платфоорменный видеоредактор
License: GPL-3.0+
Group: Video
Url: http://www.shotcut.org/
Packager: Anton Midyukov <antohami@altlinux.org>

ExcludeArch: armh

Source: %name-%version.tar
# Melt patch /usr/bin/melt
Patch: mlt_path.patch

BuildRequires: gcc-c++
BuildRequires: desktop-file-utils
BuildRequires: libappstream-glib
BuildRequires: pkgconfig(Qt5Concurrent)
BuildRequires: pkgconfig(Qt5Core) >= 5.9.1
BuildRequires: pkgconfig(Qt5Gui)
BuildRequires: pkgconfig(Qt5Multimedia)
BuildRequires: pkgconfig(Qt5Network)
BuildRequires: pkgconfig(Qt5OpenGL)
BuildRequires: pkgconfig(Qt5PrintSupport)
BuildRequires: pkgconfig(Qt5Quick)
BuildRequires: pkgconfig(Qt5WebKitWidgets)
BuildRequires: pkgconfig(Qt5WebSockets)
BuildRequires: pkgconfig(Qt5X11Extras)
BuildRequires: pkgconfig(Qt5Xml)
BuildRequires: qt5-linguist
BuildRequires: pkgconfig(mlt++)
BuildRequires: pkgconfig(mlt-framework)
BuildRequires: libx264-devel
BuildRequires: pkgconfig(sdl2)
BuildRequires: ImageMagick-tools

Requires: %name-data = %version
Requires: mlt-utils
Requires: gst-plugins-bad1.0
Requires: frei0r-plugins
Requires: ladspa_sdk
Requires: lame
Requires: ffmpeg ffprobe ffplay
Requires: libSDL2
# see bug 34876
Requires: qt5-quickcontrols
# see bug 34877
Requires: qt5-graphicaleffects

%description
These are all currently implemented features:
 * supports oodles of audio and video formats and codecs;
 * supports many image formats as image sequences;
 * no import required - native editing;
 * frame-accurate seeking for many formats;
 * multi-format timeline;
 * screen capture (Linux only) including background capture;
 * webcam capture (Linux only);
 * audio capture (Linux only; PulseAudio, JACK, or ALSA);
 * network stream playback (HTTP, HLS, RTMP, RTSP, MMS, UDP);
 * frei0r video generator plugins (e.g. color bars and plasma);
 * Blackmagic Design SDI and HDMI for input and preview monitoring;
 * JACK transport sync;
 * deinterlacing;
 * detailed media properties panel;
 * recent files panel with search;
 * drag-n-drop files from file manager;
 * save and load trimmed clip as MLT XML file;
 * load and play complex MLT XML file as a clip;
 * audio signal level meter;
 * volume control;
 * scrubbing and transport control;
 * flexible UI through dock-able panels;
 * encode/transcode to a variety of formats and codecs;
 * capture (record);
 * stream (encode to IP) files and any capture source;
 * batch encoding with job control;
 * MLT XML playlists;
 * unlimited undo and redo for playlist edits;
 * connect to Melted servers over MVCP TCP protocol;
 * control the transport playback of Melted units;
 * edit Melted playlists including support for undo/redo;
 * OpenGL GPU-based image processing;
 * multi-core parallel image processing when not using GPU;
 * video filters;
 * audio filters;
 * 3-way color wheels for color correction and grading;
 * eye dropper tool to pick neutral color for white balancing;
 * HTML5 (sans audio and video) as video source and filters;
 * Leap Motion for jog/shuttle control;
 * DeckLink SDI keyer output - internal or external;
 * UI themes/skins: native-OS look and custom dark and light;
 * control video zoom in the player.

%package data
Summary: Data files for %name
Group: Video
BuildArch: noarch

%description data
Data files for %name

%prep
%setup
%patch -p0

# Create version.json from current version
echo "{" > version.json
echo " \"version_number\": %{_vstring}02," >> version.json
echo " \"version_string\": \"%{version}.02\"," >> version.json
echo " \"url\": \"https://shotcut.org/blog/new-release-%{_vstring}/\"" >> version.json
echo "}" >> version.json
echo "" >> version.json

# Postmortem debugging tools for MinGW.
rm -rf drmingw

%build
lrelease-qt5 translations/*.ts
export _VSTRING="%{version}.02"
%qmake_qt5 \
    QMAKE_CXXFLAGS=-DSHOTCUT_NOUPGRADE \
    _VSTRING="%{version}.02" \
    PREFIX=%buildroot%_prefix

%make_build

%install
%makeinstall_std
chmod a+x %buildroot/%_datadir/shotcut/qml/export-edl/rebuild.sh

for i in 16 32 48; do
    mkdir -p %buildroot/%_iconsdir/hicolor/"$i"x"$i"/apps
    convert icons/%name-logo-64.png -resize "$i"x"$i" \
    %buildroot/%_iconsdir/hicolor/"$i"x"$i"/apps/org.shotcut.Shotcut.png
done

%files
%_bindir/%name
%_desktopdir/org.shotcut.Shotcut.desktop
%doc COPYING README.md
%_iconsdir/hicolor/*/apps/org.shotcut.Shotcut.png
%_datadir/metainfo/org.shotcut.Shotcut.appdata.xml
%_datadir/mime/packages/org.shotcut.Shotcut.xml
%_man1dir/*

%files data
%_datadir/%name

%changelog
