Name: smem
Version: 1.5
Release: alt1

Summary: Report application memory usage in a meaningful way

License: GPLv2+
Group: Monitoring
Url: http://www.selenic.com/smem

# version 1.5 created from tag 1.5 at
# https://selenic.com/repo/smem/rev/1.5
Source0: http://www.selenic.com/smem/download/%name-%version.tar
Source1: http://www.selenic.com/smem/index.html

Packager: Michael Shigorin <mike@altlinux.org>

Conflicts: secure_delete

%description
smem is a tool that can give numerous reports on memory usage
on Linux systems. Unlike existing tools, smem can report
proportional set size (PSS), which is a more meaningful
representation of the amount of memory used by libraries
and applications in a virtual memory system.

Since large portions of physical memory are typically shared
among multiple applications, the standard measure of memory usage
known as resident set size (RSS) will significantly overestimate
memory usage.  PSS measures each application's "fair share" of
each shared area instead to give more realistic sense of what's
happening.

Requires: kernel >= 2.6.27

%prep
%setup
cp -a %SOURCE1 smem.html

%build
make smemcap CFLAGS="%optflags"

%install
install -pDm755 smem %buildroot%_bindir/%name
install -pDm755 smemcap %buildroot%_bindir/smemcap
install -pDm644 smem.8 %buildroot%_man8dir/smem.8

%files
%_bindir/*
%_man8dir/*
%doc smem.html COPYING

%changelog
