%define _unpackaged_files_terminate_build 1

%define ver_major 3.24
%define gst_api_ver 1.0
%define xdg_name org.gnome.SoundJuicer

Name: sound-juicer
Version: %ver_major.0
Release: alt1

Summary: Clean and lean CD ripper
Group: Sound
License: GPLv2+
Url: https://wiki.gnome.org/Apps/SoundJuicer

Requires: gst-plugins-base%gst_api_ver gst-plugins-good%gst_api_ver
Requires: iso-codes

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

BuildPreReq: gcc-c++ gnome-common
BuildRequires: yelp-tools desktop-file-utils libappstream-glib-devel
BuildRequires: libgio-devel >= 2.32
BuildRequires: libbrasero-devel >= 3.0.0
BuildRequires: libgtk+3-devel >= 3.22.0
BuildRequires: gsettings-desktop-schemas-devel
BuildRequires: libcanberra-devel libcanberra-gtk3-devel
BuildRequires: gstreamer%gst_api_ver-devel gst-plugins%gst_api_ver-devel
BuildRequires: gst-plugins-base%gst_api_ver gst-plugins-good%gst_api_ver gstreamer%gst_api_ver-utils
BuildRequires: libmusicbrainz5-devel >= 5.1.0 libdiscid-devel >= 0.4.0 iso-codes-devel

%description
GStreamer-based CD ripping tool. Saves audio CDs to audio formats,
supported by GStreamer.

%prep
%setup

%build
%configure \
	--disable-schemas-compile
%make_build

%install
%makeinstall_std

%find_lang --with-gnome %name

desktop-file-install --dir %buildroot%_desktopdir \
	--add-category=DiscBurning \
	--add-category=GTK \
	%buildroot%_desktopdir/%xdg_name.desktop

%files -f %name.lang
%_bindir/%name
%_datadir/%name/
%_datadir/applications/%xdg_name.desktop
%_datadir/icons/*/*/*/*
%_datadir/GConf/gsettings/%name.convert
%_datadir/glib-2.0/schemas/org.gnome.%name.gschema.xml
%_datadir/dbus-1/services/%xdg_name.service
%_man1dir/%name.1.*
%_datadir/appdata/%xdg_name.appdata.xml
%doc AUTHORS README NEWS

%changelog
