%define build_type RelWithDebInfo
%define _cmake %cmake -DCMAKE_BUILD_TYPE=%build_type -DCMAKE_VERBOSE_MAKEFILE:BOOL=ON -DCMAKE_INSTALL_LIBDIR=%_datadir
%define git 814e728

Name: spirv-headers
Version: 1.5.5
Release: alt1.g%{git}
Epoch: 1

Summary: machine-readable files for the SPIR-V Registry
Group: Development/C++
License: BSD

BuildArch: noarch

URL: https://github.com/KhronosGroup/SPIRV-Headers
Packager: L.A. Kostis <lakostis@altlinux.org>

Source: %name-%version.tar

BuildRequires(pre): cmake
BuildRequires: gcc-c++

%description
This repository contains machine-readable files for the SPIR-V Registry. This includes:

* Header files for various languages.
* JSON files describing the grammar for the SPIR-V core instruction set and the extended instruction sets.
* The XML registry file.
* A tool to build the headers from the JSON grammar.

%prep
%setup -n %name-%version

%build
%_cmake
%cmake_build
%cmakeinstall_std

%files
%doc *.md example
%dir %_includedir/spirv
%dir %_datadir/cmake/SPIRV-Headers
%_includedir/spirv/*
%_datadir/cmake/SPIRV-Headers/*
%_datadir/pkgconfig/*.pc

%changelog
