%global optflags_lto %nil
%define _unpackaged_files_terminate_build 1
%define libwbc_alternatives_version 0.15.0
%def_with kcm
%def_with check
%def_with samba
%def_without gdm_pam_extensions
%def_disable systemtap

Name: sssd
Version: 2.6.1
Release: alt2
Group: System/Servers
Summary: System Security Services Daemon
License: GPLv3+
Url: https://pagure.io/SSSD/sssd
Source: %name-%version.tar
Source2: %name.init
Source3: system-auth-sss.pam
Source4: system-auth-use_first_pass-sss.pam
Source5: system-auth-sss-only.pam
Source6: system-auth-use_first_pass-sss-only.pam
Source7: sssd-example.conf
Source8: sssd-default.conf

Patch: %name-%version-alt.patch

# Determine the location of the LDB modules directory
%define ldb_modulesdir %(pkg-config --variable=modulesdir ldb)
%define ldb_modversion %(pkg-config --modversion ldb)

%define nfsidmapdir %_libdir/libnfsidmap

%define _localstatedir /var
%define _libexecdir /usr/libexec
%define _pamdir %_sysconfdir/pam.d

%define sssdstatedir %_localstatedir/lib/sss
%define dbpath %sssdstatedir/db
%define keytabdir %sssdstatedir/keytabs
%define pipepath %sssdstatedir/pipes
%define mcpath %sssdstatedir/mc
%define pubconfpath %sssdstatedir/pubconf
%define gpocachepath %sssdstatedir/gpo_cache
%define deskprofilepath %sssdstatedir/deskprofile
%define dotcachepath %sssdstatedir/.cache

%define sssd_user _sssd

Requires: %name-client = %version-%release
Requires: libsss_idmap = %version-%release
Requires: libldb = %ldb_modversion

Requires: libkrb5 >= 1.14.4-alt2

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): libldb-devel

### Build Dependencies ###
BuildRequires: libpopt-devel
BuildRequires: libtalloc-devel
BuildRequires: libtevent-devel
BuildRequires: libtdb-devel >= 1.1.3
BuildRequires: libldb-devel >= 1.3.3
BuildRequires: libdhash-devel >= 0.4.2
BuildRequires: libcollection-devel >= 0.5.1
BuildRequires: libini_config-devel >= 1.3.0
BuildRequires: libdbus-devel
BuildRequires: libldap-devel
BuildRequires: libpam-devel
BuildRequires: libnss-devel
BuildRequires: libnspr-devel
#BuildRequires: libssl-devel
BuildRequires: libpcre2-devel
BuildRequires: libxslt
BuildRequires: libxml2-devel
BuildRequires: docbook-dtds docbook-style-xsl xsltproc xml-utils
BuildRequires: libkrb5-devel
BuildRequires: libcares-devel
BuildRequires: python3-devel
BuildRequires: libcheck-devel
BuildRequires: doxygen
BuildRequires: libselinux-devel
BuildRequires: libsemanage-devel
BuildRequires: bind-utils
BuildRequires: libkeyutils-devel
BuildRequires: libnl-devel
BuildRequires: glib2-devel
BuildRequires: diffstat
BuildRequires: findutils
BuildRequires: samba-devel
BuildRequires: samba-winbind
BuildRequires: libsmbclient-devel
BuildRequires: libsystemd-devel
BuildRequires: cifs-utils-devel
BuildRequires: libsasl2-devel
BuildRequires: libnfsidmap-devel >= 1:2.2.1-alt1
BuildRequires: libunistring-devel
BuildRequires: libssl-devel libgnutls-devel libp11-kit-devel
BuildRequires: nscd
%if_with kcm
BuildRequires: libuuid-devel
%endif
BuildRequires: libhttp-parser-devel libcurl-devel
%if_with gdm_pam_extensions
BuildRequires: gdm-libs-devel
%endif

%if_with check
BuildRequires: /proc
BuildRequires: openssl
BuildRequires: openssh
BuildRequires: nss-utils
BuildRequires: libcmocka-devel >= 1.0.0
BuildRequires: uid_wrapper
BuildRequires: nss_wrapper
BuildRequires: pam_wrapper
BuildRequires: softhsm
%endif
BuildRequires: po4a

# Due sssd-drop-privileges control for unprivileged mode support
Requires: local-policy >= 0.4.8

%description
Provides a set of daemons to manage access to remote directories and
authentication mechanisms. It provides an NSS and PAM interface toward
the system and a pluggable backend system to connect to multiple different
account sources. It is also the basis to provide client auditing and policy
services for projects like FreeIPA.

The sssd subpackage is a meta-package that contains the deamon as well as all
the existing back ends.

%package client
Summary: SSSD Client libraries for NSS and PAM
Group: Networking/Other
License: LGPLv3+
Provides: libnss_sss
Provides: pam_sss
Requires: pam-config >= 1.9.0

%description client
Provides the libraries needed by the PAM and NSS stacks to connect to the SSSD
service.

%package -n libsss_sudo
Summary: A library to allow communication between SUDO and SSSD
Group: System/Libraries
License: LGPLv3+

%description -n libsss_sudo
A utility library to allow communication between SUDO and SSSD

%package -n libsss_autofs
Summary: A library to allow communication between Autofs and SSSD
Group: System/Libraries
License: LGPLv3+

%description -n libsss_autofs
A utility library to allow communication between Autofs and SSSD

%package tools
Summary: Userspace tools for use with the SSSD
Group: System/Configuration/Networking
License: GPLv3+
Requires: %name = %version-%release
Requires: python3-module-sss = %EVR
Requires: python3-module-sssd = %EVR
Requires: python3-module-sssdconfig = %EVR

%description tools
Provides several administrative tools:
    * sss_debuglevel to change the debug level on the fly
    * sss_seed which pre-creates a user entry for use in kickstarts
    * sss_obfuscate for generating an obfuscated LDAP password
    * sssctl -- an sssd status and control utility

%package ldap
Summary: The LDAP back end of the SSSD
Group: System/Servers
License: GPLv3+
Requires: %name-krb5-common = %version-%release

%description ldap
Provides the LDAP back end that the SSSD can utilize to fetch identity data
from and authenticate against an LDAP server.

%package krb5-common
Summary: SSSD helpers needed for Kerberos and GSSAPI authentication
Group: System/Servers
License: GPLv3+
Requires: %name = %version-%release
Requires: libsasl2-plugin-gssapi

%description krb5-common
Provides helper processes that the LDAP and Kerberos back ends can use for
Kerberos user or host authentication.

%package krb5
Summary: The Kerberos authentication back end for the SSSD
Group: System/Servers
License: GPLv3+
Requires: %name-krb5-common = %version-%release

%description krb5
Provides the Kerberos back end that the SSSD can utilize authenticate
against a Kerberos server.

%package pac
Summary: Common files needed for supporting PAC processing
Group: System/Servers
License: GPLv3+
Requires: %name = %version-%release

%description pac
Provides common files needed by SSSD providers such as IPA and Active Directory
for handling Kerberos PACs.

%package ipa
Summary: The IPA back end of the SSSD
Group: System/Servers
License: GPLv3+
Requires: %name-krb5-common = %version-%release
Requires: %name-pac = %version-%release
Requires: libipa_hbac = %version-%release

%description ipa
Provides the IPA back end that the SSSD can utilize to fetch identity data
from and authenticate against an IPA server.

%package ad
Summary: The AD back end of the SSSD
Group: System/Servers
License: GPLv3+
Requires: %name-krb5-common = %version-%release
Requires: %name-pac = %version-%release
Requires: %name-winbind-idmap = %version-%release

%description ad
Provides the Active Directory back end that the SSSD can utilize to fetch
identity data from and authenticate against an Active Directory server.

%package proxy
Summary: The proxy back end of the SSSD
Group: System/Servers
License: GPLv3+
Requires: %name = %version-%release

%description proxy
Provides the proxy back end which can be used to wrap an existing NSS and/or
PAM modules to leverage SSSD caching.

%package kcm
Summary: The SSSD Kerberos credentials manager
Group: System/Servers
License: GPLv3+
Requires: %name = %version-%release

%description kcm
An implementation of a Kerberos KCM server is a process that stores, tracks and
manages Kerberos credential caches. It originates in the Heimdal Kerberos
project, although the MIT Kerberos library also provides client side support for
the KCM credential cache.

%package -n libsss_idmap
Summary: FreeIPA Idmap library
Group: System/Libraries
License: LGPLv3+

%description -n libsss_idmap
Utility library to convert SIDs to Unix uids and gids

%package -n libsss_idmap-devel
Summary: FreeIPA Idmap library
Group: Development/C
License: LGPLv3+
Requires: libsss_idmap = %version-%release

%description -n libsss_idmap-devel
Utility library to SIDs to Unix uids and gids

%package -n libsss_certmap
Summary: SSSD Certficate Mapping Library
Group: System/Libraries
License: LGPLv3+
Conflicts: sssd < %version-%release

%description -n libsss_certmap
Library to map certificates to users based on rules

%package -n libsss_certmap-devel
Summary: SSSD Certficate Mapping Library
Group: Development/C
License: LGPLv3+
Requires: libsss_certmap = %version-%release

%description -n libsss_certmap-devel
Library to map certificates to users based on rules

%package -n libipa_hbac
Summary: FreeIPA HBAC Evaluator library
Group: System/Libraries
License: LGPLv3+

%description -n libipa_hbac
Utility library to validate FreeIPA HBAC rules for authorization requests

%package -n libipa_hbac-devel
Summary: FreeIPA HBAC Evaluator library
Group: Development/C
License: LGPLv3+
Requires: libipa_hbac = %version-%release

%description -n libipa_hbac-devel
Utility library to validate FreeIPA HBAC rules for authorization requests

%package -n libsss_nss_idmap
Summary: Library for SID based lookups and certificate based lookups
Group: System/Libraries
License: LGPLv3+

%description -n libsss_nss_idmap
Utility library for SID based lookups and certificate based lookups

%package -n libsss_nss_idmap-devel
Summary: Library for SID based lookups and certificate based lookups
Group: Development/C
License: LGPLv3+
Requires: libsss_nss_idmap = %version-%release

%description -n libsss_nss_idmap-devel
Utility library for SID based lookups and certificate based lookups

%package dbus
Summary: The D-Bus responder of the SSSD
Group: System/Servers
License: GPLv3+
Requires: %name = %version-%release

%description dbus
Provides the D-Bus responder of the SSSD, called the InfoPipe, that allows
the information from the SSSD to be transmitted over the system bus.

%package -n libsss_simpleifp
Summary: The SSSD D-Bus responder helper library
Group: System/Libraries
License: GPLv3+
Requires: %name-dbus = %version-%release

%description -n libsss_simpleifp
Provides library that simplifies D-Bus API for the SSSD InfoPipe responder.

%package -n libsss_simpleifp-devel
Summary: The SSSD D-Bus responder helper library
Group: Development/C
License: GPLv3+
Requires: libsss_simpleifp = %version-%release

%description -n libsss_simpleifp-devel
Provides library that simplifies D-Bus API for the SSSD InfoPipe responder.

%package winbind-idmap
Summary: SSSD's idmap_sss Backend for Winbind
Group: System/Servers
License: GPLv3+ and LGPLv3+

%description winbind-idmap
The idmap_sss module provides a way for Winbind to call SSSD to map UIDs/GIDs
and SIDs.

%package nfs-idmap
Summary: SSSD plug-in for NFSv4 rpc.idmapd
Group: System/Servers
License: GPLv3+

%description nfs-idmap
The libnfsidmap sssd module provides a way for rpc.idmapd to call SSSD to map
UIDs/GIDs to names and vice versa. It can be also used for mapping principal
(user) name to IDs(UID or GID) or to obtain groups which user are member of.

%package -n python3-module-sssdconfig
Summary: SSSD and IPA configuration file manipulation classes and functions
Group: Development/Python3
License: GPLv3+
BuildArch: noarch

%description -n python3-module-sssdconfig
Provides python3 files for manipulation SSSD and IPA configuration files.

%package -n python3-module-ipa_hbac
Summary: Python3 bindings for the FreeIPA HBAC Evaluator library
Group: Development/Python3
License: LGPLv3+
Requires: libipa_hbac = %EVR

%description -n python3-module-ipa_hbac
The python3-module-libipa_hbac contains the bindings so that libipa_hbac can be
used by Python3 applications.

%package -n python3-module-sss_nss_idmap
Summary: Python3 bindings for libsss_nss_idmap
Group: Development/Python3
License: LGPLv3+
Requires: libsss_nss_idmap = %EVR

%description -n python3-module-sss_nss_idmap
The python3-module-libsss_nss_idmap contains the bindings so that
libsss_nss_idmap can be used by Python applications.

%package -n python3-module-sss
Summary: Python3 bindings for sss
Group: Development/Python3
License: LGPLv3+
Requires: %name = %EVR

%description -n python3-module-sss
Provides python3 bindings:
    * function for retrieving list of groups user belongs to
    * class for obfuscation of passwords

%package -n python3-module-sss-murmur
Summary: Python3 bindings for murmur hash function
Group: Development/Python3
License: LGPLv3+

%description -n python3-module-sss-murmur
Provides python3 module for calculating the murmur hash version 3

%package -n python3-module-sssd
Summary: Python3 programs with sssd analyze tools
Group: System/Configuration/Other
License: GPLv3+

%add_python3_req_skip modules

%description -n python3-module-sssd
Provides python3 programs with sssd analyze tools

%prep
%setup
%patch -p1

%build
%autoreconf
%configure \
    --with-db-path=%dbpath \
    --with-pipe-path=%pipepath \
    --with-pubconf-path=%pubconfpath \
    --with-mcache-path=%mcpath \
    --with-gpo-cache-path=%gpocachepath \
    --with-init-dir=%_initdir \
    --with-initscript=systemd \
    --with-systemdunitdir=%_unitdir \
    --with-krb5-rcache-dir=%_localstatedir/cache/krb5rcache \
    --enable-nsslibdir=/%_lib \
    --enable-pammoddir=/%_lib/security \
    --enable-nfsidmaplibdir=%nfsidmapdir \
    --with-syslog=journald \
    --with-test-dir=/dev/shm \
    --enable-ldb-version-check \
    --enable-krb5-locator-plugin \
    --enable-pac-responder \
    --enable-sss-default-nss-plugin \
    --with-sssd-user=%sssd_user \
    --disable-rpath \
    --disable-static \
    %{subst_with kcm} \
    %{subst_with samba} \
    %{?!_enable_systemtap:--disable-systemtap} \
    --without-python2-bindings \
    #

%make_build all
%make docs

%install
for f in \
    src/tools/sss_obfuscate \
    src/tools/analyzer/sss_analyze.py;
do
    sed -i -e 's:/usr/bin/python:/usr/bin/python3:' \
           -e 's:/usr/bin/env\s*python\s*:/usr/bin/python3:' \
        "$f"
done

%make install DESTDIR=%buildroot

%find_lang sssd

# Prepare empty config file
install -D -m600 %SOURCE8 %buildroot%_sysconfdir/%name/%name.conf

# Copy default logrotate file
install -D -m644 src/examples/logrotate %buildroot%_sysconfdir/logrotate.d/%name

touch %buildroot%mcpath/passwd
touch %buildroot%mcpath/group
touch %buildroot%mcpath/initgroups

install -D -m755 %SOURCE2 %buildroot%_initdir/%name
install -D -m644 %SOURCE3 %buildroot%_pamdir/system-auth-sss
install -D -m644 %SOURCE4 %buildroot%_pamdir/system-auth-use_first_pass-sss
install -D -m644 %SOURCE5 %buildroot%_pamdir/system-auth-sss-only
install -D -m644 %SOURCE6 %buildroot%_pamdir/system-auth-use_first_pass-sss-only

# Remove .la files created by libtool
find %buildroot -name "*.la" -exec rm -f {} \;

# Suppress developer-only documentation
rm -Rf %buildroot%_docdir/%name

mkdir -p %buildroot%pubconfpath/krb5.include.d
mkdir -p %buildroot%dotcachepath

# Add alternatives for idmap-plugin
mkdir -p %buildroot/%_altdir
printf '%_libdir/cifs-utils/idmap-plugin\t%_libdir/cifs-utils/cifs_idmap_sss.so\t20\n' > %buildroot%_altdir/cifs-idmap-plugin-sss

%if_disabled systemtap
# Clean manpages l10n
rm -f %buildroot/%_mandir/*/man5/sssd-systemtap.5*
%endif

%check
export CK_TIMEOUT_MULTIPLIER=10
%make check VERBOSE=yes
unset CK_TIMEOUT_MULTIPLIER

%pre
%_sbindir/groupadd -r -f %sssd_user 2> /dev/null ||:
%_sbindir/useradd -r -n -g %sssd_user -G _keytab -d %sssdstatedir -s /dev/null -c "User for sssd" %sssd_user 2> /dev/null ||:

%post
chown root:root %_sysconfdir/sssd/sssd.conf

# Don't restart sssd services until reboot or manual restart
#post_service %name
#
#preun
#preun_service %name

%triggerpostun -- %name < 2.4.2-alt1
[ "$(control sssd-drop-privileges)" != "unknown" ] ||
    control sssd-drop-privileges unprivileged

#triggerpostun -- %name < 1.14.2-alt5
#_bindir/gpasswd -a %sssd_user _keytab

%files -f sssd.lang
%doc COPYING
%doc $RPM_SOURCE_DIR/sssd-example.conf
%_sbindir/%name
%_initdir/%name
%_unitdir/%name.service
%_unitdir/sssd-nss.service
%_unitdir/sssd-nss.socket
%_unitdir/sssd-pam-priv.socket
%_unitdir/sssd-pam.service
%_unitdir/sssd-pam.socket
%_unitdir/sssd-ssh.service
%_unitdir/sssd-ssh.socket

%dir %_libexecdir/%name
%_libexecdir/%name/sssd_be
%_libexecdir/%name/sssd_check_socket_activated_responders
%_libexecdir/%name/sssd_nss
%_libexecdir/%name/sssd_pam
%_libexecdir/%name/sssd_autofs
%_libexecdir/%name/sssd_ssh
%_libexecdir/%name/sssd_sudo
%_libexecdir/%name/p11_child
%_datadir/polkit-1/rules.d/*

%dir %_libdir/%name
%_libdir/%name/libsss_simple.so

#Internal shared libraries
%_libdir/%name/libsss_child.so
%_libdir/%name/libsss_crypt.so
%_libdir/%name/libsss_cert.so
%_libdir/%name/libsss_debug.so
%_libdir/%name/libsss_files.so
%_libdir/%name/libsss_krb5_common.so
%_libdir/%name/libsss_ldap_common.so
%_libdir/%name/libsss_util.so
%_libdir/%name/libsss_semanage.so
%_libdir/%name/libsss_sbus.so
%_libdir/%name/libsss_sbus_sync.so
%_libdir/%name/libsss_iface.so
%_libdir/%name/libsss_iface_sync.so
%_libdir/%name/libifp_iface.so
%_libdir/%name/libifp_iface_sync.so

# 3rd party application libraries
%dir %_libdir/%name/modules

%ldb_modulesdir/memberof.so
%_bindir/sss_ssh_authorizedkeys
%_bindir/sss_ssh_knownhostsproxy
%_sbindir/sss_cache
%_libexecdir/%name/sss_signal

%dir %sssdstatedir
%dir %_localstatedir/cache/krb5rcache
%attr(700,%sssd_user,%sssd_user) %dir %dbpath
%attr(755,%sssd_user,%sssd_user) %dir %mcpath
%attr(700,%sssd_user,%sssd_user) %dir %deskprofilepath
%ghost %attr(0644,%sssd_user,%sssd_user) %verify(not md5 size mtime) %mcpath/passwd
%ghost %attr(0644,%sssd_user,%sssd_user) %verify(not md5 size mtime) %mcpath/group
%ghost %attr(0644,%sssd_user,%sssd_user) %verify(not md5 size mtime) %mcpath/initgroups
%attr(755,%sssd_user,%sssd_user) %dir %pipepath
%attr(750,%sssd_user,root) %dir %pipepath/private
%attr(755,%sssd_user,%sssd_user) %dir %gpocachepath
%attr(755,%sssd_user,%sssd_user) %dir %pubconfpath
%attr(755,%sssd_user,%sssd_user) %dir %dotcachepath
%attr(770,root,%sssd_user) %dir %_logdir/%name
%attr(750,root,%sssd_user) %dir %_sysconfdir/sssd
%attr(750,root,%sssd_user) %dir %_sysconfdir/sssd/conf.d
%attr(0600,root,root) %config(noreplace) %_sysconfdir/sssd/sssd.conf
%dir %_sysconfdir/systemd/system/sssd.service.d
%config(noreplace) %_sysconfdir/logrotate.d/sssd
%dir %_datadir/%name
%_sysconfdir/pam.d/sssd-shadowutils
%dir %_libdir/%name/conf
%_libdir/%name/conf/sssd.conf

%_datadir/%name/cfg_rules.ini
%_datadir/%name/sssd.api.conf
%dir %_datadir/%name/sssd.api.d
%_datadir/%name/sssd.api.d/sssd-simple.conf
%_datadir/%name/sssd.api.d/sssd-files.conf
%_man1dir/sss_ssh_*
%_mandir/*/man1/sss_ssh_*
%_man5dir/sssd.conf.5*
%_mandir/*/man5/sssd.conf.5*
%_man5dir/sssd-files.5*
%_mandir/*/man5/sssd-files.5*
%_man5dir/sssd-simple.5*
%_mandir/*/man5/sssd-simple.5*
%_man5dir/sssd-sudo.5*
%_mandir/*/man5/sssd-sudo.5*
%_man5dir/sssd-session-recording.5*
%_mandir/*/man5/sssd-session-recording.5*
%_man5dir/sss_rpcidmapd.5*
%_mandir/*/man5/sss_rpcidmapd.5*
%_man8dir/sssd.8*
%_mandir/*/man8/sssd.8*
%_man8dir/sss_cache.8*
%_mandir/*/man8/sss_cache.8*

%if_enabled systemtap
%dir %_datadir/%name/systemtap
%_datadir/%name/systemtap/*.stp
%dir %_datadir/systemtap
%dir %_datadir/systemtap/tapset
%_datadir/systemtap/tapset/sssd*.stp
%_man5dir/sssd-systemtap.5*
%endif

%files ldap
%_libdir/%name/libsss_ldap.so
%_man5dir/sssd-ldap*
%_mandir/*/man5/sssd-ldap*
%_datadir/%name/sssd.api.d/sssd-ldap.conf

%files krb5-common
%attr(755,%sssd_user,%sssd_user) %dir %pubconfpath/krb5.include.d
%attr(4710,root,%sssd_user) %_libexecdir/%name/ldap_child
%attr(4710,root,%sssd_user) %_libexecdir/%name/krb5_child

%files krb5
%_libdir/%name/libsss_krb5.so
%_man5dir/sssd-krb5*
%_mandir/*/man5/sssd-krb5*
%_datadir/%name/sssd.api.d/sssd-krb5.conf

%files pac
%_libexecdir/%name/sssd_pac
%_unitdir/sssd-pac.service
%_unitdir/sssd-pac.socket

%files ipa
%attr(700,%sssd_user,%sssd_user) %dir %keytabdir
%_libdir/%name/libsss_ipa.so
%attr(4710,root,%sssd_user) %_libexecdir/%name/selinux_child
%_man5dir/sssd-ipa*
%_mandir/*/man5/sssd-ipa*
%_datadir/%name/sssd.api.d/sssd-ipa.conf

%files ad
%_libdir/%name/libsss_ad.so
%_libexecdir/%name/gpo_child
%_man5dir/sssd-ad*
%_mandir/*/man5/sssd-ad*
%_datadir/%name/sssd.api.d/sssd-ad.conf

%files proxy
%attr(4710,root,%sssd_user) %_libexecdir/%name/proxy_child
%_libdir/%name/libsss_proxy.so
%_datadir/%name/sssd.api.d/sssd-proxy.conf

%files client
%config(noreplace) %_pamdir/*-sss*
/%_lib/libnss_sss.so.2
/%_lib/security/pam_sss.so
/%_lib/security/pam_sss_gss.so
%_libdir/krb5/plugins/libkrb5/sssd_krb5_locator_plugin.so
%_libdir/krb5/plugins/authdata/sssd_pac_plugin.so
%_libdir/cifs-utils/cifs_idmap_sss.so
%_altdir/cifs-idmap-plugin-sss
%_libdir/%name/modules/sssd_krb5_localauth_plugin.so
%_man8dir/pam_sss*
%_mandir/*/man8/pam_sss*
%_man8dir/sssd_krb5_locator_plugin*
%_mandir/*/man8/sssd_krb5_locator_plugin*

%files -n libsss_sudo
%_libdir/libsss_sudo.so*
%_unitdir/sssd-sudo.service
%_unitdir/sssd-sudo.socket

%files -n libsss_autofs
%_libdir/%name/modules/libsss_autofs.so
%_unitdir/sssd-autofs.service
%_unitdir/sssd-autofs.socket

%files tools
%_sbindir/sss_*
%_sbindir/sssctl
%_man8dir/sss_*
%_mandir/*/man8/sss_*
%_man8dir/sssctl*
%_mandir/*/man8/sssctl*
%exclude %_sbindir/sss_cache
%exclude %_man8dir/sss_cache*
%exclude %_mandir/*/man8/sss_cache*

%files -n libsss_idmap
%_libdir/libsss_idmap.so.*

%files -n libsss_idmap-devel
%doc idmap_doc/html
%_includedir/sss_idmap.h
%_libdir/libsss_idmap.so
%_pkgconfigdir/sss_idmap.pc

%files -n libsss_certmap
%_libdir/libsss_certmap.so.*
%_man5dir/sss-certmap*
%_mandir/*/man5/sss-certmap*

%files -n libsss_certmap-devel
%doc certmap_doc/html
%_includedir/sss_certmap.h
%_libdir/libsss_certmap.so
%_pkgconfigdir/sss_certmap.pc

%files -n libipa_hbac
%_libdir/libipa_hbac.so.*

%files -n libipa_hbac-devel
%doc hbac_doc/html
%_includedir/ipa_hbac.h
%_libdir/libipa_hbac.so
%_pkgconfigdir/ipa_hbac.pc

%files -n libsss_nss_idmap
%_libdir/libsss_nss_idmap.so.*

%files -n libsss_nss_idmap-devel
%doc nss_idmap_doc/html
%_includedir/sss_nss_idmap.h
%_libdir/libsss_nss_idmap.so
%_pkgconfigdir/sss_nss_idmap.pc

%files dbus
%doc COPYING
%_libexecdir/%name/sssd_ifp
%_man5dir/sssd-ifp*
%_mandir/*/man5/sssd-ifp*
# InfoPipe DBus plumbing
%_sysconfdir/dbus-1/system.d/org.freedesktop.sssd.infopipe.conf
%_datadir/dbus-1/system-services/org.freedesktop.sssd.infopipe.service
%_unitdir/sssd-ifp.service

%if_with kcm
%files kcm
%_libexecdir/%name/sssd_kcm
%dir %_datadir/sssd-kcm
%_datadir/sssd-kcm/kcm_default_ccache
%_unitdir/sssd-kcm.socket
%_unitdir/sssd-kcm.service
%_man8dir/sssd-kcm*
%_mandir/*/man8/sssd-kcm*
%endif

%files -n libsss_simpleifp
%_libdir/libsss_simpleifp.so.*

%files -n libsss_simpleifp-devel
%_includedir/sss_sifp.h
%_includedir/sss_sifp_dbus.h
%_libdir/libsss_simpleifp.so
%_pkgconfigdir/sss_simpleifp.pc

%files winbind-idmap
%_libdir/samba/idmap/sss.so
%_man8dir/idmap_sss*
%_mandir/*/man8/idmap_sss*

%files nfs-idmap
%nfsidmapdir/sss.so

%files -n python3-module-sss
%python3_sitelibdir/pysss.so

%files -n python3-module-sss-murmur
%python3_sitelibdir/pysss_murmur.so

%files -n python3-module-ipa_hbac
%python3_sitelibdir/pyhbac.so

%files -n python3-module-sss_nss_idmap
%python3_sitelibdir/pysss_nss_idmap.so

%files -n python3-module-sssdconfig
%dir %python3_sitelibdir_noarch/SSSDConfig
%python3_sitelibdir_noarch/SSSDConfig/*.py*
%python3_sitelibdir_noarch/SSSDConfig*.egg-info
%dir %python3_sitelibdir_noarch/SSSDConfig/__pycache__
%python3_sitelibdir_noarch/SSSDConfig/__pycache__/*.py*

%files -n python3-module-sssd
%dir %python3_sitelibdir_noarch/sssd
%python3_sitelibdir_noarch/sssd/*.py*
%dir %python3_sitelibdir_noarch/sssd/__pycache__
%python3_sitelibdir_noarch/sssd/__pycache__/*.py*
%dir %python3_sitelibdir_noarch/sssd/modules
%python3_sitelibdir_noarch/sssd/modules/*.py*
%dir %python3_sitelibdir_noarch/sssd/modules/__pycache__
%python3_sitelibdir_noarch/sssd/modules/__pycache__/*.py*

%changelog
