Name: stk
Version: 4.5.0
Release: alt1.1
License: GPL
Group: Sound
Summary: C++ classes for audio digital signal processing
Url: http://www-ccrma.stanford.edu/software/stk/
Source: stk-%version.tar

Requires: lib%name = %version-%release

# Automatically added by buildreq on Thu Nov 22 2007
BuildRequires: gcc-c++ jackit-devel libalsa-devel util-linux-ng
BuildRequires: desktop-file-utils symlinks

%description
The Synthesis ToolKit in C++ (STK) is a set of open source audio signal
processing and algorithmic synthesis classes written in C++. STK was
designed to facilitate rapid development of music synthesis and audio
processing software, with an emphasis on cross-platform functionality,
realtime control, ease of use, and educational example code. The Synthesis
ToolKit is extremely portable (it's mostly platform-independent C and C++
code), and it's completely user-extensible (all source included, no unusual
libraries, and no hidden drivers). We like to think that this increases the
chances that our programs will still work in another 5-10 years. In fact,
the ToolKit has been working continuously for nearly 8 years now. STK
currently runs with "realtime" support (audio and MIDI) on SGI (Irix),
Linux, Macintosh OS X, and Windows computer platforms. Generic,
non-realtime support has been tested under NeXTStep, Sun, and other
platforms and should work with any standard C++ compiler.

%package -n lib%name
Summary: C++ classes for audio digital signal processing
Group: System/Libraries

%description -n lib%name
The Synthesis ToolKit in C++ (STK) is a set of open source audio signal
processing and algorithmic synthesis classes written in C++. STK was
designed to facilitate rapid development of music synthesis and audio
processing software, with an emphasis on cross-platform functionality,
realtime control, ease of use, and educational example code. The Synthesis
ToolKit is extremely portable (it's mostly platform-independent C and C++
code), and it's completely user-extensible (all source included, no unusual
libraries, and no hidden drivers). We like to think that this increases the
chances that our programs will still work in another 5-10 years. In fact,
the ToolKit has been working continuously for nearly 8 years now. STK
currently runs with "realtime" support (audio and MIDI) on SGI (Irix),
Linux, Macintosh OS X, and Windows computer platforms. Generic,
non-realtime support has been tested under NeXTStep, Sun, and other
platforms and should work with any standard C++ compiler.

%package -n lib%name-devel
Summary: Header files for LibSTK library
Group: Development/C++
Requires: lib%name = %version-%release
%description -n lib%name-devel
Header files for LibSTK library.

%package -n lib%name-devel-static
Summary: Static LibSTK library
Group: Development/C++
Obsoletes: lib%name-static

%description -n lib%name-devel-static
Static LibSTK library.

%package doc
Summary: Documentation for the sound synthesis toolkit (STK)
Group: Documentation
BuildArch: noarch
%description doc
This package contains the documentation for the sound synthesis
toolkit. The documentation is developer oriented and covers all
you need to know if you want to develop an STK application.

%prep
%setup

sed -i "s|/usr/lib|%_libdir|g" src/Makefile.in
sed -i 's:../../rawwaves/:/usr/share/stk/rawwaves/:g' projects/demo/demo.cpp

%build
%autoreconf
%configure --with-alsa \
	--with-jack \
	--enable-shared \
	RAWWAVE_PATH=%_datadir/stk/rawwaves/

%make

%install
mkdir -p \
  %buildroot%_includedir/stk \
  %buildroot%_libdir \
  %buildroot%_bindir \
  %buildroot%_datadir/stk/rawwaves \
  %buildroot%_datadir/stk/demo \
  %buildroot%_datadir/stk/examples \
  %buildroot%_datadir/stk/effects \
  %buildroot%_datadir/stk/ragamatic \
  %buildroot%_datadir/stk/eguitar

cp -p include/* %buildroot%_includedir/stk
cp -pd src/libstk.* %buildroot%_libdir
cp -p rawwaves/*.raw %buildroot%_datadir/stk/rawwaves

cp -pr projects/demo/tcl %buildroot%_datadir/stk/demo
cp -pr projects/demo/scores %buildroot%_datadir/stk/demo
cp -p projects/demo/demo %buildroot%_bindir/stk-demo
#cp -p projects/demo/Md2Skini %buildroot%_bindir/Md2Skini
for f in Banded Drums Modal Physical Shakers StkDemo Voice ; do
  chmod +x projects/demo/$f
  sed -e 's,\./demo,%_bindir/stk-demo,' -e '1i#! /bin/sh' \
    -i projects/demo/$f
  cp -p projects/demo/$f %buildroot%_datadir/stk/demo
done

cp -pr projects/examples/midifiles %buildroot%_datadir/stk/examples
cp -pr projects/examples/rawwaves %buildroot%_datadir/stk/examples
cp -pr projects/examples/scores %buildroot%_datadir/stk/examples
for f in sine sineosc foursine audioprobe midiprobe duplex play \
    record inetIn inetOut rtsine crtsine bethree controlbee \
    threebees playsmf grains ; do
  cp -p projects/examples/$f %buildroot%_bindir/stk-$f
  # absolute links, will be shortened later
  ln -s %buildroot%_bindir/stk-$f %buildroot%_datadir/stk/examples/$f
done

cp -pr projects/effects/tcl %buildroot%_datadir/stk/effects
cp -p projects/effects/effects %buildroot%_bindir/stk-effects
sed -e 's,\./effects,%_bindir/stk-effects,' -e '1i#! /bin/sh' \
  -i projects/effects/StkEffects
cp -p projects/effects/StkEffects %buildroot%_datadir/stk/effects

cp -pr projects/ragamatic/tcl %buildroot%_datadir/stk/ragamatic
cp -pr projects/ragamatic/rawwaves %buildroot%_datadir/stk/ragamatic
cp -p projects/ragamatic/ragamat %buildroot%_bindir/stk-ragamat
sed -e 's,\./ragamat,%_bindir/stk-ragamat,' -e '1i#! /bin/sh' \
  -i projects/ragamatic/Raga
cp -p projects/ragamatic/Raga %buildroot%_datadir/stk/ragamatic

cp -pr projects/eguitar/tcl %buildroot%_datadir/stk/eguitar
cp -pr projects/eguitar/scores %buildroot%_datadir/stk/eguitar
cp -p projects/eguitar/eguitar %buildroot%_bindir/stk-eguitar
sed -e 's,\./eguitar,%_bindir/stk-eguitar,' -e '1i#! /bin/sh' \
  -i projects/eguitar/ElectricGuitar
cp -p projects/eguitar/ElectricGuitar %buildroot%_datadir/stk/eguitar

# fix symlinks
symlinks -crv %buildroot

# fix encoding
iconv -f iso-8859-1 -t utf-8 doc/doxygen/index.txt \
  -o doc/doxygen/index.txt.tmp
mv doc/doxygen/index.txt.tmp doc/doxygen/index.txt

%files
%_bindir/*
%_datadir/stk/*

%exclude %_datadir/stk/rawwaves

%files -n lib%name
%dir %_datadir/stk
%doc README*
%_libdir/*.so.*
%_datadir/stk/rawwaves

%files -n lib%name-devel
%_libdir/*.so
%_includedir/stk

%files -n lib%name-devel-static
%_libdir/*.a

%files doc
%doc doc/html doc/*.txt

%changelog
