Name: supertux2
Version: 0.6.0
Release: alt2.1

Summary: Classic 2D jump'n run sidescroller game in a Super Mario style
License: GPLv3
Group: Games/Arcade
Url: https://www.supertux.org/

Packager: Anton Midyukov <antohami@altlinux.org>

# Source-url: https://github.com/SuperTux/supertux/releases/download/v%version/SuperTux-v%version-Source.tar.gz
Source: SuperTux-v%version-Source.tar.gz

Source1: supertux-16x16.png
Source2: supertux-32x32.png
Source3: supertux-48x48.png

Patch: supertux2-alt-fix-translations.patch

Requires: %name-data = %version-%release

# Automatically added by buildreq on Mon Oct 01 2012 (-bi)
# WTF? vorbis-tools? really?
BuildPreReq: cmake rpm-macros-cmake
BuildRequires: boost-program_options-devel boost-filesystem-devel boost-locale-devel gcc-c++ libSDL2_image-devel libSM-devel libXau-devel libXdmcp-devel libXft-devel libcurl-devel libglew-devel libopenal-devel libphysfs-devel libvorbis-devel zlib-devel libpng-devel libfreetype-devel libraqm-devel

%description
SuperTux is a jump'n run like game, with strong inspiration from the
Super Mario Bros games for Nintendo.

Run and jump through multiple worlds, fighting off enemies by jumping
on them or bumping them from below.  Grabbing power-ups and other stuff
on the way.

Note! This is a still development version.

%package data
Summary: Data files for supertux2
Group: Games/Arcade
BuildArch: noarch

%description data
SuperTux is a jump'n run like game, with strong inspiration from the
Super Mario Bros games for Nintendo.

Run and jump through multiple worlds, fighting off enemies by jumping
on them or bumping them from below. Grabbing power-ups and other stuff
on the way.

This is package contains data files for supertux2.

%prep
%setup -n SuperTux-v%version-Source
%patch -p2

%build
%cmake_insource \
        -DINSTALL_SUBDIR_BIN=bin \
        -DINSTALL_SUBDIR_SHARE=share/supertux2 \
        -DCMAKE_BUILD_TYPE="Release" \
        -DENABLE_BOOST_STATIC_LIBS=OFF
%make_build

%install
%makeinstall_std
%find_lang %name

install -m644 %SOURCE1 -D %buildroot/%_miconsdir/%name.png
install -m644 %SOURCE2 -D %buildroot/%_niconsdir/%name.png
install -m644 %SOURCE3 -D %buildroot/%_liconsdir/%name.png

# install game man file
install -D -m 644 man/man6/%name.6 %buildroot/%_man6dir/%name.6

rm -rf %buildroot/%_docdir/supertux2/

%files -f %name.lang
%_bindir/supertux2
%_desktopdir/supertux2.desktop
%doc LICENSE.txt NEWS.md README.md

%files data
%_datadir/supertux2
%dir %_datadir/metainfo
%_datadir/metainfo/*
%_miconsdir/*.png
%_niconsdir/*.png
%_liconsdir/*.png
%dir %_iconsdir/hicolor/scalable
%dir %_iconsdir/hicolor/scalable/apps
%_iconsdir/hicolor/scalable/apps/*
%exclude %_pixmapsdir/supertux.*
%_man6dir/*
%exclude %_datadir/supertux2/sounds/normalize.sh

%changelog
