Name: supertuxkart
Version: 1.2
Release: alt2

License: GPL-2.0-or-later and GPL-3.0-or-later and CC-BY-SA-3.0
Url: http://supertuxkart.sourceforge.net
Summary: SuperTuxKart is a kart racing game
Group: Games/Arcade
Packager: Ilya Mashkin <oddity@altlinux.ru>

# https://github.com/supertuxkart/stk-code
Source: %name-%version-src.tar.gz
#Patch: supertuxkart-0.9.3-debian-irrlicht.patch
Patch: supertuxkart-1.2-debian-ftbfs_sdl.patch

BuildRequires(pre): rpm-build-ninja
# for aarch64 support
BuildRequires(pre): libGLES
# Automatically added by buildreq on Thu Jan 30 2020 (-bi)
# optimized out: bash4 bashrc cmake-modules elfutils glibc-kernheaders-generic glibc-kernheaders-x86 libGLU-devel libICE-devel libSM-devel libX11-devel libXau-devel libXext-devel libXfixes-devel libXrender-devel libcrypt-devel libglvnd-devel libharfbuzz-devel libogg-devel libsasl2-3 libstdc++-devel libwayland-client libwayland-client-devel libwayland-cursor libwayland-egl pkg-config python-modules python2-base python3 python3-base rpm-build-gir sh4 tzdata wayland-devel xorg-proto-devel xorg-xf86miscproto-devel zlib-devel
BuildRequires: bzlib-devel cmake gcc-c++ libGLEW-devel libXi-devel libXrandr-devel libXt-devel libXxf86misc-devel libXxf86vm-devel libcurl-devel libfreetype-devel libfribidi-devel libjpeg-devel libmcpp-devel libopenal-devel libpng-devel libsqlite3-devel libssl-devel libvorbis-devel libwayland-cursor-devel libwayland-egl-devel libxkbcommon-devel libxkbfile-devel poppler python-modules-compiler rpm-build-python3 libSDL2-devel
# use system libraries instead build-in
BuildRequires: libwiiuse-devel libraqm-devel

Requires: %name-data >= %version

%description
SuperTuxCart is a kart racing game

%prep
%setup -n %name-%version
%patch -p1

%build
%cmake -GNinja -DCMAKE_BUILD_TYPE=Debug -DUSE_SYSTEM_ANGELSCRIPT=OFF -DBUILD_RECORDER=OFF -DCHECK_ASSETS=OFF
%ninja_build -C BUILD

%install
#install -d %%buildroot%%_niconsdir
%ninja_install -C BUILD

# The package contains a CVS/.svn/.git/.hg/.bzr/_MTN directory of revision control system.
# It was most likely included by accident since CVS/.svn/.hg/... etc. directories
# usually don't belong in releases.
# When packaging a CVS/SVN snapshot, export from CVS/SVN rather than use a checkout.
find %buildroot -type d \( -name 'CVS' -o -name '.svn' -o -name '.git' -o -name '.hg' -o -name '.bzr' -o -name '_MTN' \) -print -exec rm -rf {} \; ||:
# the find below is useful in case those CVS/.svn/.git/.hg/.bzr/_MTN directory is added as %%doc
find . -type d \( -name 'CVS' -o -name '.svn' -o -name '.git' -o -name '.hg' -o -name '.bzr' -o -name '_MTN' \) -print -exec rm -rf {} \; ||:

%files
#doc README.md CHANGELOG.md NETWORKING.md
%_bindir/*
%_desktopdir/%name.desktop
%dir %_datadir/%name
%_datadir/%name/*
%_datadir/metainfo/*
%_pixmapsdir/*
%_iconsdir/hicolor/16x16/apps/*
%_iconsdir/hicolor/32x32/apps/*
%_iconsdir/hicolor/48x48/apps/*
%_iconsdir/hicolor/64x64/apps/*
%_iconsdir/hicolor/128x128/apps/*
%_iconsdir/hicolor/256x256/apps/*
%_iconsdir/hicolor/512x512/apps/*
%_iconsdir/hicolor/1024x1024/apps/*
# built in separate libwiiuse-devel
%exclude %_includedir/wiiuse.h
%exclude %_libdir/libwiiuse.a

%changelog
