Name:     sysbench
Version:  1.0.17
Release:  alt1

Summary:  Scriptable database and system performance benchmark
License:  GPL-2.0
Group:    Other
Url:      https://github.com/akopytov/sysbench

Packager: Anton Midyukov <antohami@altlinux.org>

Source:   %name-%version.tar

BuildRequires: ck-devel
BuildRequires: docbook-style-xsl
BuildRequires: libaio-devel
BuildRequires: libtool
BuildRequires: libxslt
BuildRequires: libluajit-devel
BuildRequires: mysql-devel
BuildRequires: postgresql-devel

%description
SysBench is a modular, cross-platform and multi-threaded benchmark
tool for evaluating OS parameters that are important for a system
running a database under intensive load.

The idea of this benchmark suite is to quickly get an impression about
system performance without setting up complex database benchmarks or
even without installing a database at all. Current features allow to
test the following system parameters:
- file I/O performance
- scheduler performance
- memory allocation and transfer speed
- POSIX threads implementation performance
- database server performance (OLTP benchmark)

Primarily written for MySQL server benchmarking, SysBench will be
further extended to support multiple database backends, distributed
benchmarks and third-party plug-in modules.

%prep
%setup
rm -r third_party/luajit/luajit/
rm -r third_party/concurrency_kit/ck/

%build
export CFLAGS="%optflags"
%autoreconf
%configure --with-mysql \
           --with-pgsql \
           --with-system-ck \
           --with-system-luajit \
           --without-gcc-arch

%make_build

%install
%makeinstall_std
mv %buildroot%_docdir/sysbench/manual.html .

%files
%doc ChangeLog COPYING README.md manual.html
%_bindir/*
%_datadir/%name

%changelog
