Name:    system-config-printer
Version: 1.5.15
Release: alt1

Summary: A printer administration tool
Group:   System/Configuration/Printing
License: GPLv2+
Url:     http://cyberelk.net/tim/software/system-config-printer/
# Git:   https://github.com/OpenPrinting/system-config-printer

Source: %name-%version.tar
Source1: ru.po
Patch0: %name-1.5.11-alt.patch
Patch1: fix_search_printer.patch
Patch2: about_logo.patch
Patch3: %name-alt-fix-SMB-auth-fields-order.patch
Patch4: %name-1.5.11-plugins.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: python3-module-cups
BuildRequires: python3-module-pluggy
BuildRequires: desktop-file-utils
BuildRequires: cups-devel
BuildRequires: libusb-devel
BuildRequires: libudev-devel
BuildRequires: gettext-devel
BuildRequires: glib2-devel
BuildRequires: intltool
BuildRequires: xmlto

Requires: %name-lib = %EVR

%add_python3_path /usr/share/system-config-printer

%description
system-config-printer is a graphical user interface that allows
the user to configure a CUPS print server.

%package lib
Summary: Libraries and share for printer tools
Group: System/Configuration/Printing
Requires: python3-module-cupshelpers = %version-%release
Requires: python3-module-cups >= 1.9.61-alt1

%description lib
Code used by both graphical and non-graphical parts

%package udev
Summary: Rules for udev for automatic configuration of USB printers
Group: System/Configuration/Printing
Requires: %name-lib = %version-%release

%description udev
The udev rules and helper programs for automatically configuring USB
printers.

%package -n python3-module-cupshelpers
Summary: Python module to configure a CUPS print server
Group: System/Configuration/Printing
BuildArch: noarch
Conflicts: python-module-cupshelpers

%description -n python3-module-cupshelpers
Python module to configure a CUPS print server

%prep
%setup -q
sed -i 's/mod.*ins.*_aft.*//' newprinter.py
%patch0 -p1
%patch1 -p0
%patch2 -p0
%patch3 -p1
%patch4 -p1
cat %SOURCE1 > po/ru.po

%build
./bootstrap
%configure --with-udev-rules \
           --with-polkit-1

%install
%makeinstall_std udevrulesdir=/lib/udev/rules.d \
                 udevhelperdir=/lib/udev
install -Dm0644 tmpfiles.conf %buildroot%_tmpfilesdir/system-config-printer.conf
mv %buildroot%_datadir/{metainfo,appdata}

%find_lang system-config-printer

%post
/bin/rm -f /var/cache/foomatic/foomatic.pickle ||:
exit 0

%files lib
%_bindir/scp-dbus-service
%_datadir/dbus-1/interfaces/*.xml
%_datadir/dbus-1/services/*.service
%_datadir/%name
/etc/dbus-1/system.d/*.conf

%files udev
%_tmpfilesdir/*
/lib/udev/rules.d/*.rules
/lib/udev/udev-*-printer

%files -f system-config-printer.lang
%doc README.md COPYING
%_bindir/install-printerdriver
%_bindir/system-config-printer*
%_datadir/appdata/%name.appdata.xml
%_desktopdir/*.desktop
%_sysconfdir/xdg/autostart/*.desktop
%_man1dir/*

%files -n python3-module-cupshelpers
%config(noreplace) %_sysconfdir/cupshelpers/*.xml
%python3_sitelibdir_noarch/cupshelpers
%python3_sitelibdir_noarch/cupshelpers-*

%changelog
