Name: tcsh
Version: 6.20.00
Release: alt2
Summary: An enhanced version of csh, the C shell
License: BSD
Group: Shells
URL: http://www.tcsh.org
Source0: ftp://ftp.astron.com/pub/tcsh/tcsh-%version.tar.gz
Source1: tcsh.login
Source2: tcsh.cshrc
Source3: tcshrc.skel
Patch0: tcsh-%version-alt-build.diff
Patch1: tcsh-%version-alt-closem-nosocket.diff
Patch2: tcsh-%version-alt-maxwidth.diff
Patch3: tcsh-%version-alt-tinfo.diff
Patch4: tcsh-%version-owl-config.diff
Patch5: tcsh-%version-owl-lscolors.diff
Patch6: tcsh-%version-owl-no-TIOCSTI.diff
Patch7: tcsh-%version-owl-strnxxx.diff
Patch8: tcsh-%version-owl-tmp.diff
Patch9: tcsh-%version-owl-warnings.diff
Conflicts: setup < 2.2.14-alt2
Provides: csh = %version

# Automatically added by buildreq on Sun Jan 15 2012
BuildRequires: groff-base libtinfo-devel

%description
tcsh is an enhanced but completely compatible version of csh, the C
shell.  tcsh is a command language interpreter which can be used both
as an interactive login shell and as a shell script command processor.
tcsh includes a command line editor, programmable word completion,
spelling correction, a history mechanism, job control and a C language
like syntax.

%package doc
Group: Shells
Summary: Optional documentation for %name
BuildArch: noarch
Requires: %name = %EVR

%description doc
This package contains optional documentation for %name.

%prep
%setup
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1

%define _bindir	/bin

%build
%configure \
  --disable-rpath
%__make all
test -x %__perl && %__perl tcsh.man2html tcsh.man || :
%__make -C nls catalogs

%install
install -pm 755 -D tcsh %buildroot/bin/tcsh
install -pm 644 -D tcsh.man %buildroot%_man1dir/tcsh.1
ln -sf tcsh %buildroot/bin/csh
ln -sf tcsh.1 %buildroot%_man1dir/csh.1

install -pm 644 -D %_sourcedir/tcshrc.skel %buildroot/etc/skel/.tcshrc
install -pm 644 %_sourcedir/tcsh.login %buildroot/etc/csh.login
install -pm 644 %_sourcedir/tcsh.cshrc %buildroot/etc/csh.cshrc

while read lang language; do
	dest=%buildroot%_datadir/locale/$lang/LC_MESSAGES
	if test -f nls/$language.cat; then
		install -pm 644 -D nls/$language.cat $dest/tcsh.mo
	fi
done << EOF
en C
et et
fi finnish
fr french
de german
el greek
it italian
ja ja
pl pl
ru russian
es spanish
uk ukrainian
EOF

%find_lang tcsh

%post
# do not edit /etc/shells on upgrades
if [ $1 -eq 1 ]; then
	grep -Fqx /bin/csh /etc/shells || echo /bin/csh >> /etc/shells
	grep -Fqx /bin/tcsh /etc/shells || echo /bin/tcsh >> /etc/shells
fi

%preun
# do not edit /etc/shells on upgrades
if [ $1 -eq 0 ]; then
	sed -i -e '/^\/bin\/t\?csh$/d' /etc/shells
fi

%files -f tcsh.lang
%config(noreplace) /etc/csh.*
%config(noreplace) /etc/skel/.tcshrc
/bin/csh
/bin/tcsh
%_man1dir/*.*

%files doc
%doc NewThings FAQ complete.tcsh Fixes tcsh.html

%changelog
