%def_disable snapshot
%define ver_major 1.5

%def_enable check

Name: terminology
Version: %ver_major.0
Release: alt1

Summary: EFL terminal emulator
License: BSD
Group: Terminals
Url: http://www.enlightenment.org/p.php?p=about/terminology

%if_disabled snapshot
Source: https://download.enlightenment.org/rel/apps/%name/%name-%version.tar.xz
#Source: https://fau.re/terminology/%name-%version.tar.xz
%else
#VCS: https://git.enlightenment.org/apps/terminology.git
Source: %name-%version.tar
%endif
Patch: %name-1.0.0-alt-default_font.patch

Requires: fonts-bitmap-terminus
Provides: xvt

BuildRequires(pre): meson
Conflicts: libelementary < 1.20.0
BuildRequires: efl-libs-devel
BuildRequires: libelementary-devel >= 1.20.0

%description
An EFL terminal emulator with some extra bells and whistles. It's brand
new and was only started near the begining of June 2012, so expecting it
to do everything a mature terminal emulator does is a bit premature, but
considering it's young age, it does a lot.

%prep
%setup
%patch -b .def_font

%build
%meson %{?_enable_check:-Dtests=true}
%meson_build

%install
%meson_install

# alternatives
mkdir -p %buildroot%_altdir
cat >%buildroot%_altdir/%name <<EOF
%_bindir/xvt	%_bindir/%name	30
EOF

%find_lang %name

%check
%meson_test

%files -f %name.lang
%_bindir/*
%_desktopdir/*
%_datadir/%name/
%_altdir/%name
%_iconsdir/hicolor/*/*/%name.png
%_man1dir/*
%doc AUTHORS ChangeLog COPYING README.md

%changelog
