Name: texinfo
Version: 6.5
Release: alt2

Summary: Tools needed to create Texinfo format documentation files
License: GPL-3.0-or-later
Group: Publishing
Url: http://www.gnu.org/software/texinfo/

# ftp://ftp.gnu.org/gnu/texinfo/texinfo-%version.tar.xz
Source0: texinfo-%version.tar
Source1: update-info-dir
Source2: update-info-dir.8
Source3: info-dir.filetrigger
Source4: info-install.macros
Source5: install_info
Source6: uninstall_info
Source7: texi2pdf
Source8: texi2pdf.man

Patch1: texinfo-alt-install-info-dot_exe.patch
Patch2: texinfo-alt-install-info-zio.patch
Patch3: texinfo-alt-install-info-rpm.patch
Patch4: texinfo-alt-texi2dvi-baroque-shells.patch
Patch5: texinfo-alt-texi2any-version.patch
Patch6: texinfo-alt-makeinfo-split-size.patch
Patch7: texinfo-alt-perl_vendor_libdir.patch
Patch8: texinfo-alt-tests.patch

Patch11: texinfo-deb-perl-fixes.patch
Patch12: texinfo-deb-Update-locale-handling-for-Perl-5.28.patch

Requires: makeinfo = %version-%release
Requires: texi2dvi = %version-%release

BuildRequires(pre): rpm-build-tex
BuildRequires: cvs bzlib-devel help2man libtinfo-devel libzio-devel zlib-devel
BuildRequires: perl-devel
BuildRequires: perl(Locale/Messages.pm)
BuildRequires: perl(Pod/Simple/PullParser.pm)
BuildRequires: perl(Text/Unidecode.pm)
BuildRequires: perl(Unicode/EastAsianWidth.pm)
BuildRequires: perl(Unicode/Normalize.pm)
%{?!_without_check:%{?!_disable_check:BuildRequires: gzip-utils /dev/pts}}

%package -n makeinfo
Summary: Utilities for translating texinfo source documentation to various other formats
Group: Publishing
Requires: rpm-macros-info-install = %version-%release

%package -n texi2dvi
Summary: Utilities for translating texinfo source documents to dvi, ps, and pdf
Group: Publishing
BuildArch: noarch
Requires: rpm-macros-info-install = %version-%release
# due to texi2pdf and %_texmfmain/tex/texinfo
Conflicts: tetex-core <= 0:2.0-alt8

%package -n info-install
Summary: A program to update the GNU texinfo config file
Group: System/Base
PreReq: libzio >= 0:0.1-alt4

%package -n info
Summary: A standalone tty-based reader for GNU texinfo documentation
Group: System/Base
Requires: info-install = %version-%release

%package -n rpm-macros-info-install
Summary: Set of RPM macros for packaging texinfo files
Group: System/Base
BuildArch: noarch

%description
Texinfo is a documentation system that can produce both online
information and printed output from a single source file.  Normally,
you'd have to write two separate documents: one for online help or other
online information and the other for a typeset manual or other printed
work.  Using Texinfo, you only need to write one source document.
Then when the work needs revision, you only have to revise one source
document.  The GNU Project uses the Texinfo file format for most of its
documentation.

%description -n makeinfo
This package contains texi2all a.k.a. makeinfo - a translator of
texinfo source documentation to various other formats.

%description -n texi2dvi
This package contains texi2dvi and related utilities for translating
texinfo source documents to dvi, ps, and pdf.

%description -n info
The GNU project uses the texinfo file format for much of its
documentation.  The info package provides a standalone tty-based browser
program for viewing texinfo files.

%description -n info-install
This packages contains install-info - a program to update menu entries
in the Info system config files.

%description -n rpm-macros-info-install
This packages contains new RPM macros for packaging texinfo files.

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1

%patch11 -p1
%patch12 -p1

install -pm755 %_sourcedir/texi2pdf util/

%build
rm po/*.gmo po/stamp*
find -name configure.ac -printf '%%h\n' |while read dir; do
	pushd "$dir"
	rm aclocal.m4
	%autoreconf
	popd
done
%configure \
	--with-external-libintl-perl \
	--with-external-Text-Unidecode \
	--with-external-Unicode-EastAsianWidth \
	--enable-perl-xs \
	#
%make_build MAKEINFOFLAGS=--no-split \
	perl_vendor_privlibdir=%perl_vendor_privlib \
	perl_vendor_archlibdir=%perl_vendor_archlib \
	#
xz -k9 NEWS

%install
%makeinstall_std install-tex \
	TEXMF=%_texmfmain MAKEINFOFLAGS=--no-split \
	perl_vendor_privlibdir=%perl_vendor_privlib \
	perl_vendor_archlibdir=%perl_vendor_archlib \
	#

# these files shouldn't be packaged
rm %buildroot%perl_vendor_archlib/Texinfo/Convert/XSParagraph/*.{l,}a
rm %buildroot%perl_vendor_privlib/Texinfo/Convert/XSParagraph/TestXS.pm

# generic/epsf/epsf.tex is packaged in tetex and texlive
rm -r %buildroot%_texmfmain/tex/generic

# Install catalogue.
mkdir -p %buildroot%_sysconfdir
touch %buildroot%_sysconfdir/info-dir{,.old}
ln -fnrs %buildroot%_sysconfdir/info-dir %buildroot%_infodir/dir

# Relocate install-info.
mkdir -p %buildroot/sbin
mv %buildroot%_bindir/install-info %buildroot/sbin/

# Install info-dir filetrigger.
mkdir -p %buildroot%_rpmlibdir
install -pm755 %_sourcedir/info-dir.filetrigger %buildroot%_rpmlibdir/

# Install new rpm macros.
install -pDm644 %_sourcedir/info-install.macros %buildroot%_rpmmacrosdir/info-install

# Install install_info and uninstall_info stub scripts.
mkdir -p %buildroot%_sbindir
install -pm755 %_sourcedir/{,un}install_info %buildroot%_sbindir/

install -pm644 %_sourcedir/texi2pdf.man %buildroot%_man1dir/texi2pdf.1
install -pm755 %_sourcedir/update-info-dir %buildroot%_sbindir/
mkdir -p %buildroot%_man8dir
install -pm644 %_sourcedir/update-info-dir.8 %buildroot%_man8dir/

%find_lang --output=texinfo.lang texinfo texinfo_document

%check
export ALL_TESTS=yes LANG=en_US.utf8
%make_build -k check VERBOSE=1
unset ALL_TESTS LANG

%files -f texinfo.lang
%doc AUTHORS NEWS.* README TODO

%files -n makeinfo
%_bindir/makeinfo
%_bindir/texi2any
%_bindir/pod2texi
%_man1dir/makeinfo.*
%_man1dir/texi2any.*
%_man1dir/pod2texi.*
%_man5dir/texinfo.*
%_infodir/texinfo.*
%_datadir/texinfo/
%perl_vendor_archlib/Texinfo/
%perl_vendor_privlib/*Texinfo/
%perl_vendor_privlib/Pod/Simple/*

%files -n texi2dvi
%_bindir/*texi2dvi
%_bindir/texi2pdf
%_bindir/texindex
%_man1dir/*texi2dvi.*
%_man1dir/texi2pdf.*
%_man1dir/texindex.*
%_texmfmain/tex/texinfo/

%files -n info
%_bindir/info
%_mandir/man?/info.*
%_infodir/info*.info*

%files -n info-install
%config(noreplace) %verify(not md5 mtime size) %ghost %_sysconfdir/info-dir*
%_rpmlibdir/*.filetrigger
/sbin/install-info
%_sbindir/*
%_infodir/dir
%_mandir/man?/install-info.*
%_man8dir/update-info-dir.*

%files -n rpm-macros-info-install
%_rpmmacrosdir/*

%changelog
