Name: thunar
Version: 1.8.17
Release: alt1

Summary: Thunar File Manager for the Xfce Desktop Environment
Summary (ru_RU.UTF-8): Файловый менеджер Thunar
Group: Graphical desktop/XFce
License: GPLv2+ and LGPLv2+
Url: https://docs.xfce.org/xfce/thunar/start
Packager: Xfce Team <xfce@packages.altlinux.org>

Vcs: https://gitlab.xfce.org/xfce/thunar.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires(pre): rpm-build-xfce4 >= 0.1.0

BuildPreReq: xfce4-dev-tools
BuildPreReq: libxfce4panel-gtk3-devel >= 4.8 libxfconf-devel >= 4.8 libexo-gtk3-devel libxfce4ui-gtk3-devel
BuildRequires: gtk-doc intltool libSM-devel libexif-devel libgamin-devel libpcre-devel time
BuildRequires: libnotify4-devel libgudev-devel
BuildRequires: desktop-file-utils

%define _unpackaged_files_terminate_build 1

Requires: lib%name = %version-%release
Requires: eject
Requires: exo-utils

Obsoletes: Thunar < 1.3.1
Provides: Thunar = %version-%release

%description
Thunar File Manager for the Xfce desktop environment.

%description -l ru_RU.UTF-8
Файловый менеджер Thunar используемый в окружении рабочего стола Xfce.

%package -n lib%name-devel
Summary: Development files for %name
Group: Graphical desktop/XFce
License: LGPLv2+
Requires: lib%name = %version-%release
Obsoletes: libThunar-devel < 1.3.1
Provides: libThunar-devel = %version-%release

%description -n lib%name-devel
This package contains development files required to build
%name-based software.

%package -n lib%name
Summary: Shared libraries for %name
Group: Graphical desktop/XFce
License: LGPLv2+
Obsoletes: libThunar < 1.3.1
Provides: libThunar = %version-%release

%description -n lib%name
This package contains libraries for %name.

%package -n lib%name-devel-doc
Summary: Development documentation for lib%name
Group: Development/Documentation
License: GFDL-1.1+
BuildArch: noarch

%description -n lib%name-devel-doc
This package contains development documentation for lib%name.

%prep
%setup
%patch -p1

# Don't use git tag in version.
%xfce4_drop_gitvtag thunar_version_tag configure.ac.in

mkdir -p m4/

%build
%xfce4reconf
%configure \
	--disable-static \
	--enable-maintainer-mode \
	--enable-largefile \
	--enable-exif \
	--enable-pcre \
	--enable-gio-unix \
	--enable-gtk-doc \
	--enable-debug=minimum
%make_build

%install
%makeinstall_std
%find_lang thunar
desktop-file-install --dir %buildroot%_desktopdir \
	--remove-category=Filesystem \
	--add-category=FileTools \
	%buildroot%_desktopdir/thunar-bulk-rename.desktop

%check
make check

%files -f thunar.lang
%doc README NEWS AUTHORS
%config(noreplace) %_sysconfdir/xdg/Thunar/
%_bindir/*
%_desktopdir/*
%_man1dir/*
%_pixmapsdir/*
%_datadir/dbus-1/services/*
%_datadir/polkit-1/actions/org.xfce.thunar.policy
%_datadir/metainfo/org.xfce.thunar.appdata.xml
%_datadir/Thunar
%_datadir/xfce4/panel/plugins/*.desktop
%_usr/lib/systemd/user/thunar.service
%_libdir/xfce4/panel/plugins/*.so
%exclude %_libdir/xfce4/panel/plugins/*.la
%dir %_libdir/thunarx-*/
%_libdir/thunarx-*/*.so
%_libdir/Thunar/
%_iconsdir/hicolor/*/*/*
%_docdir/thunar

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_pkgconfigdir/*.pc
%_includedir/thunarx-*/
%_libdir/*.so

%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/*

%exclude %_libdir/thunarx-*/*.la

%changelog
