%define r_name thunderbird
%def_with bundled_cbindgen
%def_with mach_build
%ifndef build_parallel_jobs
%define build_parallel_jobs 32
%endif

%define gst_version   1.0
%define nspr_version  4.33
%define nss_version   3.77
%define rust_version  1.60.0
%define cargo_version 1.60.0
%define llvm_version  12.0

Name: 	 thunderbird
Version: 102.11.0
Release: alt0.c9.1

Summary: Thunderbird is Mozilla's e-mail client
License: MPL-2.0
Group: 	 Networking/Mail
URL: 	 https://www.thunderbird.net

Packager: Andrey Cherepanov <cas@altlinux.org>

Source0: %name-%version.tar
Source2: rpm.macros
Source3: thunderbird.desktop
Source4: thunderbird-mozconfig
Source5: thunderbird-default-prefs.js
Source6: l10n.tar
# Get $HOME/.cargo after run cargo install cbindgen (without bin/cbindgen)
Source7: cbindgen-vendor.tar
Source8: thunderbird-wayland.desktop

Patch12: alt-use-vorbis-on-arm-too.patch
Patch13: thunderbird-alt-fix-redefinition-double_t.patch

Patch21: mozilla-1353817.patch
Patch23: build-aarch64-skia.patch
Patch29: thunderbird-60.7.2-alt-ppc64le-disable-broken-getProcessorLineSize-code.patch
Patch30: thunderbird-68.2.2-alt-ppc64le-fix-clang-error-invalid-memory-operand.patch
Patch31:  mozilla-1512162.patch
# https://salsa.debian.org/mozilla-team/thunderbird/-/blob/debian/experimental/debian/patches/porting-armhf/Bug-1526653-Include-struct-definitions-for-user_vfp-and-u.patch
Patch32: Bug-1526653-Include-struct-definitions-for-user_vfp-and-u.patch
Patch33: Don-t-auto-disable-extensions-in-system-directories.patch
Patch34: Set-javascript.options.showInConsole.patch
Patch35: Allow-.js-preference-files-to-set-locked-prefs-with-lockP.patch
Patch36: Bug-1556197-amend-Bug-1544631-for-fixing-mips32.patch
Patch38: Bug-628252-os2.cc-fails-to-compile-against-GCC-4.6-m.patch
Patch39: Load-dependent-libraries-with-their-real-path-to-avo.patch
Patch40: Properly-launch-applications-set-in-HOME-.mailcap.patch
Patch41: fix-function-nsMsgComposeAndSend-to-respect-Replo.patch
Patch42: fix-packed_simd_2.patch
Patch43: set-def-event_sizeof_time_t.patch

ExcludeArch: armh

# Hang up on build browser/components/about
#ExcludeArch: ppc64le

BuildRequires(pre): mozilla-common-devel
BuildRequires(pre): rpm-build-mozilla.org
BuildRequires(pre): browser-plugins-npapi-devel

BuildRequires: clang%llvm_version
BuildRequires: clang%llvm_version-devel
BuildRequires: llvm%llvm_version-devel
BuildRequires: lld%llvm_version-devel
%ifarch armh %{ix86}
BuildRequires: gcc
BuildRequires: gcc-c++
%endif
BuildRequires: libstdc++-devel
BuildRequires: rpm-macros-alternatives
BuildRequires: rust >= %rust_version
BuildRequires: rust-cargo >= %cargo_version
BuildRequires: libXt-devel libX11-devel libXext-devel libXft-devel libXScrnSaver-devel
BuildRequires: libXcursor-devel
BuildRequires: libXi-devel
BuildRequires: libXcomposite-devel
BuildRequires: libXdamage-devel
BuildRequires: libcurl-devel libgtk+2-devel libgtk+3-devel libhunspell-devel libjpeg-devel
BuildRequires: xorg-cf-files chrpath alternatives yasm
BuildRequires: zip unzip
BuildRequires: bzlib-devel zlib-devel
BuildRequires: libcairo-devel libpixman-devel
BuildRequires: libGL-devel
BuildRequires: libwireless-devel
BuildRequires: libalsa-devel
BuildRequires: libnotify-devel
BuildRequires: libevent-devel
BuildRequires: libproxy-devel
BuildRequires: libshell
BuildRequires: libvpx-devel
BuildRequires: libgio-devel
BuildRequires: libfreetype-devel fontconfig-devel
BuildRequires: libstartup-notification-devel
BuildRequires: libffi-devel
BuildRequires: gstreamer%gst_version-devel gst-plugins%gst_version-devel
BuildRequires: libopus-devel
BuildRequires: libpulseaudio-devel
#BuildRequires: libicu-devel
BuildRequires: libdbus-devel libdbus-glib-devel
BuildRequires: node
BuildRequires: nasm
BuildRequires: libxkbcommon-devel
BuildRequires: libdrm-devel
# 91.0
BuildRequires: libaom-devel
BuildRequires: libdav1d-devel

BuildRequires: pkgconfig(alsa)
BuildRequires: pkgconfig(aom)
BuildRequires: pkgconfig(bzip2)
BuildRequires: pkgconfig(cairo)
BuildRequires: pkgconfig(dav1d)
BuildRequires: pkgconfig(dbus-1)
BuildRequires: pkgconfig(dbus-glib-1)
BuildRequires: pkgconfig(dri)
BuildRequires: pkgconfig(fontconfig)
BuildRequires: pkgconfig(freetype2)
BuildRequires: pkgconfig(gio-2.0)
BuildRequires: pkgconfig(graphite2)
BuildRequires: pkgconfig(gtk+-2.0)
BuildRequires: pkgconfig(gtk+-3.0)
BuildRequires: pkgconfig(harfbuzz)
BuildRequires: pkgconfig(hunspell)
BuildRequires: pkgconfig(icu-i18n)
BuildRequires: pkgconfig(libcurl)
BuildRequires: pkgconfig(libdrm)
BuildRequires: pkgconfig(libevent)
BuildRequires: pkgconfig(libffi)
BuildRequires: pkgconfig(libjpeg)
BuildRequires: pkgconfig(libnotify)
BuildRequires: pkgconfig(libproxy-1.0)
BuildRequires: pkgconfig(libpulse)
BuildRequires: pkgconfig(libstartup-notification-1.0)
BuildRequires: pkgconfig(opus)
BuildRequires: pkgconfig(pixman-1)
BuildRequires: pkgconfig(vpx)
BuildRequires: pkgconfig(x11)
BuildRequires: pkgconfig(xcomposite)
BuildRequires: pkgconfig(xcursor)
BuildRequires: pkgconfig(xdamage)
BuildRequires: pkgconfig(xext)
BuildRequires: pkgconfig(xft)
BuildRequires: pkgconfig(xi)
BuildRequires: pkgconfig(xkbcommon)
BuildRequires: pkgconfig(xrandr)
BuildRequires: pkgconfig(xscrnsaver)
BuildRequires: pkgconfig(xt)
BuildRequires: pkgconfig(xtst)
BuildRequires: pkgconfig(zlib)

# Python requires
BuildRequires: /dev/shm

BuildRequires: python-module-setuptools
BuildRequires: python-modules-compiler
BuildRequires: python-modules-logging
BuildRequires: python-modules-sqlite3
BuildRequires: python-modules-json

BuildRequires: python3-base
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-pip
BuildRequires: python3-modules-sqlite3

# Rust requires
BuildRequires: /proc

# Mozilla requires
BuildRequires: pkgconfig(nspr) >= %nspr_version
BuildRequires: pkgconfig(nss) >= %nss_version
BuildRequires: libnss-devel-static

BuildRequires: autoconf_2.13
%set_autoconf_version 2.13

Provides: mailclient
Obsoletes: thunderbird-calendar
Obsoletes: thunderbird-calendar-timezones

Provides: thunderbird-gnome-support = %EVR
Obsoletes: thunderbird-gnome-support

Requires: hunspell-en
Requires: browser-plugins-npapi

Provides: %name-esr = %EVR
Obsoletes: %name-esr < %EVR
Provides:  %name-lightning = %EVR
Obsoletes: %name-lightning < %EVR
Provides:  %name-lightning-ru = %EVR
Obsoletes: %name-lightning-ru < %EVR
Provides:  %name-esr-lightning = %EVR
Obsoletes: %name-esr-lightning < %EVR
Provides:  %name-esr-lightning-ru = %EVR
Obsoletes: %name-esr-lightning-ru < %EVR
Provides:  %name-ru = %EVR
Obsoletes: %name-ru < %EVR
Provides: %name-enigmail = %EVR
Obsoletes: %name-enigmail < %EVR

# Protection against fraudulent DigiNotar certificates
Requires: libnss >= 3.13.1-alt1

# ALT #40907
Requires: libotr5

%define tbird_cid        \{3550f703-e582-4d05-9a08-453d09bdfdc6\}
%define tbird_prefix     %_libdir/%r_name
%define tbird_datadir    %_datadir/%r_name
%define tbird_idldir     %_datadir/idl/%r_name
%define tbird_includedir %_includedir/%r_name
%define tbird_develdir   %tbird_prefix-devel

%description
Thunderbird is Mozilla's next generation e-mail client. Thunderbird makes
emailing safer, faster and easier than ever before and can also scale to meet
the most sophisticated organizational needs.

The package contains Lightning - an integrated calendar for Thunderbird.

%package wayland
Summary: Thunderbird Wayland launcher
Group: Networking/Mail
#BuildArch: noarch
Requires: %name

%description wayland
The thunderbird-wayland package contains launcher and desktop file
to run Thunderbird natively on Wayland.

%package -n rpm-build-%name
Summary:  RPM helper macros to rebuild thunderbird packages
Group: Development/Other
#BuildArch: noarch

Requires: mozilla-common-devel
Requires: rpm-build-mozilla.org

%description -n rpm-build-%name
These helper macros provide possibility to rebuild
thunderbird packages by some Alt Linux Team Policy compatible way.

%prep
%setup -q
tar -xf %SOURCE6
%patch12 -p2
%patch13 -p2
%patch21 -p2
%patch23 -p2
%patch29 -p2
%patch30 -p2
%patch31 -p2
%ifarch %arm
%patch32 -p1
%endif
%patch33 -p1
%patch34 -p1
%patch35 -p1
%patch36 -p1
%patch38 -p1
%patch39 -p2
%patch40 -p1
# %patch42 -p2
%patch43 -p2

#echo %version > mail/config/version.txt

cp -f %SOURCE4 .mozconfig
cat >> .mozconfig <<'EOF'
ac_add_options --prefix="%_prefix"
ac_add_options --libdir="%_libdir"
%ifnarch armh %{ix86} ppc64le
ac_add_options --enable-linker=lld
%endif
%ifnarch x86_64
ac_add_options --disable-webrtc
%endif
%ifarch armh %{ix86} x86_64
ac_add_options --disable-elf-hack
%endif
%ifarch armh
ac_add_options --disable-av1
ac_add_options --disable-rust-simd
%endif
EOF

# Non blocking stdout for NodeJS
cat > "/tmp/node-stdout-nonblocking-wrapper" << ENDL.
#!/bin/sh
exec /usr/bin/node "\$@" 2>&1 | cat -
ENDL.
chmod +x /tmp/node-stdout-nonblocking-wrapper
echo 'export NODEJS="/tmp/node-stdout-nonblocking-wrapper"' >> .mozconfig

sed -i -e '\,hyphenation/,d' comm/mail/installer/removed-files.in

%build
%define optflags_lto %nil
%add_optflags %optflags_shared
%add_optflags -lwayland-client
%add_findprov_lib_path %tbird_prefix

%if_with bundled_cbindgen
# compile cbindgen
CBINDGEN_HOME="$PWD/cbindgen"
CBINDGEN_BINDIR="$CBINDGEN_HOME/bin"

if [ ! -x "$CBINDGEN_BINDIR/cbindgen" ]; then
 mkdir -p -- "$CBINDGEN_HOME"

 tar --strip-components=1 -C "$CBINDGEN_HOME" --overwrite -xf %SOURCE7

 cat > "$CBINDGEN_HOME/config" <<-EOF
         [source.crates-io]
         replace-with = "vendored-sources"

         [source.vendored-sources]
         directory = "$CBINDGEN_HOME"
EOF

 env CARGO_HOME="$CBINDGEN_HOME" \
         cargo install cbindgen
fi
%endif

# Add fake RPATH
rpath="/$(printf %%s '%tbird_prefix' |tr '[:print:]' '_')"
export LDFLAGS="$LDFLAGS -Wl,-rpath,$rpath"
export LIBIDL_CONFIG=/usr/bin/libIDL-config-2

export MOZ_BUILD_APP=mail

# -fpermissive is needed to build with gcc 4.6+ which has become stricter
#
# Mozilla builds with -Wall with exception of a few warnings which show up
# everywhere in the code; so, don't override that.
#
# Disable C++ exceptions since Mozilla code is not exception-safe
#
MOZ_OPT_FLAGS=$(echo "%optflags -g0 -fpermissive" | \
               sed -e 's/-Wall//' -e 's/-fexceptions/-fno-exceptions/g' \
               -e 's/-frecord-gcc-switches/-grecord-gcc-switches/')
# Disable null pointer gcc6 optimization - workaround for
# https://bugzilla.mozilla.org/show_bug.cgi?id=1278795
MOZ_OPT_FLAGS="$MOZ_OPT_FLAGS -fno-delete-null-pointer-checks"
export MOZ_DEBUG_FLAGS=" "
export CFLAGS="$MOZ_OPT_FLAGS"
export CXXFLAGS="$MOZ_OPT_FLAGS"

%ifarch aarch64 x86_64
export CFLAGS="$CFLAGS -DHAVE_USR_LIB64_DIR=1"
%endif

%ifarch %{arm} %{ix86}
export RUSTFLAGS="-Cdebuginfo=0"
export LLVM_PARALLEL_LINK_JOBS=1
# See https://lwn.net/Articles/797303/ for linker flags
# For bfd on i586
export CXXFLAGS="$CXXFLAGS -Wl,--no-keep-memory -Wl,--reduce-memory-overheads -Wl,--hash-size=1021"
# For gold on i586
#export CXXFLAGS="$CXXFLAGS -Wl,--no-threads -Wl,--no-keep-files-mapped -Wl,--no-map-whole-files -Wl,--no-mmap-output-file -Wl,--stats"
%endif

%ifarch armh
export CC="gcc"
export CXX="g++"
%else
export CC="clang"
export CXX="clang++"
export AR="llvm-ar"
export NM="llvm-nm"
export RANLIB="llvm-ranlib"
export LLVM_PROFDATA="llvm-profdata"
%endif
export PREFIX='%_prefix'
export LIBDIR='%_libdir'
export INCLUDEDIR='%_includedir'
export LIBIDL_CONFIG='/usr/bin/libIDL-config-2'
export srcdir="$PWD"
export SHELL=/bin/sh
export MOZILLA_OBJDIR="$PWD"
export PATH="$CBINDGEN_BINDIR:$PATH"

# Do not use desktop notify during build process
export MOZ_NOSPAM=1

# Don't throw "old profile" dialog box
export MOZ_ALLOW_DOWNGRADE=1

export NPROCS=%build_parallel_jobs
# Decrease NPROCS prevents oomkill terror on x86_64
%ifarch x86_64
export NPROCS=16
%endif
# Build for i586 in one thread
%ifarch armh %ix86
export NPROCS=8
%endif

#python3 ./mach python --exec-file /dev/null
export MACH_BUILD_PYTHON_NATIVE_PACKAGE_SOURCE=system
./mach configure

%if_with mach_build
./mach build -j $NPROCS
./mach buildsymbols
%else
make -f client.mk \
	STRIP="/bin/true" \
	mozappdir=%buildroot%tbird_prefix \
	OBJDIR=objdir \
	TOPSRCDIR=$srcdir \
	MOZ_PARALLEL_BUILD=$NPROCS
	MACH=1 \
	build
%endif

MOZ_LANGPACK_ID="$(grep MOZ_LANGPACK_EID comm/mail/locales/Makefile.in | cut -f2 -d @)"
pushd l10n
for LANG in *; do
	USED_LANGPACK_ID=$(grep langpack- ${LANG}/manifest.json | tr '"' ' ' | awk '{print $3}' | cut -f2-3 -d @)
	if [ "${USED_LANGPACK_ID}" != "${MOZ_LANGPACK_ID}" ]; then
		echo "MOZ_LANGPACK_ID mismatch! '${USED_LANGPACK_ID}' != '${MOZ_LANGPACK_ID}'" ;
		echo "thunderbird-l10n l10n source '${LANG}' uses a different MOZ_LANGPACK_ID than defined in comm/mail/locales/Makefile.in!";
		exit 1 ;
	fi
done
popd

%install
export SHELL=/bin/sh
mkdir -p \
	%buildroot/%_bindir \
	%buildroot/%mozilla_arch_extdir/%tbird_cid \
	%buildroot/%mozilla_noarch_extdir/%tbird_cid \
	%buildroot/%_datadir/applications \
	#

%makeinstall -C objdir \
	idldir=%buildroot/%tbird_idldir \
	includedir=%buildroot/%tbird_includedir \
	mozappdir=%buildroot/%tbird_prefix \
	#

MOZ_LANGPACK_ID="$(grep MOZ_LANGPACK_EID comm/mail/locales/Makefile.in | cut -f2 -d @)"
pushd l10n
for LANG in * ; do
	locale=$(basename ${LANG})
	lowercase_locale=$(echo ${locale} | tr 'A-Z' 'a-z')
	echo "preparing and working on 'thunderbird-l10n-${lowercase_locale}  (langpack-${locale}@${MOZ_LANGPACK_ID}.xpi)"
	mkdir -p %buildroot/%mozilla_noarch_extdir/%tbird_cid/langpack-${locale}@${MOZ_LANGPACK_ID}
	cp -rf $LANG/* %buildroot/%mozilla_noarch_extdir/%tbird_cid/langpack-${locale}@${MOZ_LANGPACK_ID}/
done
popd

(set +x
	for f in %buildroot/%tbird_develdir/*; do
		[ -L "$f" ] || continue

		t="$(readlink "$f")"
		r="$(relative "${t#%buildroot}" "${f#%buildroot}")"

		ln -vnsf -- "$r" "$f"
	done
)

(set +x
	mkdir -pv %buildroot/%tbird_prefix/dictionaries
	rm -vrf -- %buildroot/%tbird_prefix/dictionaries/*
	for suf in aff dic; do
		t="$(relative %_datadir/myspell/en_US.$suf %tbird_prefix/dictionaries/)"
		ln -vs "$t" %buildroot/%tbird_prefix/dictionaries/en-US.$suf
	done
)

rm -rf -- \
	%buildroot/%_bindir/thunderbird \
	%buildroot/%tbird_prefix/js \
	%buildroot/%tbird_prefix/regxpcom \
	%buildroot/%tbird_prefix/xpcshell \
	%buildroot/%tbird_prefix/xpidl \
	%buildroot/%tbird_prefix/xpt_dump \
	%buildroot/%tbird_prefix/xpt_link \
	%buildroot/%tbird_prefix/nsinstall \
	%buildroot/%tbird_prefix/removed-files \
	%buildroot/%tbird_prefix/thunderbird \
	%buildroot/%tbird_prefix/run-mozilla.sh \
	%buildroot/%tbird_prefix/README.txt \
	#

# desktop files
install -Dpm644 %SOURCE3 %buildroot/%_desktopdir/thunderbird.desktop
install -Dpm644 %SOURCE8 %buildroot/%_desktopdir/thunderbird-wayland.desktop

# install altlinux-specific configuration
install -Dpm644 %SOURCE5 %buildroot/%tbird_prefix/defaults/pref/all-altlinux.js

# icons
for s in 16 22 24 32 48 64 128 256; do
	install -Dpm644 \
		comm/mail/branding/thunderbird/default$s.png \
		%buildroot/%_iconsdir/hicolor/${s}x${s}/apps/thunderbird.png
done
install -Dm644 comm/mail/branding/thunderbird/TB-symbolic.svg \
        %buildroot%_iconsdir/hicolor/symbolic/apps/thunderbird-symbolic.svg

# main startup script
cat>%buildroot/%_bindir/thunderbird<<-EOF
	#!/bin/sh -e
	export MOZ_APP_LAUNCHER="\${MOZ_APP_LAUNCHER:-\$0}"
	export MOZ_PLUGIN_PATH="%browser_plugins_path\${MOZ_PLUGIN_PATH:+:\$MOZ_PLUGIN_PATH}"
	export NSS_SSL_ENABLE_RENEGOTIATION=1
	%tbird_prefix/thunderbird-bin \${1:+"\$@"}
EOF
chmod 755 %buildroot/%_bindir/thunderbird

# rpm-build-thunderbird files
mkdir -p %buildroot%_rpmmacrosdir
cat %SOURCE2 | \
  sed -e 's,@tbird_version@,%version,' \
      -e 's,@tbird_release@,%release,' \
    > %buildroot%_rpmmacrosdir/%r_name

# Add real RPATH
(set +x
	rpath="/$(printf %%s '%tbird_prefix' |tr '[:print:]' '_')"

	find \
		%buildroot%tbird_prefix \
		%buildroot%mozilla_arch_extdir/%tbird_cid \
	-type f |
	while read f; do
		t="$(readlink -ev "$f")"

		file "$t" | fgrep -qs ELF || continue

		if chrpath -l "$t" | egrep -qs "R(UN)?PATH=$rpath"; then
			chrpath -r "%tbird_prefix" "$t"
		fi
	done
)

# Wrapper for wayland
cat > %buildroot%_bindir/thunderbird-wayland <<'EOF'
#!/bin/sh
export GDK_BACKEND=wayland
export MOZ_ENABLE_WAYLAND=1
export MOZ_GTK_TITLEBAR_DECORATION=client
export XDG_SESSION_TYPE=wayland

unset DISPLAY

exec %_bindir/thunderbird "$@"
EOF
chmod +x %buildroot%_bindir/thunderbird-wayland

%files
%doc AUTHORS
%_bindir/*
%exclude %_bindir/thunderbird-wayland
%tbird_prefix
%mozilla_arch_extdir/%tbird_cid
%mozilla_noarch_extdir/%tbird_cid
%defattr(0644,root,root,0755)
%_datadir/applications/%r_name.desktop
%_iconsdir/hicolor/*/apps/thunderbird.png
%_iconsdir/hicolor/symbolic/apps/thunderbird-symbolic.svg

%files wayland
%_bindir/thunderbird-wayland
%_datadir/applications/thunderbird-wayland.desktop

%files -n rpm-build-%name
%_rpmmacrosdir/%r_name

%changelog
