%def_disable debug
%def_disable devel
%def_disable profile
%def_enable shared
%def_enable static
#----------------------------------------------------------------------

%define Name Tokyo Tyrant
%define sname ttserver
Name: tokyotyrant
%define lname lib%name
Summary: A network interface of Tokyo Cabinet
Version: 1.1.40
Release: alt1.2
License: %lgpl2plus
Group: System/Libraries
Group: Databases
URL: http://1978th.net/%name
Source0: %url/%name-%version.tar
Source1: %name.init
Source2: %name.sysconfig
Patch: %name-%version-alt.patch
Provides: %name-server = %version-%release
Provides: %sname = %version-%release
Requires: %lname = %version-%release
Requires: libtokyocabinet >= 1.4.35

BuildRequires(pre): rpm-build-licenses

BuildRequires: libtokyocabinet-devel >= 1.4.35
BuildRequires: zlib-devel

%description
%Name is a network interface for Tokyo Cabinet.
This package contains %Name server.


%package utils
Summary: Command line tools for managing %Name
Group: Databases
Requires: %lname = %version-%release

%description utils
%Name is a network interface for Tokyo Cabinet.
This package contains command line tools for managing %Name.


%if_enabled shared
%package -n %lname
Summary: %Name library
Group: System/Libraries

%description -n %lname
%Name is a network interface for Tokyo Cabinet.
This package contains %Name sharerd library.
%endif


%package -n %lname-devel
Summary: Headers for developing programs that will use %lname
Group: Development/C
Requires: %lname%{?_disable_shared:-devel-static} = %version-%release

%description -n %lname-devel
%Name is a network interface for Tokyo Cabinet.
This package contains the libraries and header files needed for
developing with %lname.


%if_enabled static
%package -n %lname-devel-static
Summary: Static version of %Name database library
Group: Development/C
Requires: %lname-devel = %version-%release

%description -n %lname-devel-static
%Name is a network interface for Tokyo Cabinet.
This package contains static libraries for building statically linked
programs which use %Name.
%endif


%package doc
Summary: Documentation for %Name
Group: Documentation
BuildArch: noarch
Provides: %name-devel-man = %version-%release

%description doc
%Name is a network interface for Tokyo Cabinet.
This package contains documentation for developers.


%prep
%setup
%patch -p1


%build
%define _optlevel 3
%autoreconf
%configure \
    %{subst_enable debug} \
    %{subst_enable devel} \
    %{subst_enable profile} \
    %{subst_enable shared}
%make_build
bzip2 --best --keep --force -- ChangeLog


%install
%make_install DESTDIR=%buildroot install
rm -f %buildroot%_datadir/%name/COPYING
install -d -m 0755 %buildroot{%_docdir,%_sysconfdir/sysconfig,%_initdir,%_localstatedir/%name,%_logdir/%sname}
mv %buildroot{%_datadir/%name,%_docdir/%name-%version}
mv %buildroot{%_sbindir/*,%_docdir/%name-%version/}
install -m 0755 %SOURCE1 %buildroot%_initdir/%name
install -m 0644 %SOURCE2 %buildroot%_sysconfdir/sysconfig/%name


%pre
%_sbindir/groupadd -r -f _tyrant &>/dev/null ||:
%_sbindir/useradd -r -n -M -s /dev/null -d %_localstatedir/%name -g _tyrant \
    -c "Server of Tokyo Tyrant (%sname)" _tyrant &>/dev/null ||:


%post
%post_service %name ||:

%preun
%preun_service %name ||:


%files
%_bindir/%sname
%_man1dir/%sname.*
%_initdir/*
%config(noreplace) %_sysconfdir/sysconfig/*
%attr(770,root,_tyrant) %dir %_localstatedir/%name
%attr(770,root,_tyrant) %dir %_logdir/%sname


%files utils
%_bindir/*
%_man1dir/*
%exclude %_bindir/%sname
%exclude %_man1dir/%sname.*


%if_enabled shared
%files -n %lname
%_libdir/*.so.*
%endif


%files -n %lname-devel
%_includedir/*
%{?_enable_shared:%_libdir/*.so}
%_pkgconfigdir/*


%if_enabled static
%files -n %lname-devel-static
%_libdir/*.a
%endif


%files doc
%_docdir/%name-%version
%_man3dir/*


%changelog
