%define _cmake__builddir BUILD

Name:     touchegg
Version:  2.0.11
Release:  alt0.p9.1

Summary:  Linux multi-touch gesture recognizer
License:  GPL-3.0
Group:    Other
Url:      https://github.com/JoseExposito/touchegg

Packager: Andrey Cherepanov <cas@altlinux.org>

Source:   %name-%version.tar
Patch1:   touchegg-alt-remove-static.patch

BuildRequires(pre): rpm-build-ninja
BuildRequires(pre): cmake
BuildRequires: gcc-c++
BuildRequires: libXdmcp-devel
BuildRequires: libXrandr-devel
BuildRequires: libXtst-devel
BuildRequires: libcairo-devel
BuildRequires: libgtk+3-devel
BuildRequires: libinput-devel
BuildRequires: libpcre-devel
BuildRequires: libstdc++-devel-static
BuildRequires: libpugixml-devel
BuildRequires: libudev-devel
BuildRequires: libffi-devel
BuildRequires: libsystemd-devel

%description
Touchegg is an app that runs in the background and transform the gestures you
make on your touchpad into visible actions in your desktop.

%prep
%setup
#patch1 -p1

%build
%add_optflags -std=c++17
%cmake -GNinja -Wno-dev
%ninja_build -C BUILD

%install
%ninja_install -C BUILD

%preun
%preun_service %name

%post
%post_service %name

%files
%doc *.md
%_bindir/%name
%_sysconfdir/xdg/autostart/%name.desktop
%_datadir/%name
%_unitdir/%name.service

%changelog
